/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.simd.SIMDTypeFunctionBuiltins;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.SIMDType;

public final class SIMDBoolFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<SIMDTypeFunction> {
    protected final SIMDType simdContext;

    public SIMDBoolFunctionBuiltins(String typeName, SIMDType simdContext) {
        super(typeName, SIMDTypeFunction.class);
        this.simdContext = simdContext;
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SIMDTypeFunction builtinEnum) {
        switch (builtinEnum) {
            case allTrue: {
                return SIMDTypeFunctionBuiltins.SIMDAllTrueNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case and: {
                return SIMDTypeFunctionBuiltins.SIMDAndNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case anyTrue: {
                return SIMDTypeFunctionBuiltins.SIMDAnyTrueNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case check: {
                return SIMDTypeFunctionBuiltins.SIMDCheckNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case extractLane: {
                return SIMDTypeFunctionBuiltins.SIMDExtractLaneNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load1: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 1, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load2: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 2, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load3: {
                return SIMDTypeFunctionBuiltins.SIMDLoadNode.create(context, builtin, this.simdContext, 3, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case not: {
                return SIMDTypeFunctionBuiltins.SIMDNotNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case or: {
                return SIMDTypeFunctionBuiltins.SIMDOrNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case replaceLane: {
                return SIMDTypeFunctionBuiltins.SIMDReplaceLaneNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case select: {
                return SIMDTypeFunctionBuiltins.SIMDSelectNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case shuffle: {
                return SIMDTypeFunctionBuiltins.SIMDShuffleNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case splat: {
                return SIMDTypeFunctionBuiltins.SIMDSplatNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case store: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store1: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 1, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store2: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 2, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store3: {
                return SIMDTypeFunctionBuiltins.SIMDStoreNode.create(context, builtin, this.simdContext, 3, SIMDBoolFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case swizzle: {
                return SIMDTypeFunctionBuiltins.SIMDSwizzleNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case xor: {
                return SIMDTypeFunctionBuiltins.SIMDXorNode.create(context, builtin, this.simdContext, SIMDBoolFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum SIMDTypeFunction implements BuiltinEnum<SIMDTypeFunction>
    {
        splat(1),
        check(1),
        and(2),
        xor(2),
        or(2),
        not(2),
        anyTrue(1),
        allTrue(1),
        select(3),
        extractLane(2),
        replaceLane(3),
        store(3),
        store1(3),
        store2(3),
        store3(3),
        load(2),
        load1(2),
        load2(2),
        load3(2),
        swizzle(1),
        shuffle(2);

        private final int length;

        private SIMDTypeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

