/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InitErrorObjectNode.class)
public final class InitErrorObjectNodeFactory {

    @GeneratedBy(value=InitErrorObjectNode.DefineStackPropertyNode.class)
    static final class DefineStackPropertyNodeGen
    extends InitErrorObjectNode.DefineStackPropertyNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private DefineStackPropertyNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        void execute(DynamicObject arg0Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_) || !Assumption.isValidAssumption((Assumption)s1_.assumption1_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.removeCached_(s1_);
                            this.executeAndSpecialize(arg0Value);
                            return;
                        }
                        assert (s1_.shapeAfter_ != null);
                        if (arg0Value.getShape() == s1_.cachedShape_) {
                            this.doCached(arg0Value, s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    this.doUncached(arg0Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    Assumption assumption1;
                    Assumption assumption0;
                    Shape cachedShape__;
                    Shape shapeAfter__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            assert (s1_.shapeAfter_ != null);
                            if (!(arg0Value.getShape() != s1_.cachedShape_ || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption0_) || s1_.assumption1_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption1_))) break;
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (shapeAfter__ = InitErrorObjectNode.DefineStackPropertyNode.addStackProperty(cachedShape__ = arg0Value.getShape())) != null && arg0Value.getShape() == cachedShape__ && Assumption.isValidAssumption((Assumption)(assumption0 = cachedShape__.getValidAssumption())) && Assumption.isValidAssumption((Assumption)(assumption1 = shapeAfter__.getValidAssumption())) && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedShape_ = cachedShape__;
                        s1_.shapeAfter_ = shapeAfter__;
                        s1_.cachedProperty_ = shapeAfter__.getProperty((Object)"stack");
                        s1_.assumption0_ = assumption0;
                        s1_.assumption1_ = assumption1;
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value, s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_);
                        return;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doUncached(arg0Value);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCached_(Object s1_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedData prev = null;
                CachedData cur = this.cached_cache;
                while (cur != null) {
                    if (cur == s1_) {
                        if (prev == null) {
                            this.cached_cache = cur.next_;
                            break;
                        }
                        prev.next_ = cur.next_;
                        break;
                    }
                    prev = cur;
                    cur = cur.next_;
                }
                if (this.cached_cache == null) {
                    this.state_ &= 0xFFFFFFFE;
                }
            }
            finally {
                lock.unlock();
            }
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedShape_, s1_.shapeAfter_, s1_.cachedProperty_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doUncached";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static InitErrorObjectNode.DefineStackPropertyNode create() {
            return new DefineStackPropertyNodeGen();
        }

        @GeneratedBy(value=InitErrorObjectNode.DefineStackPropertyNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            Shape cachedShape_;
            @CompilerDirectives.CompilationFinal
            Shape shapeAfter_;
            @CompilerDirectives.CompilationFinal
            Property cachedProperty_;
            @CompilerDirectives.CompilationFinal
            Assumption assumption0_;
            @CompilerDirectives.CompilationFinal
            Assumption assumption1_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }
}

