/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSLeftShiftConstantNodeGen;
import com.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import com.oracle.truffle.js.nodes.binary.JSLeftShiftNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.Objects;
import java.util.Set;

@NodeInfo(shortName="<<")
public abstract class JSLeftShiftConstantNode
extends JSUnaryNode {
    protected final int shiftValue;

    protected JSLeftShiftConstantNode(JavaScriptNode operand, int shiftValue) {
        super(operand);
        this.shiftValue = shiftValue;
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        assert (right instanceof JSConstantNode.JSConstantIntegerNode);
        int shiftValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
        if (left instanceof JSConstantNode.JSConstantIntegerNode) {
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            return JSConstantNode.createInt(leftValue << shiftValue);
        }
        Truncatable.truncate(left);
        return JSLeftShiftConstantNodeGen.create(left, shiftValue);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.JSConstantIntegerNode.create(this.shiftValue);
            JSLeftShiftNode node = JSLeftShiftNodeGen.create(this.getOperand(), constantNode);
            JSLeftShiftConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSLeftShiftConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected int doInteger(int a) {
        return a << this.shiftValue;
    }

    @Specialization
    protected int doLargeInteger(LargeInteger a) {
        return a.intValue() << this.shiftValue;
    }

    @Specialization
    protected int doDouble(double a, @Cached(value="create()") JSToInt32Node leftInt32Node) {
        return leftInt32Node.executeInt(a) << this.shiftValue;
    }

    @Specialization
    protected void doBigInt(BigInt a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(replaces={"doInteger", "doLargeInteger", "doDouble", "doBigInt"})
    protected Object doGeneric(Object a, @Cached(value="create()") JSToNumericNode leftToNumericNode, @Cached(value="makeCopy()") JSLeftShiftConstantNode innerShiftNode) {
        Object numericLeft = leftToNumericNode.execute(a);
        return innerShiftNode.executeInt(numericLeft);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Integer.TYPE;
    }

    protected JSLeftShiftConstantNode makeCopy() {
        return (JSLeftShiftConstantNode)this.copyUninitialized();
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSLeftShiftConstantNodeGen.create(JSLeftShiftConstantNode.cloneUninitialized(this.getOperand()), this.shiftValue);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " << " + this.shiftValue + ")";
        }
        return null;
    }
}

