/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import java.util.Set;

@NodeInfo(shortName="switch")
public final class SwitchNode
extends StatementNode {
    @Node.Children
    private final JavaScriptNode[] caseExpressions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] jumptable;
    @Node.Children
    private final JavaScriptNode[] statements;

    private SwitchNode(JavaScriptNode[] caseExpressions, int[] jumptable, JavaScriptNode[] statements) {
        this.caseExpressions = new JavaScriptNode[caseExpressions.length];
        for (int i = 0; i < caseExpressions.length; ++i) {
            this.caseExpressions[i] = caseExpressions[i];
        }
        this.jumptable = jumptable;
        assert (caseExpressions.length == jumptable.length - 1);
        this.statements = statements;
    }

    public static SwitchNode create(JavaScriptNode[] caseExpressions, int[] jumptable, JavaScriptNode[] statements) {
        return new SwitchNode(caseExpressions, jumptable, statements);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.Conditional.name());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ControlFlowRootTag.class)) {
            JavaScriptNode[] newCaseExpressions = new JavaScriptNode[this.caseExpressions.length];
            for (int i = 0; i < this.caseExpressions.length; ++i) {
                InstrumentableNode materialized = this.caseExpressions[i].materializeInstrumentableNodes(materializedTags);
                newCaseExpressions[i] = JSTaggedExecutionNode.createForInput((JavaScriptNode)materialized, JSTags.ControlFlowBranchTag.class, JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Condition.name()));
            }
            JavaScriptNode[] newStatements = new JavaScriptNode[this.statements.length];
            for (int i = 0; i < this.statements.length; ++i) {
                InstrumentableNode materialized = this.statements[i].materializeInstrumentableNodes(materializedTags);
                newStatements[i] = JSTaggedExecutionNode.createFor((JavaScriptNode)materialized, JSTags.ControlFlowBlockTag.class);
            }
            SwitchNode materialized = SwitchNode.create(newCaseExpressions, this.jumptable, newStatements);
            SwitchNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int jumptableIdx = this.identifyTargetCase(frame);
        return this.executeStatements(frame, this.jumptable[jumptableIdx]);
    }

    @ExplodeLoop
    private int identifyTargetCase(VirtualFrame frame) {
        int i;
        for (i = 0; i < this.caseExpressions.length && !SwitchNode.executeConditionAsBoolean(frame, this.caseExpressions[i]); ++i) {
        }
        return i;
    }

    @ExplodeLoop
    private Object executeStatements(VirtualFrame frame, int statementStartIndex) {
        Object result = EMPTY;
        for (int statementIndex = 0; statementIndex < this.statements.length; ++statementIndex) {
            if (statementIndex < statementStartIndex) continue;
            result = this.statements[statementIndex].execute(frame);
        }
        return result;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return SwitchNode.create(SwitchNode.cloneUninitialized(this.caseExpressions), this.jumptable, SwitchNode.cloneUninitialized(this.statements));
    }
}

