/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.regexp.joni;

import com.oracle.truffle.regex.nashorn.regexp.joni.BitSet;
import com.oracle.truffle.regex.nashorn.regexp.joni.BitStatus;
import com.oracle.truffle.regex.nashorn.regexp.joni.Config;
import com.oracle.truffle.regex.nashorn.regexp.joni.EncodingHelper;
import com.oracle.truffle.regex.nashorn.regexp.joni.Option;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;
import com.oracle.truffle.regex.nashorn.regexp.joni.Region;
import com.oracle.truffle.regex.nashorn.regexp.joni.StackEntry;
import com.oracle.truffle.regex.nashorn.regexp.joni.StackMachine;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.CClassNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.encoding.IntHolder;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.InternalException;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.JoniInterruptedException;

class ByteCodeMachine
extends StackMachine {
    private int bestLen;
    private int s = 0;
    private int range;
    private int sstart;
    private final int[] code;
    private int ip;

    ByteCodeMachine(Regex regex, String chars, int p, int end) {
        super(regex, chars, p, end);
        this.code = regex.code;
    }

    private boolean stringCmpIC(int caseFoldFlag, int s1p, IntHolder ps2, int mbLen, int textEnd) {
        int s1 = s1p;
        int s2 = ps2.value;
        int end1 = s1 + mbLen;
        while (s1 < end1) {
            char c2;
            char c1;
            if ((c1 = EncodingHelper.toUpperCase(this.charAt(s1++))) == (c2 = EncodingHelper.toUpperCase(this.charAt(s2++)))) continue;
            return false;
        }
        ps2.value = s2;
        return true;
    }

    private void debugMatchBegin() {
        Config.log.println("match_at: str: " + this.str + ", end: " + this.end + ", start: " + this.sstart);
        Config.log.println("size: " + (this.end - this.str) + ", start offset: " + (this.sstart - this.str));
    }

    private void debugMatchLoop() {
    }

    @Override
    protected final int matchAt(int r, int ss) {
        this.range = r;
        this.sstart = ss;
        this.stk = 0;
        this.ip = 0;
        this.init();
        this.bestLen = -1;
        this.s = ss;
        int[] c = this.code;
        block73: while (true) {
            if (Thread.interrupted()) {
                throw new JoniInterruptedException();
            }
            switch (c[this.ip++]) {
                case 1: {
                    if (!this.opEnd()) continue block73;
                    return this.finish();
                }
                case 2: {
                    this.opExact1();
                    continue block73;
                }
                case 3: {
                    this.opExact2();
                    continue block73;
                }
                case 4: {
                    this.opExact3();
                    continue block73;
                }
                case 5: {
                    this.opExact4();
                    continue block73;
                }
                case 6: {
                    this.opExact5();
                    continue block73;
                }
                case 7: {
                    this.opExactN();
                    continue block73;
                }
                case 14: {
                    this.opExact1IC();
                    continue block73;
                }
                case 15: {
                    this.opExactNIC();
                    continue block73;
                }
                case 16: {
                    this.opCClass();
                    continue block73;
                }
                case 17: {
                    this.opCClassMB();
                    continue block73;
                }
                case 18: {
                    this.opCClassMIX();
                    continue block73;
                }
                case 19: {
                    this.opCClassNot();
                    continue block73;
                }
                case 20: {
                    this.opCClassMBNot();
                    continue block73;
                }
                case 21: {
                    this.opCClassMIXNot();
                    continue block73;
                }
                case 22: {
                    this.opCClassNode();
                    continue block73;
                }
                case 23: {
                    this.opAnyChar();
                    continue block73;
                }
                case 24: {
                    this.opAnyCharML();
                    continue block73;
                }
                case 25: {
                    this.opAnyCharStar();
                    continue block73;
                }
                case 26: {
                    this.opAnyCharMLStar();
                    continue block73;
                }
                case 27: {
                    this.opAnyCharStarPeekNext();
                    continue block73;
                }
                case 28: {
                    this.opAnyCharMLStarPeekNext();
                    continue block73;
                }
                case 29: {
                    this.opWord();
                    continue block73;
                }
                case 30: {
                    this.opNotWord();
                    continue block73;
                }
                case 31: {
                    this.opWordBound();
                    continue block73;
                }
                case 32: {
                    this.opNotWordBound();
                    continue block73;
                }
                case 33: {
                    this.opWordBegin();
                    continue block73;
                }
                case 34: {
                    this.opWordEnd();
                    continue block73;
                }
                case 35: {
                    this.opBeginBuf();
                    continue block73;
                }
                case 36: {
                    this.opEndBuf();
                    continue block73;
                }
                case 37: {
                    this.opBeginLine();
                    continue block73;
                }
                case 38: {
                    this.opEndLine();
                    continue block73;
                }
                case 39: {
                    this.opSemiEndBuf();
                    continue block73;
                }
                case 40: {
                    this.opBeginPosition();
                    continue block73;
                }
                case 49: {
                    this.opMemoryStartPush();
                    continue block73;
                }
                case 48: {
                    this.opMemoryStart();
                    continue block73;
                }
                case 51: {
                    this.opMemoryEndPush();
                    continue block73;
                }
                case 50: {
                    this.opMemoryEnd();
                    continue block73;
                }
                case 52: {
                    this.opMemoryClear();
                    continue block73;
                }
                case 41: {
                    this.opBackRef1();
                    continue block73;
                }
                case 42: {
                    this.opBackRef2();
                    continue block73;
                }
                case 43: {
                    this.opBackRefN();
                    continue block73;
                }
                case 44: {
                    this.opBackRefNIC();
                    continue block73;
                }
                case 45: {
                    this.opBackRefMulti();
                    continue block73;
                }
                case 46: {
                    this.opBackRefMultiIC();
                    continue block73;
                }
                case 47: {
                    this.opBackRefAtLevel();
                    continue block73;
                }
                case 66: {
                    this.opNullCheckStart();
                    continue block73;
                }
                case 67: {
                    this.opNullCheckEnd();
                    continue block73;
                }
                case 68: {
                    this.opNullCheckEndMemST();
                    continue block73;
                }
                case 55: {
                    this.opJump();
                    continue block73;
                }
                case 56: {
                    this.opPush();
                    continue block73;
                }
                case 57: {
                    this.opPop();
                    continue block73;
                }
                case 58: {
                    this.opPushOrJumpExact1();
                    continue block73;
                }
                case 59: {
                    this.opPushIfPeekNext();
                    continue block73;
                }
                case 60: {
                    this.opRepeat();
                    continue block73;
                }
                case 61: {
                    this.opRepeatNG();
                    continue block73;
                }
                case 62: {
                    this.opRepeatInc();
                    continue block73;
                }
                case 64: {
                    this.opRepeatIncSG();
                    continue block73;
                }
                case 63: {
                    this.opRepeatIncNG();
                    continue block73;
                }
                case 65: {
                    this.opRepeatIncNGSG();
                    continue block73;
                }
                case 70: {
                    this.opPushPos();
                    continue block73;
                }
                case 71: {
                    this.opPopPos();
                    continue block73;
                }
                case 72: {
                    this.opPushPosNot();
                    continue block73;
                }
                case 73: {
                    this.opFailPos();
                    continue block73;
                }
                case 74: {
                    this.opPushStopBT();
                    continue block73;
                }
                case 75: {
                    this.opPopStopBT();
                    continue block73;
                }
                case 76: {
                    this.opLookBehind();
                    continue block73;
                }
                case 77: {
                    this.opPushLookBehindNot();
                    continue block73;
                }
                case 78: {
                    this.opFailLookBehindNot();
                    continue block73;
                }
                case 0: {
                    return this.finish();
                }
                case 54: {
                    this.opFail();
                    continue block73;
                }
            }
            break;
        }
        throw new InternalException("undefined bytecode (bug)");
    }

    private boolean opEnd() {
        int n = this.s - this.sstart;
        if (n > this.bestLen) {
            if (Option.isFindLongest(this.regex.options)) {
                if (n > this.msaBestLen) {
                    this.msaBestLen = n;
                    this.msaBestS = this.sstart;
                } else {
                    return this.endBestLength();
                }
            }
            this.bestLen = n;
            Region region = this.msaRegion;
            if (region != null) {
                region.beg[0] = this.msaBegin = this.sstart - this.str;
                region.end[0] = this.msaEnd = this.s - this.str;
                for (int i = 1; i <= this.regex.numMem; ++i) {
                    if (this.repeatStk[this.memEndStk + i] != -1) {
                        region.beg[i] = BitStatus.bsAt(this.regex.btMemStart, i) ? this.stack[this.repeatStk[this.memStartStk + i]].getMemPStr() - this.str : this.repeatStk[this.memStartStk + i] - this.str;
                        region.end[i] = BitStatus.bsAt(this.regex.btMemEnd, i) ? this.stack[this.repeatStk[this.memEndStk + i]].getMemPStr() : this.repeatStk[this.memEndStk + i] - this.str;
                        continue;
                    }
                    region.end[i] = -1;
                    region.beg[i] = -1;
                }
            } else {
                this.msaBegin = this.sstart - this.str;
                this.msaEnd = this.s - this.str;
            }
        } else {
            Region region = this.msaRegion;
            if (region != null) {
                region.clear();
            } else {
                this.msaEnd = 0;
                this.msaBegin = 0;
            }
        }
        return this.endBestLength();
    }

    private boolean endBestLength() {
        if (Option.isFindCondition(this.regex.options)) {
            if (Option.isFindNotEmpty(this.regex.options) && this.s == this.sstart) {
                this.bestLen = -1;
                this.opFail();
                return false;
            }
            if (Option.isFindLongest(this.regex.options) && this.s < this.range) {
                this.opFail();
                return false;
            }
        }
        return true;
    }

    private void opExact1() {
        if (this.s >= this.range || this.code[this.ip] != this.charAt(this.s++)) {
            this.opFail();
            return;
        }
        ++this.ip;
    }

    private void opExact2() {
        if (this.s + 2 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExact3() {
        if (this.s + 3 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExact4() {
        if (this.s + 4 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExact5() {
        if (this.s + 5 > this.range) {
            this.opFail();
            return;
        }
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
        if (this.code[this.ip] != this.charAt(this.s)) {
            this.opFail();
            return;
        }
        ++this.ip;
        ++this.s;
    }

    private void opExactN() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        char[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen-- > 0) {
            if (bs[ps++] == this.charAt(this.s++)) continue;
            this.opFail();
            return;
        }
    }

    private void opExact1IC() {
        if (this.s >= this.range || this.code[this.ip] != EncodingHelper.toLowerCase(this.charAt(this.s++))) {
            this.opFail();
            return;
        }
        ++this.ip;
    }

    private void opExactNIC() {
        int tlen;
        if (this.s + (tlen = this.code[this.ip++]) > this.range) {
            this.opFail();
            return;
        }
        char[] bs = this.regex.templates[this.code[this.ip++]];
        int ps = this.code[this.ip++];
        while (tlen-- > 0) {
            if (bs[ps++] == EncodingHelper.toLowerCase(this.charAt(this.s++))) continue;
            this.opFail();
            return;
        }
    }

    private boolean isInBitSet() {
        char c = this.charAt(this.s);
        return c <= '\u00ff' && (this.code[this.ip + (c >>> BitSet.ROOM_SHIFT)] & '\u0001' << c) != 0;
    }

    private void opCClass() {
        if (this.s >= this.range || !this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
    }

    private boolean isInClassMB() {
        int ss;
        char c;
        int tlen = this.code[this.ip++];
        if (this.s >= this.range) {
            return false;
        }
        if (!EncodingHelper.isInCodeRange(this.code, this.ip, c = this.charAt(ss = this.s++))) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMB() {
        if (this.s >= this.range || this.charAt(this.s) <= '\u00ff') {
            this.opFail();
            return;
        }
        if (!this.isInClassMB()) {
            this.opFail();
            return;
        }
    }

    private void opCClassMIX() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.charAt(this.s) > '\u00ff') {
            this.ip += 8;
            if (!this.isInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (!this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
    }

    private void opCClassNot() {
        if (this.s >= this.range || this.isInBitSet()) {
            this.opFail();
            return;
        }
        this.ip += 8;
        ++this.s;
    }

    private boolean isNotInClassMB() {
        int ss;
        char c;
        int tlen = this.code[this.ip++];
        if (this.s + 1 > this.range) {
            if (this.s >= this.range) {
                return false;
            }
            this.s = this.end;
            this.ip += tlen;
            return true;
        }
        if (EncodingHelper.isInCodeRange(this.code, this.ip, c = this.charAt(ss = this.s++))) {
            return false;
        }
        this.ip += tlen;
        return true;
    }

    private void opCClassMBNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.charAt(this.s) <= '\u00ff') {
            ++this.s;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            return;
        }
        if (!this.isNotInClassMB()) {
            this.opFail();
            return;
        }
    }

    private void opCClassMIXNot() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (this.charAt(this.s) > '\u00ff') {
            this.ip += 8;
            if (!this.isNotInClassMB()) {
                this.opFail();
                return;
            }
        } else {
            if (this.isInBitSet()) {
                this.opFail();
                return;
            }
            this.ip += 8;
            int tlen = this.code[this.ip++];
            this.ip += tlen;
            ++this.s;
        }
    }

    private void opCClassNode() {
        int ss;
        char c;
        CClassNode cc;
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (!(cc = (CClassNode)this.regex.operands[this.code[this.ip++]]).isCodeInCCLength(c = this.charAt(ss = this.s++))) {
            this.opFail();
            return;
        }
    }

    private void opAnyChar() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        if (EncodingHelper.isNewLine(this.charAt(this.s))) {
            this.opFail();
            return;
        }
        ++this.s;
    }

    private void opAnyCharML() {
        if (this.s >= this.range) {
            this.opFail();
            return;
        }
        ++this.s;
    }

    private void opAnyCharStar() {
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s);
            if (this.isNewLineAt(this.s)) {
                this.opFail();
                return;
            }
            ++this.s;
        }
    }

    private void opAnyCharMLStar() {
        while (this.s < this.range) {
            this.pushAlt(this.ip, this.s);
            ++this.s;
        }
    }

    private void opAnyCharStarPeekNext() {
        char c = (char)this.code[this.ip];
        while (this.s < this.range) {
            char b = this.charAt(this.s);
            if (c == b) {
                this.pushAlt(this.ip + 1, this.s);
            }
            if (EncodingHelper.isNewLine(b)) {
                this.opFail();
                return;
            }
            ++this.s;
        }
        ++this.ip;
    }

    private void opAnyCharMLStarPeekNext() {
        char c = (char)this.code[this.ip];
        while (this.s < this.range) {
            if (c == this.charAt(this.s)) {
                this.pushAlt(this.ip + 1, this.s);
            }
            ++this.s;
        }
        ++this.ip;
    }

    private void opWord() {
        if (this.s >= this.range || !EncodingHelper.isWord(this.charAt(this.s))) {
            this.opFail();
            return;
        }
        ++this.s;
    }

    private void opNotWord() {
        if (this.s >= this.range || EncodingHelper.isWord(this.charAt(this.s))) {
            this.opFail();
            return;
        }
        ++this.s;
    }

    private void opWordBound() {
        if (this.isWordAt(this.s) == this.isWordAt(this.s - 1)) {
            this.opFail();
            return;
        }
    }

    private void opNotWordBound() {
        if (this.isWordAt(this.s) != this.isWordAt(this.s - 1)) {
            this.opFail();
            return;
        }
    }

    private void opWordBegin() {
        if (!this.isWordAt(this.s - 1) && this.isWordAt(this.s)) {
            return;
        }
        this.opFail();
    }

    private void opWordEnd() {
        if (this.isWordAt(this.s - 1) && !this.isWordAt(this.s)) {
            return;
        }
        this.opFail();
    }

    private void opBeginBuf() {
        if (this.s != this.str) {
            this.opFail();
        }
    }

    private void opEndBuf() {
        if (this.s != this.end) {
            this.opFail();
        }
    }

    private void opBeginLine() {
        if (this.s == this.str) {
            if (Option.isNotBol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.isNewLineAt(this.s - 1)) {
            return;
        }
        this.opFail();
    }

    private void opEndLine() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.isNewLineAt(this.s - 1)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.isNewLineAt(this.s)) {
            return;
        }
        this.opFail();
    }

    private void opSemiEndBuf() {
        if (this.s == this.end) {
            if ((this.str == this.end || !this.isNewLineAt(this.s - 1)) && Option.isNotEol(this.msaOptions)) {
                this.opFail();
            }
            return;
        }
        if (this.isNewLineAt(this.s) && this.s + 1 == this.end) {
            return;
        }
        this.opFail();
    }

    private void opBeginPosition() {
        if (this.s != this.msaStart) {
            this.opFail();
        }
    }

    private void opMemoryStartPush() {
        int mem = this.code[this.ip++];
        this.pushMemStart(mem, this.s);
    }

    private void opMemoryStart() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memStartStk + mem] = this.s;
    }

    private void opMemoryEndPush() {
        int mem = this.code[this.ip++];
        this.pushMemEnd(mem, this.s);
    }

    private void opMemoryEnd() {
        int mem = this.code[this.ip++];
        this.repeatStk[this.memEndStk + mem] = this.s;
    }

    private void opMemoryClear() {
        int fromMem = this.code[this.ip++];
        int toMem = this.code[this.ip++];
        for (int mem = fromMem; mem < toMem; ++mem) {
            if (BitStatus.bsAt(this.regex.btMemStart, mem)) {
                this.pushMemStart(mem, -1);
            } else {
                this.repeatStk[this.memStartStk + mem] = -1;
            }
            if (BitStatus.bsAt(this.regex.btMemEnd, mem)) {
                this.pushMemEnd(mem, -1);
                continue;
            }
            this.repeatStk[this.memEndStk + mem] = -1;
        }
    }

    private boolean backrefInvalid(int mem) {
        return this.repeatStk[this.memEndStk + mem] == -1 || this.repeatStk[this.memStartStk + mem] == -1;
    }

    private int backrefStart(int mem) {
        return BitStatus.bsAt(this.regex.btMemStart, mem) ? this.stack[this.repeatStk[this.memStartStk + mem]].getMemPStr() : this.repeatStk[this.memStartStk + mem];
    }

    private int backrefEnd(int mem) {
        return BitStatus.bsAt(this.regex.btMemEnd, mem) ? this.stack[this.repeatStk[this.memEndStk + mem]].getMemPStr() : this.repeatStk[this.memEndStk + mem];
    }

    private void backref(int mem, boolean ignoreCase) {
        int pstart;
        int pend;
        if (mem > this.regex.numMem) {
            this.opFail();
            return;
        }
        if (this.backrefInvalid(mem)) {
            pend = 0;
            pstart = 0;
        } else {
            pstart = this.backrefStart(mem);
            pend = this.backrefEnd(mem);
        }
        int n = pend - pstart;
        if (this.s + n > this.range) {
            this.opFail();
            return;
        }
        if (ignoreCase) {
            this.value = this.s;
            if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) {
                this.opFail();
                return;
            }
            this.s = this.value;
        } else {
            while (n-- > 0) {
                if (this.charAt(pstart++) == this.charAt(this.s++)) continue;
                this.opFail();
                return;
            }
        }
    }

    private void opBackRef1() {
        this.backref(1, false);
    }

    private void opBackRef2() {
        this.backref(2, false);
    }

    private void opBackRefN() {
        this.backref(this.code[this.ip++], false);
    }

    private void opBackRefNIC() {
        this.backref(this.code[this.ip++], true);
    }

    private void opBackRefMulti() {
        int i;
        int tlen = this.code[this.ip++];
        block0: for (i = 0; i < tlen; ++i) {
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            int swork = this.s;
            while (n-- > 0) {
                if (this.charAt(pstart++) == this.charAt(swork++)) continue;
                continue block0;
            }
            this.s = swork;
            this.ip += tlen - i - 1;
            break;
        }
        if (i == tlen) {
            this.opFail();
            return;
        }
    }

    private void opBackRefMultiIC() {
        int i;
        int tlen = this.code[this.ip++];
        for (i = 0; i < tlen; ++i) {
            int mem;
            if (this.backrefInvalid(mem = this.code[this.ip++])) continue;
            int pstart = this.backrefStart(mem);
            int pend = this.backrefEnd(mem);
            int n = pend - pstart;
            if (this.s + n > this.range) {
                this.opFail();
                return;
            }
            this.value = this.s;
            if (!this.stringCmpIC(this.regex.caseFoldFlag, pstart, this, n, this.end)) continue;
            this.s = this.value;
            this.ip += tlen - i - 1;
            break;
        }
        if (i == tlen) {
            this.opFail();
            return;
        }
    }

    private boolean memIsInMemp(int mem, int num, int mempp) {
        int memp = mempp;
        for (int i = 0; i < num; ++i) {
            int m;
            if (mem != (m = this.code[memp++])) continue;
            return true;
        }
        return false;
    }

    private boolean backrefMatchAtNestedLevel(boolean ignoreCase, int caseFoldFlag, int nest, int memNum, int memp) {
        int pend = -1;
        int level = 0;
        for (int k = this.stk - 1; k >= 0; --k) {
            StackEntry e = this.stack[k];
            if (e.type == 2048) {
                --level;
                continue;
            }
            if (e.type == 2304) {
                ++level;
                continue;
            }
            if (level != nest) continue;
            if (e.type == 256) {
                if (!this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
                int pstart = e.getMemPStr();
                if (pend == -1) continue;
                if (pend - pstart > this.end - this.s) {
                    return false;
                }
                int p = pstart;
                this.value = this.s;
                if (ignoreCase) {
                    if (!this.stringCmpIC(caseFoldFlag, pstart, this, pend - pstart, this.end)) {
                        return false;
                    }
                } else {
                    while (p < pend) {
                        if (this.charAt(p++) == this.charAt(this.value++)) continue;
                        return false;
                    }
                }
                this.s = this.value;
                return true;
            }
            if (e.type != 33280 || !this.memIsInMemp(e.getMemNum(), memNum, memp)) continue;
            pend = e.getMemPStr();
        }
        return false;
    }

    private void opBackRefAtLevel() {
        int tlen;
        int level;
        int ic;
        if (this.backrefMatchAtNestedLevel((ic = this.code[this.ip++]) != 0, this.regex.caseFoldFlag, level = this.code[this.ip++], tlen = this.code[this.ip++], this.ip)) {
            this.ip += tlen;
        } else {
            this.opFail();
            return;
        }
    }

    private void opNullCheckStart() {
        int mem = this.code[this.ip++];
        this.pushNullCheckStart(mem, this.s);
    }

    private void nullCheckFound() {
        switch (this.code[this.ip++]) {
            case 55: 
            case 56: {
                ++this.ip;
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                ++this.ip;
                break;
            }
            default: {
                throw new InternalException("unexpected bytecode (bug)");
            }
        }
    }

    private void opNullCheckEnd() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheck(mem = this.code[this.ip++], this.s)) != 0) {
            this.nullCheckFound();
        }
    }

    private void opNullCheckEndMemST() {
        int mem;
        int isNull;
        if ((isNull = this.nullCheckMemSt(mem = this.code[this.ip++], this.s)) != 0) {
            if (isNull == -1) {
                this.opFail();
                return;
            }
            this.nullCheckFound();
        }
    }

    private void opJump() {
        this.ip += this.code[this.ip] + 1;
    }

    private void opPush() {
        int addr = this.code[this.ip++];
        this.pushAlt(this.ip + addr, this.s);
    }

    private void opPop() {
        this.popOne();
    }

    private void opPushOrJumpExact1() {
        int addr = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.charAt(this.s)) {
            ++this.ip;
            this.pushAlt(this.ip + addr, this.s);
            return;
        }
        this.ip += addr + 1;
    }

    private void opPushIfPeekNext() {
        int addr = this.code[this.ip++];
        if (this.s < this.range && this.code[this.ip] == this.charAt(this.s)) {
            ++this.ip;
            this.pushAlt(this.ip + addr, this.s);
            return;
        }
        ++this.ip;
    }

    private void opRepeat() {
        int mem = this.code[this.ip++];
        int addr = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip, this.s);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip + addr, this.s);
        }
    }

    private void opRepeatNG() {
        int mem = this.code[this.ip++];
        int addr = this.code[this.ip++];
        this.repeatStk[mem] = this.stk;
        this.pushRepeat(mem, this.ip, this.s);
        if (this.regex.repeatRangeLo[mem] == 0) {
            this.pushAlt(this.ip, this.s);
            this.ip += addr;
        }
    }

    private boolean nullCheckRepeat(StackEntry e) {
        return e.getRepeatPStr() != this.s || e.getRepeatCount() < this.regex.repeatRangeLo[e.getRepeatNum()];
    }

    private void repeatInc(int mem, int si) {
        StackEntry e = this.stack[si];
        if (!this.nullCheckRepeat(e)) {
            this.opFail();
            return;
        }
        int slast = e.getRepeatPStr();
        e.increaseRepeatCount();
        e.setRepeatPStr(this.s);
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                this.pushAlt(this.ip, this.s);
                this.ip = e.getRepeatPCode();
            } else {
                this.ip = e.getRepeatPCode();
            }
        }
        this.pushRepeatInc(si, slast);
    }

    private void opRepeatInc() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatInc(mem, si);
    }

    private void opRepeatIncSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatInc(mem, si);
    }

    private void repeatIncNG(int mem, int si) {
        StackEntry e = this.stack[si];
        if (!this.nullCheckRepeat(e)) {
            this.opFail();
            return;
        }
        int slast = e.getRepeatPStr();
        e.increaseRepeatCount();
        e.setRepeatPStr(this.s);
        if (e.getRepeatCount() < this.regex.repeatRangeHi[mem]) {
            if (e.getRepeatCount() >= this.regex.repeatRangeLo[mem]) {
                int pcode = e.getRepeatPCode();
                this.pushRepeatInc(si, slast);
                this.pushAlt(pcode, this.s);
            } else {
                this.ip = e.getRepeatPCode();
                this.pushRepeatInc(si, slast);
            }
        } else if (e.getRepeatCount() == this.regex.repeatRangeHi[mem]) {
            this.pushRepeatInc(si, slast);
        }
    }

    private void opRepeatIncNG() {
        int mem = this.code[this.ip++];
        int si = this.repeatStk[mem];
        this.repeatIncNG(mem, si);
    }

    private void opRepeatIncNGSG() {
        int mem = this.code[this.ip++];
        int si = this.getRepeat(mem);
        this.repeatIncNG(mem, si);
    }

    private void opPushPos() {
        this.pushPos(this.s);
    }

    private void opPopPos() {
        StackEntry e = this.stack[this.posEnd()];
        this.s = e.getStatePStr();
    }

    private void opPushPosNot() {
        int addr = this.code[this.ip++];
        this.pushPosNot(this.ip + addr, this.s);
    }

    private void opFailPos() {
        this.popTilPosNot();
        this.opFail();
    }

    private void opPushStopBT() {
        this.pushStopBT();
    }

    private void opPopStopBT() {
        this.stopBtEnd();
    }

    private void opLookBehind() {
        int tlen = this.code[this.ip++];
        this.s = EncodingHelper.stepBack(this.str, this.s, tlen);
        if (this.s == -1) {
            this.opFail();
            return;
        }
    }

    private void opPushLookBehindNot() {
        int tlen;
        int q;
        int addr = this.code[this.ip++];
        if ((q = EncodingHelper.stepBack(this.str, this.s, tlen = this.code[this.ip++])) == -1) {
            this.ip += addr;
        } else {
            this.pushLookBehindNot(this.ip + addr, this.s);
            this.s = q;
        }
    }

    private void opFailLookBehindNot() {
        this.popTilLookBehindNot();
        this.opFail();
    }

    private void opFail() {
        if (this.stack == null) {
            this.ip = this.regex.codeLength - 1;
            return;
        }
        StackEntry e = this.pop();
        this.ip = e.getStatePCode();
        this.s = e.getStatePStr();
    }

    private int finish() {
        return this.bestLen;
    }
}

