/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.beans.model.impl.ObjectProviders;
import org.netbeans.modules.spring.beans.model.impl.SpringBeanImpl;
import org.netbeans.modules.spring.beans.model.impl.SpringModelImplementation;
import org.netbeans.modules.spring.spi.beans.SpringModelProvider;

class SpringModelProviderImpl
implements SpringModelProvider {
    private AnnotationModelHelper helper;
    private PersistentObjectManager<SpringBeanImpl> springBeanManager;
    private AtomicBoolean isDirty = new AtomicBoolean(true);
    private volatile boolean isIndexListenerAdded;
    private List<SpringBean> cachedSpringBeans;

    public SpringModelProviderImpl(SpringModelImplementation springModelImplementation) {
        this.helper = springModelImplementation.getHelper();
        this.springBeanManager = this.helper.createPersistentObjectManager((ObjectProvider)new ObjectProviders.SpringBeanProvider(this.helper));
    }

    @Override
    public List<SpringBean> getBeans() {
        List<SpringBean> result;
        boolean dirty = this.isDirty.getAndSet(false);
        if (!this.isIndexListenerAdded) {
            this.addIndexListener();
        }
        if (!dirty) {
            result = this.getCachedNamedElements();
            if (!this.isDirty.get()) {
                return result;
            }
        }
        result = new LinkedList<SpringBean>();
        Collection springBeans = this.getSpringBeanManager().getObjects();
        for (SpringBeanImpl springBeanImpl : springBeans) {
            result.add(springBeanImpl);
        }
        this.setCachedResult(result);
        return result;
    }

    private PersistentObjectManager<SpringBeanImpl> getSpringBeanManager() {
        return this.springBeanManager;
    }

    private void addIndexListener() {
        this.isIndexListenerAdded = true;
        this.helper.getClasspathInfo().getClassIndex().addClassIndexListener(new ClassIndexListener(){

            public void typesAdded(TypesEvent event) {
                this.setDirty();
            }

            public void typesRemoved(TypesEvent event) {
                this.setDirty();
            }

            public void typesChanged(TypesEvent event) {
                this.setDirty();
            }

            public void rootsAdded(RootsEvent event) {
                this.setDirty();
            }

            public void rootsRemoved(RootsEvent event) {
                this.setDirty();
            }

            private void setDirty() {
                SpringModelProviderImpl.this.isDirty.set(true);
            }
        });
    }

    private void setCachedResult(List<SpringBean> list) {
        this.cachedSpringBeans = new ArrayList<SpringBean>(list);
    }

    private List<SpringBean> getCachedNamedElements() {
        ArrayList<SpringBean> result = new ArrayList<SpringBean>(this.cachedSpringBeans);
        return result;
    }
}

