/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.tm4e.core.grammar.GrammarHelper;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IGrammarRepository;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.logger.ILogger;
import org.eclipse.tm4e.core.theme.IThemeProvider;
import org.eclipse.tm4e.core.theme.Theme;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class SyncRegistry
implements IGrammarRepository,
IThemeProvider {
    private final ILogger logger;
    private final Map<String, IGrammar> _grammars;
    private final Map<String, IRawGrammar> _rawGrammars;
    private final Map<String, Collection<String>> _injectionGrammars;
    private Theme _theme;

    public SyncRegistry(Theme theme, ILogger logger) {
        this._theme = theme;
        this.logger = logger;
        this._grammars = new HashMap<String, IGrammar>();
        this._rawGrammars = new HashMap<String, IRawGrammar>();
        this._injectionGrammars = new HashMap<String, Collection<String>>();
    }

    public void setTheme(Theme theme) {
        this._theme = theme;
        this._grammars.keySet().forEach(scopeName -> {
            IGrammar grammar = this._grammars.get(scopeName);
            ((Grammar)grammar).onDidChangeTheme();
        });
    }

    public Set<String> getColorMap() {
        return this._theme.getColorMap();
    }

    public Collection<String> addGrammar(IRawGrammar grammar, Collection<String> injectionScopeNames) {
        this._rawGrammars.put(grammar.getScopeName(), grammar);
        ArrayList<String> includedScopes = new ArrayList<String>();
        SyncRegistry.collectIncludedScopes(includedScopes, grammar);
        if (injectionScopeNames != null) {
            this._injectionGrammars.put(grammar.getScopeName(), injectionScopeNames);
            injectionScopeNames.forEach(scopeName -> SyncRegistry.addIncludedScope(scopeName, includedScopes));
        }
        return includedScopes;
    }

    @Override
    public IRawGrammar lookup(String scopeName) {
        return this._rawGrammars.get(scopeName);
    }

    @Override
    public Collection<String> injections(String targetScope) {
        return this._injectionGrammars.get(targetScope);
    }

    @Override
    public ThemeTrieElementRule getDefaults() {
        return this._theme.getDefaults();
    }

    @Override
    public List<ThemeTrieElementRule> themeMatch(String scopeName) {
        return this._theme.match(scopeName);
    }

    public IGrammar grammarForScopeName(String scopeName, int initialLanguage, Map<String, Integer> embeddedLanguages) {
        if (!this._grammars.containsKey(scopeName)) {
            IRawGrammar rawGrammar = this.lookup(scopeName);
            if (rawGrammar == null) {
                return null;
            }
            this._grammars.put(scopeName, GrammarHelper.createGrammar(rawGrammar, initialLanguage, embeddedLanguages, this, this));
        }
        return this._grammars.get(scopeName);
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    private static void collectIncludedScopes(Collection<String> result, IRawGrammar grammar) {
        IRawRepository repository;
        if (grammar.getPatterns() != null) {
            SyncRegistry._extractIncludedScopesInPatterns(result, grammar.getPatterns());
        }
        if ((repository = grammar.getRepository()) != null) {
            SyncRegistry._extractIncludedScopesInRepository(result, repository);
        }
        result.remove(grammar.getScopeName());
    }

    private static void _extractIncludedScopesInPatterns(Collection<String> result, Collection<IRawRule> patterns) {
        for (IRawRule pattern : patterns) {
            String include;
            Collection<IRawRule> p = pattern.getPatterns();
            if (p != null) {
                SyncRegistry._extractIncludedScopesInPatterns(result, p);
            }
            if ((include = pattern.getInclude()) == null || include.equals("$base") || include.equals("$self") || include.charAt(0) == '#') continue;
            int sharpIndex = include.indexOf(35);
            if (sharpIndex >= 0) {
                SyncRegistry.addIncludedScope(include.substring(0, sharpIndex), result);
                continue;
            }
            SyncRegistry.addIncludedScope(include, result);
        }
    }

    private static void addIncludedScope(String scopeName, Collection<String> includedScopes) {
        if (!includedScopes.contains(scopeName)) {
            includedScopes.add(scopeName);
        }
    }

    private static void _extractIncludedScopesInRepository(Collection<String> result, IRawRepository repository) {
        Map r = (Map)((Object)repository);
        for (Map.Entry entry : r.entrySet()) {
            IRawRule rule = (IRawRule)entry.getValue();
            if (rule.getPatterns() != null) {
                SyncRegistry._extractIncludedScopesInPatterns(result, rule.getPatterns());
            }
            if (rule.getRepository() == null) continue;
            SyncRegistry._extractIncludedScopesInRepository(result, rule.getRepository());
        }
    }
}

