/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.openide.util.NbBundle;

public class Utils {
    public static boolean isReachableFrom(Instance source, Instance target) {
        if (source == null || target == null) {
            return false;
        }
        Logger.getLogger(Utils.class.getName()).log(Level.FINE, "Utils.isReachableFrom {0}, {1}", new Object[]{source, target});
        HashSet<Instance> processed = new HashSet<Instance>();
        ArrayDeque<Instance> fifo = new ArrayDeque<Instance>();
        fifo.add(source);
        while (!fifo.isEmpty()) {
            if (fifo.size() > 200) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, "overflow in isReachableFrom {0}, {1}", new Object[]{source, target});
                break;
            }
            Instance act = (Instance)fifo.removeFirst();
            if (act.equals(target)) {
                return true;
            }
            List outgoing = act.getFieldValues();
            for (FieldValue v : outgoing) {
                Instance neu = null;
                if (v instanceof ObjectFieldValue) {
                    Field fld = ((ObjectFieldValue)v).getField();
                    if ("referent".equals(fld.getName()) && "java.lang.ref.Reference".equals(fld.getDeclaringClass().getName())) continue;
                    neu = ((ObjectFieldValue)v).getInstance();
                }
                if (v instanceof ArrayItemValue) {
                    neu = ((ArrayItemValue)v).getInstance();
                }
                if (neu == null || !processed.add(neu)) continue;
                fifo.add(neu);
            }
        }
        return false;
    }

    public static Set<Instance> getRetainedSet(Collection<Instance> objSet, Heap heap) {
        Instance neu;
        FieldValue fv;
        Instance curr;
        Field ref = null;
        JavaClass reference = heap.getJavaClassByName("java.lang.ref.Reference");
        for (Object fld : reference.getFields()) {
            Field f = (Field)fld;
            if (!"referent".equals(f.getName())) continue;
            ref = f;
            break;
        }
        HashSet<Instance> results = new HashSet<Instance>();
        Collection roots = heap.getGCRoots();
        HashSet<Instance> marked = new HashSet<Instance>();
        ArrayDeque<Instance> fifo = new ArrayDeque<Instance>();
        for (GCRoot r : roots) {
            Instance curr2 = r.getInstance();
            if (objSet.contains(curr2)) continue;
            fifo.add(curr2);
        }
        while (!fifo.isEmpty()) {
            curr = (Instance)fifo.removeFirst();
            if (!marked.add(curr)) continue;
            for (Object val : curr.getFieldValues()) {
                fv = (FieldValue)val;
                if (fv.getField().equals(ref) || !(val instanceof ObjectFieldValue) || (neu = ((ObjectFieldValue)val).getInstance()) == null || objSet.contains(neu)) continue;
                fifo.add(neu);
            }
            if (!(curr instanceof ObjectArrayInstance)) continue;
            for (Object val : ((ObjectArrayInstance)curr).getValues()) {
                Instance neu2 = (Instance)val;
                if (neu2 == null || objSet.contains(neu2)) continue;
                fifo.add(neu2);
            }
        }
        fifo.addAll(objSet);
        results.addAll(objSet);
        while (!fifo.isEmpty()) {
            curr = (Instance)fifo.removeFirst();
            for (Object val : curr.getFieldValues()) {
                fv = (FieldValue)val;
                if (fv.getField().equals(ref) || !(val instanceof ObjectFieldValue) || (neu = ((ObjectFieldValue)val).getInstance()) == null || marked.contains(neu) || !results.add(neu)) continue;
                fifo.add(neu);
            }
        }
        return results;
    }

    public static Set<Instance> getRetainedSet(Instance in, Heap heap) {
        return Utils.getRetainedSet(Collections.singleton(in), heap);
    }

    public static String getRootIncommingString(Instance in) {
        String temp = null;
        while ((in = in.getNearestGCRootPointer()) != null) {
            String rName = in.getJavaClass().getName();
            if (temp == null) {
                temp = "<< " + rName;
            }
            if (!rName.startsWith("java.") && !rName.startsWith("javax.")) {
                return rName;
            }
            if (!in.isGCRoot()) continue;
            break;
        }
        return temp == null ? "unknown" : temp;
    }

    public static String getSignificantIncommingString(Instance in) {
        HashSet<Instance> processed = new HashSet<Instance>();
        String temp = null;
        ArrayDeque<Instance> fifo = new ArrayDeque<Instance>();
        fifo.add(in);
        while (!fifo.isEmpty()) {
            if (fifo.size() > 10) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, "overflow in getSignificantIncommingString({0})", new Object[]{in});
                break;
            }
            Instance act = (Instance)fifo.removeFirst();
            List incoming = act.getReferences();
            for (Value v : incoming) {
                String rName = v.getDefiningInstance().getJavaClass().getName();
                if (temp == null) {
                    temp = "<< " + rName;
                }
                if (rName.startsWith("java.") || rName.startsWith("javax.")) {
                    Instance i = v.getDefiningInstance();
                    if (!processed.add(i)) continue;
                    fifo.add(i);
                    continue;
                }
                return rName;
            }
        }
        return temp == null ? "unknown" : temp;
    }

    public static String printClass(MemoryLint context, String cls) {
        if (cls.startsWith("<< ")) {
            cls = cls.substring("<< ".length());
        }
        if ("unknown".equals(cls)) {
            return NbBundle.getMessage(Utils.class, (String)"LBL_UnknownClass");
        }
        String fullName = cls;
        String dispName = cls;
        String field = "";
        int dotIdx = cls.lastIndexOf(46);
        int colonIdx = cls.lastIndexOf(58);
        if (colonIdx == -1) {
            colonIdx = cls.lastIndexOf(59);
        }
        if (colonIdx > 0) {
            fullName = cls.substring(0, colonIdx);
            field = "." + cls.substring(colonIdx + 1);
        }
        dispName = fullName.substring(dotIdx + 1);
        return "<a href='file://class/" + fullName + "'>" + dispName + "</a>" + field;
    }

    public static String printInstance(Instance in) {
        String className = in.getJavaClass().getName();
        return "<a href='file://instance/" + className + "/" + in.getInstanceNumber() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }
}

