/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.help.HelpSet;
import org.netbeans.modules.javahelp.Installer;
import org.netbeans.modules.javahelp.NbDocsStreamHandler;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public final class HelpSetProcessor
implements Environment.Provider {
    private static final String HELPSET_MERGE_CONTEXT = "OpenIDE";
    private static final String HELPSET_MERGE_ATTR = "mergeIntoMaster";

    public Lookup getEnvironment(final DataObject obj) {
        try {
            Class.forName("javax.help.HelpSet");
        }
        catch (ClassNotFoundException ex) {
            return Lookup.EMPTY;
        }
        Installer.log.log(Level.FINE, "creating help set from ref: {0}", obj.getPrimaryFile());
        return Lookups.singleton((Object)new InstanceCookie(){

            public String instanceName() {
                return obj.getName();
            }

            public Class<?> instanceClass() throws IOException, ClassNotFoundException {
                return HelpSet.class;
            }

            public Object instanceCreate() throws IOException, ClassNotFoundException {
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(obj.getPrimaryFile().getURL().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)EntityCatalog.getDefault());
                    Element el = doc.getDocumentElement();
                    if (!el.getNodeName().equals("helpsetref")) {
                        throw new IOException();
                    }
                    String url = el.getAttribute("url");
                    if (url == null || url.isEmpty()) {
                        throw new IOException("no url attr on <helpsetref>! doc.class=" + doc.getClass().getName() + " doc.documentElement=" + el);
                    }
                    String mergeS = el.getAttribute("merge");
                    boolean merge = mergeS.isEmpty() || Boolean.valueOf(mergeS) != false;
                    Class<NbDocsStreamHandler> ignore = NbDocsStreamHandler.class;
                    HelpSet hs = new HelpSet((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class), new URL(url));
                    hs.setKeyData((Object)HelpSetProcessor.HELPSET_MERGE_CONTEXT, HelpSetProcessor.HELPSET_MERGE_ATTR, (Object)merge);
                    return hs;
                }
                catch (IOException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
            }
        });
    }
}

