"use strict";
/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const timers_1 = require("timers");
class Deferred {
    constructor(operation, timeout) {
        this.operation = operation;
        this.promise = new Promise((resolve, reject) => {
            this.resolve = obj => {
                timers_1.clearTimeout(this.timer);
                resolve(obj);
            };
            this.reject = obj => {
                timers_1.clearTimeout(this.timer);
                reject(obj);
            };
        });
        this.timer = setTimeout(() => {
            this.reject(new Error(this.operation + " timeout"));
        }, timeout || 20000);
    }
}
exports.Deferred = Deferred;
function getTsserverExecutable() {
    return isWindows() ? 'tsserver.cmd' : 'tsserver';
}
exports.getTsserverExecutable = getTsserverExecutable;
function isWindows() {
    return /^win/.test(process.platform);
}
exports.isWindows = isWindows;
//# sourceMappingURL=utils.js.map