/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.actions.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class AddDOMBreakpointAction
extends NodeAction {
    protected void performAction(org.openide.nodes.Node[] activatedNodes) {
    }

    public JMenuItem getPopupPresenter() {
        org.openide.nodes.Node[] nodes = Utilities.actionsGlobalContext().lookupAll(org.openide.nodes.Node.class).toArray(new org.openide.nodes.Node[0]);
        return new PopupPresenter(nodes, this.enable(nodes));
    }

    protected boolean enable(org.openide.nodes.Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        for (org.openide.nodes.Node n : activatedNodes) {
            FileObject fo;
            Node domNode = (Node)n.getLookup().lookup(Node.class);
            if (domNode != null || (fo = (FileObject)n.getLookup().lookup(FileObject.class)) != null) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return Bundle.AddDOMBreakpoint();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.javascript.addDOMBreakpoint");
    }

    private static void bind(final JCheckBoxMenuItem cmi, final org.openide.nodes.Node node, final DOMBreakpoint.Type type, DOMBreakpoint db, final Node domNode) {
        if (db != null) {
            cmi.setSelected(db.getTypes().contains((Object)type));
        }
        final DOMBreakpoint[] dbPtr = new DOMBreakpoint[]{db};
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dbPtr[0] == null) {
                    DOMNode dom;
                    URL url;
                    if (domNode != null) {
                        url = DOMNode.findURL(domNode);
                        dom = DOMNode.create(domNode);
                    } else {
                        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
                        if (fo == null) {
                            return;
                        }
                        url = URLMapper.findURL((FileObject)fo, (int)1);
                        if (url == null) {
                            return;
                        }
                        dom = DOMNode.create(node);
                    }
                    dbPtr[0] = new DOMBreakpoint(url, dom);
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)dbPtr[0]);
                }
                if (cmi.isSelected()) {
                    dbPtr[0].addType(type);
                } else {
                    dbPtr[0].removeType(type);
                }
                if (dbPtr[0].getTypes().isEmpty()) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)dbPtr[0]);
                    dbPtr[0] = null;
                }
            }
        });
    }

    private static DOMBreakpoint findBreakpointOn(Node domNode, org.openide.nodes.Node node, DOMBreakpoint[] domBreakpoints) {
        if (domNode != null) {
            for (DOMBreakpoint db : domBreakpoints) {
                DOMNode dom = db.getNode();
                if (!domNode.equals((Object)dom.getNode())) continue;
                return db;
            }
        } else {
            DOMNode nodeDom = DOMNode.create(node);
            List<? extends DOMNode.NodeId> nodePath = nodeDom.getPath();
            if (nodePath != null) {
                String name = node.getName();
                for (DOMBreakpoint db : domBreakpoints) {
                    DOMNode dom = db.getNode();
                    List<? extends DOMNode.NodeId> path = dom.getPath();
                    if (path == null || !name.equals(dom.getNodeName()) || !AddDOMBreakpointAction.listEquals(nodePath, path)) continue;
                    return db;
                }
            } else {
                String id = nodeDom.getID();
                for (DOMBreakpoint db : domBreakpoints) {
                    DOMNode dom = db.getNode();
                    if (!id.equals(dom.getID())) continue;
                    return db;
                }
            }
        }
        return null;
    }

    private static boolean listEquals(List<?> l1, List<?> l2) {
        int n = l1.size();
        if (l2.size() == n) {
            for (int i = 0; i < n; ++i) {
                Object o1 = l1.get(i);
                Object o2 = l2.get(i);
                if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static DOMBreakpoint[] findDOMBreakpoints() {
        Breakpoint[] breakpoints;
        ArrayList<DOMBreakpoint> domBreakpoints = new ArrayList<DOMBreakpoint>();
        for (Breakpoint b : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(b instanceof DOMBreakpoint)) continue;
            domBreakpoints.add((DOMBreakpoint)b);
        }
        return domBreakpoints.toArray(new DOMBreakpoint[0]);
    }

    private static class PopupPresenter
    extends JMenuItem
    implements DynamicMenuContent {
        private final JCheckBoxMenuItem[] items = new JCheckBoxMenuItem[]{new JCheckBoxMenuItem(Bundle.CTL_BreakOnSubtreeModif()), new JCheckBoxMenuItem(Bundle.CTL_BreakOnAttributesModif()), new JCheckBoxMenuItem(Bundle.CTL_BreakOnNodeRemove())};

        private PopupPresenter(org.openide.nodes.Node[] activatedNodes, boolean enabled) {
            if (!enabled) {
                for (JCheckBoxMenuItem c : this.items) {
                    ((JComponent)c).setEnabled(false);
                }
            } else {
                DOMBreakpoint[] domBreakpoints = AddDOMBreakpointAction.findDOMBreakpoints();
                for (int i = 0; i < activatedNodes.length; ++i) {
                    org.openide.nodes.Node node = activatedNodes[i];
                    Node domNode = (Node)node.getLookup().lookup(Node.class);
                    DOMBreakpoint db = AddDOMBreakpointAction.findBreakpointOn(domNode, node, domBreakpoints);
                    AddDOMBreakpointAction.bind(this.items[0], node, DOMBreakpoint.Type.SUBTREE_MODIFIED, db, domNode);
                    AddDOMBreakpointAction.bind(this.items[1], node, DOMBreakpoint.Type.ATTRIBUTE_MODIFIED, db, domNode);
                    AddDOMBreakpointAction.bind(this.items[2], node, DOMBreakpoint.Type.NODE_REMOVED, db, domNode);
                }
            }
        }

        public JComponent[] getMenuPresenters() {
            return this.items;
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.items;
        }
    }
}

