/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.api.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.api.customization.model.BindingOperationCustomization;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BindingOperationPanel
extends SaveableSectionInnerPanel {
    private BindingOperation bindingOperation;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private ModelChangeListener primaryModelListener;
    private Definitions primaryDefinitions;
    private WSDLModel primaryModel;
    private JLabel bindingLabel;
    private JLabel bindingName;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingOperationPanel(SectionView view, BindingOperation bindingOperation, Definitions primaryDefinitions) {
        super(view);
        this.bindingOperation = bindingOperation;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.bindingOperation.getModel();
        this.primaryModel = this.primaryDefinitions.getModel();
        this.initComponents();
        this.bindingName.setText(this.getParentOfBindingOperation(bindingOperation));
        this.sync();
        this.addModifier(this.enableMIMEContentCB);
        this.modelListener = new ModelChangeListener();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)this.model);
        this.model.addPropertyChangeListener(pcl);
        if (this.primaryModel != this.model) {
            this.primaryModelListener = new ModelChangeListener();
            PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this.primaryModelListener, (Object)this.primaryModel);
            this.primaryModel.addPropertyChangeListener(l);
        }
    }

    private String getParentOfBindingOperation(BindingOperation op) {
        Binding binding = (Binding)op.getParent();
        return binding.getName();
    }

    private void sync() {
        List ee = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
        if (ee.size() == 1) {
            BindingOperationCustomization boc = (BindingOperationCustomization)ee.get(0);
            EnableMIMEContent emc = boc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    private boolean getMIMEContentOfParent() {
        BindingCustomization bc;
        EnableMIMEContent mimeContent;
        boolean isMIMEContent = false;
        Binding binding = (Binding)this.bindingOperation.getParent();
        List bcs = binding.getExtensibilityElements(BindingCustomization.class);
        isMIMEContent = bcs.size() > 0 ? ((mimeContent = (bc = (BindingCustomization)bcs.get(0)).getEnableMIMEContent()) != null ? mimeContent.isEnabled() : this.getMIMEContentFromDefinitions(this.primaryDefinitions)) : this.getMIMEContentFromDefinitions(this.primaryDefinitions);
        return isMIMEContent;
    }

    private boolean getMIMEContentFromDefinitions(Definitions definitions) {
        DefinitionsCustomization dc;
        EnableMIMEContent mimeContent;
        List dcs = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (mimeContent = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableMIMEContent()) != null) {
            return mimeContent.isEnabled();
        }
        return false;
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public Boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block13: {
            List ee = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
            CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
            try {
                if (jComponent != this.enableMIMEContentCB) break block13;
                if (ee.size() > 0) {
                    BindingOperationCustomization boc = (BindingOperationCustomization)ee.get(0);
                    EnableMIMEContent emc = boc.getEnableMIMEContent();
                    if (emc == null) {
                        try {
                            this.model.startTransaction();
                            emc = factory.createEnableMIMEContent(this.model);
                            emc.setEnabled(this.getEnableMIMEContent().booleanValue());
                            boc.setEnableMIMEContent(emc);
                            this.wsdlDirty = true;
                            break block13;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent().booleanValue());
                        this.wsdlDirty = true;
                        break block13;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                BindingOperationCustomization boc = factory.createBindingOperationCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent().booleanValue());
                    boc.setEnableMIMEContent(emc);
                    this.bindingOperation.addExtensibilityElement((ExtensibilityElement)boc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.bindingLabel = new JLabel();
        this.bindingName = new JLabel();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(NbBundle.getBundle(BindingOperationPanel.class).getString("LBL_ENABLE_MIME_CONTENT"));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.enableMIMEContentCB.setToolTipText(bundle.getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.bindingLabel.setText(bundle.getString("LBL_ENCLOSING_BINDING"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bindingLabel).addGap(22, 22, 22).addComponent(this.bindingName, -2, 139, -2)).addComponent(this.enableMIMEContentCB)).addContainerGap(201, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bindingLabel).addComponent(this.bindingName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addComponent(this.enableMIMEContentCB).addContainerGap()));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.bindingLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENCLOSING_BINDING"));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EnableMIMEContent emc;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableMIMEContent && ((parent = (WSDLComponent)(emc = (EnableMIMEContent)source).getParent()) instanceof DefinitionsCustomization || parent instanceof BindingCustomization)) {
                BindingOperationPanel.this.sync();
            }
        }
    }
}

