/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.internal.grammar.StackElementMetadata;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class ScopeListElement {
    public final ScopeListElement parent;
    public final String scope;
    public final int metadata;

    public ScopeListElement(ScopeListElement parent, String scope, int metadata) {
        this.parent = parent;
        this.scope = scope;
        this.metadata = metadata;
    }

    private static boolean _equals(ScopeListElement a, ScopeListElement b) {
        do {
            if (a == b) {
                return true;
            }
            if (a.scope != b.scope || a.metadata != b.metadata) {
                return false;
            }
            a = a.parent;
            b = b.parent;
            if (a != null || b != null) continue;
            return true;
        } while (a != null && b != null);
        return false;
    }

    public boolean equals(ScopeListElement other) {
        return ScopeListElement._equals(this, other);
    }

    private static boolean _matchesScope(String scope, String selector, String selectorWithDot) {
        return selector.equals(scope) || scope.startsWith(selectorWithDot);
    }

    private static boolean _matches(ScopeListElement target, List<String> parentScopes) {
        if (parentScopes == null) {
            return true;
        }
        int len = parentScopes.size();
        int index = 0;
        String selector = parentScopes.get(index);
        String selectorWithDot = String.valueOf(selector) + ".";
        while (target != null) {
            if (ScopeListElement._matchesScope(target.scope, selector, selectorWithDot)) {
                if (++index == len) {
                    return true;
                }
                selector = parentScopes.get(index);
                selectorWithDot = String.valueOf(selector) + '.';
            }
            target = target.parent;
        }
        return false;
    }

    public static int mergeMetadata(int metadata, ScopeListElement scopesList, ScopeMetadata source) {
        if (source == null) {
            return metadata;
        }
        int fontStyle = -1;
        int foreground = 0;
        int background = 0;
        if (source.themeData != null) {
            int i = 0;
            int len = source.themeData.size();
            while (i < len) {
                ThemeTrieElementRule themeData = source.themeData.get(i);
                if (ScopeListElement._matches(scopesList, themeData.parentScopes)) {
                    fontStyle = themeData.fontStyle;
                    foreground = themeData.foreground;
                    background = themeData.background;
                    break;
                }
                ++i;
            }
        }
        return StackElementMetadata.set(metadata, source.languageId, source.tokenType, fontStyle, foreground, background);
    }

    private static ScopeListElement _push(ScopeListElement target, Grammar grammar, List<String> scopes) {
        int i = 0;
        int len = scopes.size();
        while (i < len) {
            String scope = scopes.get(i);
            ScopeMetadata rawMetadata = grammar.getMetadataForScope(scope);
            int metadata = ScopeListElement.mergeMetadata(target.metadata, target, rawMetadata);
            target = new ScopeListElement(target, scope, metadata);
            ++i;
        }
        return target;
    }

    public ScopeListElement push(Grammar grammar, String scope) {
        if (scope == null) {
            return this;
        }
        if (scope.indexOf(32) >= 0) {
            return ScopeListElement._push(this, grammar, Arrays.asList(scope.split(" ")));
        }
        return ScopeListElement._push(this, grammar, Arrays.asList(scope));
    }

    private static List<String> _generateScopes(ScopeListElement scopesList) {
        ArrayList<String> result = new ArrayList<String>();
        while (scopesList != null) {
            result.add(scopesList.scope);
            scopesList = scopesList.parent;
        }
        Collections.reverse(result);
        return result;
    }

    public List<String> generateScopes() {
        return ScopeListElement._generateScopes(this);
    }
}

