/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.library.ReflectionLibraryDefault;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ReflectionLibraryDefault.class)
final class ReflectionLibraryDefaultGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ReflectionLibraryDefaultGen() {
    }

    static {
        LibraryExport.register(ReflectionLibraryDefault.class, new ReflectionLibraryExports());
    }

    @GeneratedBy(value=ReflectionLibraryDefault.class)
    private static final class ReflectionLibraryExports
    extends LibraryExport<ReflectionLibrary> {
        private ReflectionLibraryExports() {
            super(ReflectionLibrary.class, Object.class, true);
        }

        @Override
        protected ReflectionLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected ReflectionLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ReflectionLibraryDefault.class)
        private static final class Uncached
        extends ReflectionLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object send(Object arg0Value, Message arg1Value, Object ... arg2Value) throws Exception {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return ReflectionLibraryDefault.Send.doSendGeneric(arg0Value, arg1Value, arg2Value);
            }
        }

        @GeneratedBy(value=ReflectionLibraryDefault.class)
        private static final class Cached
        extends ReflectionLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private SendCachedData sendCached_cache;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @ExplodeLoop
            public Object send(Object arg0Value, Message arg1Value, Object ... arg2Value) throws Exception {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0) {
                        SendCachedData s1_ = this.sendCached_cache;
                        while (s1_ != null) {
                            if (arg1Value == s1_.cachedMessage_ && s1_.cachedLibrary_.accepts(arg0Value)) {
                                return ReflectionLibraryDefault.Send.doSendCached(arg0Value, arg1Value, arg2Value, s1_.cachedMessage_, s1_.cachedLibrary_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return ReflectionLibraryDefault.Send.doSendGeneric(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object arg0Value, Message arg1Value, Object[] arg2Value) throws Exception {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0) {
                        Library cachedLibrary__;
                        int count1_ = 0;
                        SendCachedData s1_ = this.sendCached_cache;
                        if ((state & 1) != 0) {
                            while (!(s1_ == null || arg1Value == s1_.cachedMessage_ && s1_.cachedLibrary_.accepts(arg0Value))) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (cachedLibrary__ = super.insert(ReflectionLibraryDefault.Send.createLibrary(arg1Value, arg0Value))).accepts(arg0Value) && count1_ < 8) {
                            s1_ = super.insert(new SendCachedData(this.sendCached_cache));
                            s1_.cachedMessage_ = arg1Value;
                            s1_.cachedLibrary_ = s1_.insertAccessor(cachedLibrary__);
                            this.sendCached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = ReflectionLibraryDefault.Send.doSendCached(arg0Value, arg1Value, arg2Value, s1_.cachedMessage_, s1_.cachedLibrary_);
                            return object;
                        }
                    }
                    this.exclude_ = exclude |= 1;
                    this.sendCached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = ReflectionLibraryDefault.Send.doSendGeneric(arg0Value, arg1Value, arg2Value);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                SendCachedData s1_;
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0 && ((s1_ = this.sendCached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=ReflectionLibraryDefault.class)
            private static final class SendCachedData
            extends Node {
                @Node.Child
                SendCachedData next_;
                @CompilerDirectives.CompilationFinal
                Message cachedMessage_;
                @Node.Child
                Library cachedLibrary_;

                SendCachedData(SendCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }
            }
        }
    }
}

