/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class FlatTextAreaUI
extends BasicTextAreaUI {
    protected int minimumWidth;
    protected boolean isIntelliJTheme;
    protected Color disabledBackground;
    protected Color inactiveBackground;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTextAreaUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        this.disabledBackground = UIManager.getColor("TextArea.disabledBackground");
        this.inactiveBackground = UIManager.getColor("TextArea.inactiveBackground");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledBackground = null;
        this.inactiveBackground = null;
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        Color background = c.getBackground();
        g.setColor(!(background instanceof UIResource) ? background : (this.isIntelliJTheme && (!c.isEnabled() || !c.isEditable()) ? FlatUIUtils.getParentBackground(c) : (!c.isEnabled() ? this.disabledBackground : (!c.isEditable() ? this.inactiveBackground : background))));
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.applyMinimumWidth(super.getPreferredSize(c), c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.applyMinimumWidth(super.getMinimumSize(c), c);
    }

    private Dimension applyMinimumWidth(Dimension size, JComponent c) {
        if (c instanceof JTextArea && ((JTextArea)c).getColumns() > 0) {
            return size;
        }
        int minimumWidth = FlatUIUtils.minimumWidth(this.getComponent(), this.minimumWidth);
        size.width = Math.max(size.width, UIScale.scale(minimumWidth) - UIScale.scale(1) * 2);
        return size;
    }
}

