/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.debugger.jpda.projects.AST2Bytecode;
import org.netbeans.modules.debugger.jpda.projects.ASTOperationCreationDelegate;
import org.netbeans.modules.debugger.jpda.projects.ClassScanner;
import org.netbeans.modules.debugger.jpda.projects.ExpressionScanner;
import org.netbeans.modules.debugger.jpda.projects.FieldLNCache;
import org.netbeans.modules.debugger.jpda.projects.MethodArgumentsScanner;
import org.netbeans.modules.debugger.jpda.projects.PreferredCCParser;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class EditorContextSupport {
    private static final Logger LOG = Logger.getLogger(EditorContextSupport.class.getName());
    private static final RequestProcessor scanningProcessor = new RequestProcessor("Debugger Context Scanning", 1);
    private static final PreferredCCParser preferredCCParser = new PreferredCCParser();
    private static final FieldLNCache fieldLNCache = new FieldLNCache();

    private EditorContextSupport() {
    }

    public static TypeElement getTypeElement(CompilationController ci, String binaryName, String[] classExcludeNames) {
        ClassScanner cs = new ClassScanner(ci.getTrees(), ci.getElements(), binaryName, classExcludeNames);
        TypeElement te = (TypeElement)cs.scan(ci.getCompilationUnit(), null);
        if (te != null) {
            return te;
        }
        return null;
    }

    public static int getFieldLineNumber(String url, String className, String fieldName) {
        FileObject file;
        Integer line = fieldLNCache.getLine(url, className, fieldName);
        if (line != null) {
            return line;
        }
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return -1;
        }
        Future<Integer> fi = EditorContextSupport.getFieldLineNumber(file, className, fieldName);
        if (fi == null) {
            return -1;
        }
        try {
            line = fi.get();
            fieldLNCache.putLine(url, className, fieldName, file, line);
            return line;
        }
        catch (InterruptedException ex) {
            return -1;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
    }

    public static Future<Integer> getFieldLineNumber(final FileObject fo, final String className, final String fieldName) {
        final String url = fo.toURL().toExternalForm();
        Integer line = fieldLNCache.getLine(url, className, fieldName);
        if (line != null) {
            return new DoneFuture<Integer>(line);
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final int[] result = new int[]{-1};
        try {
            final Future<Void> f = EditorContextSupport.parseWhenScanFinishedReallyLazy(fo, new UserTask(){

                /*
                 * WARNING - void declaration
                 */
                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextSupport.retrieveController(resultIterator, fo);
                    if (ci == null) {
                        return;
                    }
                    if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return;
                    }
                    Elements elms = ci.getElements();
                    TypeElement classElement = EditorContextSupport.getTypeElement(ci, className, null);
                    if (classElement == null) {
                        return;
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    if (fieldName == null) {
                        void var8_11;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        ClassTree tree = ci.getTrees().getTree(classElement);
                        int n = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)n == -1L) {
                            LOG.warning("No position for tree " + tree + " in " + className);
                            return;
                        }
                        CharSequence text = ci.getSnapshot().getText();
                        int l = text.length();
                        while (var8_11 < l && text.charAt((int)var8_11) != '{') {
                            ++var8_11;
                        }
                        result[0] = (int)lineMap.getLineNumber((long)var8_11) + 1;
                        fieldLNCache.putLine(url, className, fieldName, fo, result[0]);
                        return;
                    }
                    List<? extends Element> classMemberElements = elms.getAllMembers(classElement);
                    for (Element element : classMemberElements) {
                        String name;
                        if (element.getKind() != ElementKind.FIELD || !(name = ((VariableElement)element).getSimpleName().toString()).equals(fieldName)) continue;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        Tree tree = ci.getTrees().getTree(element);
                        int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)pos == -1L) {
                            LOG.warning("No position for tree " + tree + " of element " + element + " in " + className);
                            continue;
                        }
                        result[0] = (int)lineMap.getLineNumber(pos);
                        fieldLNCache.putLine(url, className, fieldName, fo, result[0]);
                    }
                }
            });
            if (!f.isDone()) {
                return new Future<Integer>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public Integer get() throws InterruptedException, ExecutionException {
                        f.get();
                        return result[0];
                    }

                    @Override
                    public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return result[0];
                    }
                };
            }
        }
        catch (ParseException pex) {
            Exceptions.printStackTrace((Throwable)pex);
            return null;
        }
        return new DoneFuture<Integer>(result[0]);
    }

    public static int getMethodLineNumber(String url, String className, String methodName, String methodSignature) {
        int[] lns;
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return -1;
        }
        Future<int[]> flns = EditorContextSupport.getMethodLineNumbers(file, className, null, methodName, methodSignature);
        if (flns == null) {
            return -1;
        }
        try {
            lns = flns.get();
        }
        catch (InterruptedException ex) {
            return -1;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
        if (lns.length == 0) {
            return -1;
        }
        return lns[0];
    }

    public static Future<int[]> getMethodLineNumbers(final FileObject fo, final String className, final String[] classExcludeNames, final String methodName, final String methodSignature) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final ArrayList result = new ArrayList();
        try {
            final Future<Void> f = EditorContextSupport.parseWhenScanFinishedReallyLazy(fo, new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextSupport.retrieveController(resultIterator, fo);
                    if (ci == null) {
                        return;
                    }
                    if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return;
                    }
                    TypeElement classElement = EditorContextSupport.getTypeElement(ci, className, classExcludeNames);
                    if (classElement == null) {
                        return;
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    List<? extends Element> classMemberElements = ci.getElements().getAllMembers(classElement);
                    for (Element element : classMemberElements) {
                        List<? extends AnnotationTree> annotations;
                        MethodTree mt;
                        ModifiersTree modt;
                        String name;
                        if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !(name = element.getKind() == ElementKind.CONSTRUCTOR && !methodName.equals("<init>") ? element.getEnclosingElement().getSimpleName().toString() : element.getSimpleName().toString()).equals(methodName) || methodSignature != null && !EditorContextSupport.egualMethodSignatures(methodSignature, EditorContextSupport.createSignature((ExecutableElement)element, ci.getTypes()))) continue;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        Tree tree = ci.getTrees().getTree(element);
                        if (tree == null) {
                            LOG.warning("Null tree for element " + element + " in " + className);
                            continue;
                        }
                        int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)pos == -1L) {
                            LOG.warning("No position for tree " + tree + " of element " + element + " in " + className);
                            continue;
                        }
                        int origPos = pos;
                        if (tree.getKind() == Tree.Kind.METHOD && (modt = (mt = (MethodTree)tree).getModifiers()) != null && (annotations = modt.getAnnotations()) != null && annotations.size() > 0 && (long)(pos = (int)positions.getEndPosition(ci.getCompilationUnit(), annotations.get(annotations.size() - 1))) == -1L) {
                            LOG.warning("No position for tree " + annotations.get(annotations.size() - 1) + " in " + className);
                            continue;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        while (pos < l && (c = text.charAt(pos)) != '(' && c != ')') {
                            ++pos;
                        }
                        if (pos >= l) {
                            c = '\u0000';
                            pos = origPos;
                        }
                        if (c == '(') {
                            --pos;
                            while (pos > 0 && Character.isWhitespace(text.charAt(pos))) {
                                --pos;
                            }
                        }
                        result.add(new Integer((int)lineMap.getLineNumber(pos)));
                    }
                }
            });
            if (!f.isDone()) {
                return new Future<int[]>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public int[] get() throws InterruptedException, ExecutionException {
                        f.get();
                        return this.getResultArray();
                    }

                    @Override
                    public int[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return this.getResultArray();
                    }

                    private int[] getResultArray() {
                        int[] resultArray = new int[result.size()];
                        for (int i = 0; i < resultArray.length; ++i) {
                            resultArray[i] = (Integer)result.get(i);
                        }
                        return resultArray;
                    }
                };
            }
        }
        catch (ParseException pex) {
            Exceptions.printStackTrace((Throwable)pex);
            return null;
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return new DoneFuture<int[]>(resultArray);
    }

    private static boolean egualMethodSignatures(String s1, String s2) {
        int i = s1.lastIndexOf(")");
        if (i > 0) {
            s1 = s1.substring(0, i);
        }
        if ((i = s2.lastIndexOf(")")) > 0) {
            s2 = s2.substring(0, i);
        }
        return s1.equals(s2);
    }

    private static String createSignature(ExecutableElement elm, Types types) {
        StringBuilder signature = new StringBuilder("(");
        for (VariableElement variableElement : elm.getParameters()) {
            TypeMirror pt = variableElement.asType();
            pt = types.erasure(pt);
            String paramType = EditorContextSupport.getTypeBinaryName(pt);
            signature.append(EditorContextSupport.getSignature(paramType));
        }
        signature.append(')');
        String returnType = EditorContextSupport.getTypeBinaryName(types.erasure(elm.getReturnType()));
        signature.append(EditorContextSupport.getSignature(returnType));
        return signature.toString();
    }

    private static String getTypeBinaryName(TypeMirror t) {
        if (t instanceof ArrayType) {
            TypeMirror ct = ((ArrayType)t).getComponentType();
            return EditorContextSupport.getTypeBinaryName(ct) + "[]";
        }
        if (t instanceof DeclaredType) {
            return ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)t).asElement()));
        }
        return t.toString();
    }

    private static String getSignature(String javaType) {
        if (javaType.equals("boolean")) {
            return "Z";
        }
        if (javaType.equals("byte")) {
            return "B";
        }
        if (javaType.equals("char")) {
            return "C";
        }
        if (javaType.equals("short")) {
            return "S";
        }
        if (javaType.equals("int")) {
            return "I";
        }
        if (javaType.equals("long")) {
            return "J";
        }
        if (javaType.equals("float")) {
            return "F";
        }
        if (javaType.equals("double")) {
            return "D";
        }
        if (javaType.equals("void")) {
            return "V";
        }
        if (javaType.endsWith("[]")) {
            return "[" + EditorContextSupport.getSignature(javaType.substring(0, javaType.length() - 2));
        }
        return "L" + javaType.replace('.', '/') + ";";
    }

    public static Future<Integer> getClassLineNumber(final FileObject fo, final String className, final String[] classExcludeNames) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final Integer[] result = new Integer[]{null};
        try {
            final Future<Void> f = EditorContextSupport.parseWhenScanFinishedReallyLazy(fo, new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextSupport.retrieveController(resultIterator, fo);
                    if (ci == null) {
                        return;
                    }
                    if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return;
                    }
                    TypeElement classElement = EditorContextSupport.getTypeElement(ci, className, classExcludeNames);
                    if (classElement == null) {
                        return;
                    }
                    SourcePositions positions = ci.getTrees().getSourcePositions();
                    ClassTree tree = ci.getTrees().getTree(classElement);
                    if (tree == null) {
                        LOG.warning("Null tree for element " + classElement + " in " + className);
                        return;
                    }
                    int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                    if ((long)pos == -1L) {
                        LOG.warning("No position for tree " + tree + " of element " + classElement + " (" + className + ")");
                        return;
                    }
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                        boolean shifted = false;
                        ModifiersTree mtree = tree.getModifiers();
                        for (AnnotationTree annotationTree : mtree.getAnnotations()) {
                            int aend = (int)positions.getEndPosition(ci.getCompilationUnit(), annotationTree);
                            if ((long)aend == -1L || pos >= aend) continue;
                            shifted = true;
                            pos = aend + 1;
                        }
                        if (shifted) {
                            String text = ci.getText();
                            int n = text.length();
                            while (pos < n && Character.isWhitespace(text.charAt(pos))) {
                                ++pos;
                            }
                        }
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    result[0] = new Integer((int)lineMap.getLineNumber(pos));
                }
            });
            if (!f.isDone()) {
                return new Future<Integer>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public Integer get() throws InterruptedException, ExecutionException {
                        f.get();
                        return result[0];
                    }

                    @Override
                    public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return result[0];
                    }
                };
            }
        }
        catch (ParseException pex) {
            Exceptions.printStackTrace((Throwable)pex);
            return null;
        }
        return new DoneFuture<Integer>(result[0]);
    }

    public static String getClassName(String url, final int lineNumber) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return "";
        }
        try {
            final String[] result = new String[]{""};
            ParserManager.parse(Collections.singleton(Source.create((FileObject)file)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TypeElement te;
                    TreePath p;
                    int offset;
                    CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                    if (ci == null) {
                        return;
                    }
                    if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return;
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    try {
                        offset = (int)lineMap.getStartPosition(lineNumber);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        return;
                    }
                    for (p = ci.getTreeUtilities().pathFor(offset); p != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)p.getLeaf().getKind()); p = p.getParentPath()) {
                    }
                    if (p != null) {
                        te = (TypeElement)ci.getTrees().getElement(p);
                    } else {
                        Scope scope = ci.getTreeUtilities().scopeFor(offset);
                        te = scope.getEnclosingClass();
                    }
                    if (te != null) {
                        result[0] = ElementUtilities.getBinaryName((TypeElement)te);
                    } else {
                        LOG.warning("No enclosing class for " + ci.getFileObject() + ", offset = " + offset);
                    }
                }
            });
            return result[0];
        }
        catch (ParseException pex) {
            Exceptions.printStackTrace((Throwable)pex);
            return "";
        }
    }

    public static String getClassDeclaredAt(FileObject fo, final int currentOffset) {
        String[] currentClassPtr;
        block6: {
            currentClassPtr = new String[]{null};
            try {
                final Future<Void> scanFinished = EditorContextSupport.runWhenScanFinishedReallyLazy(fo, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        Tree tree;
                        int offset;
                        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                            return;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != '{' && c != '}' && c != '\n' && c != '\r'; ++offset) {
                        }
                        if (offset >= l) {
                            return;
                        }
                        TreePath path = ci.getTreeUtilities().pathFor(--offset);
                        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)(tree = path.getLeaf()).getKind()) && (path = path.getParentPath()) != null) {
                        }
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                            SourcePositions positions = ci.getTrees().getSourcePositions();
                            int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                            if ((long)pos == -1L) {
                                return;
                            }
                            if (offset < pos) {
                                return;
                            }
                            int hend = this.getHeaderEnd((ClassTree)tree, positions, ci.getCompilationUnit());
                            if (hend > 0) {
                                pos = hend;
                            }
                            while (pos < l && text.charAt(pos) != '{') {
                                ++pos;
                            }
                            if (pos < offset) {
                                return;
                            }
                            Element el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree));
                            if (el != null && (el.getKind() == ElementKind.CLASS || el.getKind() == ElementKind.INTERFACE)) {
                                currentClassPtr[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)el));
                            }
                        }
                    }

                    private int getHeaderEnd(ClassTree classTree, SourcePositions positions, CompilationUnitTree compilationUnit) {
                        int max = -1;
                        int pos = (int)positions.getEndPosition(compilationUnit, classTree.getExtendsClause());
                        if ((long)pos != -1L) {
                            max = Math.max(max, pos);
                        }
                        if ((long)(pos = (int)positions.getEndPosition(compilationUnit, classTree.getModifiers())) != -1L) {
                            max = Math.max(max, pos);
                        }
                        for (Tree tree : classTree.getImplementsClause()) {
                            pos = (int)positions.getEndPosition(compilationUnit, tree);
                            if ((long)pos == -1L) continue;
                            max = Math.max(max, pos);
                        }
                        for (Tree tree : classTree.getTypeParameters()) {
                            pos = (int)positions.getEndPosition(compilationUnit, tree);
                            if ((long)pos == -1L) continue;
                            max = Math.max(max, pos);
                        }
                        return max;
                    }
                }, true);
                if (scanFinished.isDone()) break block6;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException eex) {
                                Exceptions.printStackTrace((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentClassPtr[0];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    Exceptions.printStackTrace((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
                return null;
            }
        }
        return currentClassPtr[0];
    }

    public static String[] getMethodDeclaredAt(FileObject fo, final int currentOffset) {
        String[] currentMethodPtr;
        block7: {
            currentMethodPtr = new String[]{null, null, null};
            try {
                final Future<Void> scanFinished = EditorContextSupport.runWhenScanFinishedReallyLazy(fo, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        Element el;
                        Tree tree;
                        int offset;
                        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                            return;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != '(' && c != ')' && c != '\n' && c != '\r'; ++offset) {
                        }
                        if (offset >= l) {
                            return;
                        }
                        if (c == '(') {
                            --offset;
                        }
                        if ((tree = ci.getTreeUtilities().pathFor(offset).getLeaf()).getKind() == Tree.Kind.METHOD && (el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree))) != null && (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR)) {
                            currentMethodPtr[0] = el.getSimpleName().toString();
                            if (currentMethodPtr[0].equals("<init>")) {
                                currentMethodPtr[0] = el.getEnclosingElement().getSimpleName().toString();
                            }
                            currentMethodPtr[1] = EditorContextSupport.createSignature((ExecutableElement)el, ci.getTypes());
                            TypeElement te = null;
                            for (Element enclosingClassElement = el; enclosingClassElement != null; enclosingClassElement = enclosingClassElement.getEnclosingElement()) {
                                ElementKind kind = enclosingClassElement.getKind();
                                if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE) continue;
                                te = (TypeElement)enclosingClassElement;
                                break;
                            }
                            if (te != null) {
                                currentMethodPtr[2] = ElementUtilities.getBinaryName(te);
                            }
                        }
                    }
                }, true);
                if (scanFinished.isDone()) break block7;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException eex) {
                                Exceptions.printStackTrace((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentMethodPtr[0];
                        }

                        @Override
                        public String getLocalizedMessage() {
                            this.waitScanFinished();
                            return currentMethodPtr[1];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    Exceptions.printStackTrace((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
                return null;
            }
        }
        if (currentMethodPtr[0] != null) {
            return currentMethodPtr;
        }
        return null;
    }

    static CompilationController retrieveController(ResultIterator resIt, FileObject fo) throws ParseException {
        CompilationController ci;
        Parser.Result res = resIt.getParserResult();
        CompilationController compilationController = ci = res != null ? CompilationController.get((Parser.Result)res) : null;
        if (ci == null) {
            LOG.warning("Unable to get compilation controller " + fo);
        }
        return ci;
    }

    public static EditorContext.Operation[] computeOperations(CompilationController ci, int offset, int lineNumber, EditorContext.BytecodeProvider bytecodeProvider, ASTOperationCreationDelegate opCreationDelegate) throws IOException {
        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
            return new EditorContext.Operation[0];
        }
        Tree statementTree = EditorContextSupport.findStatementInScope(ci.getTreeUtilities().pathFor(offset));
        LOG.log(Level.FINE, "Statement tree found at line {0}:\n{1}\n", new Object[]{lineNumber, statementTree});
        if (statementTree == null) {
            Scope scope = ci.getTreeUtilities().scopeFor(offset);
            ExecutableElement method = scope.getEnclosingMethod();
            if (method == null) {
                return new EditorContext.Operation[0];
            }
            statementTree = ci.getTrees().getTree((Element)method);
        }
        if (statementTree == null) {
            return new EditorContext.Operation[0];
        }
        CompilationUnitTree cu = ci.getCompilationUnit();
        SourcePositions sp = ci.getTrees().getSourcePositions();
        int statementStart = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, statementTree));
        int statementEnd = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, statementTree));
        ExpressionScanner scanner = new ExpressionScanner(lineNumber, statementStart, statementEnd, cu, ci.getTrees().getSourcePositions());
        ExpressionScanner.ExpressionsInfo info = new ExpressionScanner.ExpressionsInfo();
        List expTrees = (List)statementTree.accept(scanner, info);
        LOG.log(Level.FINE, "expression trees = {0}", expTrees);
        if (expTrees == null || expTrees.isEmpty()) {
            return new EditorContext.Operation[0];
        }
        int treeStartLine = Integer.MAX_VALUE;
        int treeEndLine = 0;
        for (int i = 0; i < expTrees.size(); ++i) {
            Tree tree = (Tree)expTrees.get(i);
            int start = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, tree));
            int end = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, tree));
            if ((long)start == -1L || (long)end == -1L) continue;
            if (start < treeStartLine) {
                treeStartLine = start;
            }
            if (end <= treeEndLine) continue;
            treeEndLine = end;
        }
        if (treeStartLine == Integer.MAX_VALUE) {
            return null;
        }
        int[] indexes = bytecodeProvider.indexAtLines(treeStartLine, treeEndLine);
        if (indexes == null) {
            return null;
        }
        HashMap<Tree, EditorContext.Operation> nodeOperations = new HashMap<Tree, EditorContext.Operation>();
        EditorContext.Operation[] ops = AST2Bytecode.matchSourceTree2Bytecode(cu, ci, expTrees, info, bytecodeProvider.byteCodes(), indexes, bytecodeProvider.constantPool(), opCreationDelegate, nodeOperations);
        if (ops != null) {
            EditorContextSupport.assignNextOperations(statementTree, cu, ci, bytecodeProvider, opCreationDelegate, expTrees, info, nodeOperations);
        }
        return ops;
    }

    private static void assignNextOperations(Tree methodTree, CompilationUnitTree cu, CompilationController ci, EditorContext.BytecodeProvider bytecodeProvider, ASTOperationCreationDelegate opCreationDelegate, List<Tree> treeNodes, ExpressionScanner.ExpressionsInfo info, Map<Tree, EditorContext.Operation> nodeOperations) {
        int length = treeNodes.size();
        for (int treeIndex = 0; treeIndex < length; ++treeIndex) {
            Tree node = treeNodes.get(treeIndex);
            Set<Tree> nextNodes = info.getNextExpressions(node);
            if (nextNodes == null) continue;
            EditorContext.Operation op = nodeOperations.get(node);
            if (op == null) {
                for (int backIndex = treeIndex - 1; backIndex >= 0 && (op = nodeOperations.get(node = treeNodes.get(backIndex))) == null; --backIndex) {
                }
            }
            if (op == null) continue;
            for (Tree t : nextNodes) {
                EditorContext.Operation nextOp = nodeOperations.get(t);
                if (nextOp == null) {
                    ExpressionScanner.ExpressionsInfo newInfo;
                    ExpressionScanner scanner;
                    List newExpTrees;
                    int treeEndLine;
                    SourcePositions sp = ci.getTrees().getSourcePositions();
                    int treeStartLine = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, t));
                    if ((long)treeStartLine == -1L || (long)(treeEndLine = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, t))) == -1L || (newExpTrees = (List)methodTree.accept(scanner = new ExpressionScanner(treeStartLine, treeStartLine, treeEndLine, cu, ci.getTrees().getSourcePositions()), newInfo = new ExpressionScanner.ExpressionsInfo())) == null) continue;
                    treeStartLine = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, (Tree)newExpTrees.get(0)));
                    treeEndLine = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, (Tree)newExpTrees.get(newExpTrees.size() - 1)));
                    if ((long)treeStartLine == -1L || (long)treeEndLine == -1L) continue;
                    int[] indexes = bytecodeProvider.indexAtLines(treeStartLine, treeEndLine);
                    HashMap<Tree, EditorContext.Operation> newNodeOperations = new HashMap<Tree, EditorContext.Operation>();
                    AST2Bytecode.matchSourceTree2Bytecode(cu, ci, newExpTrees, newInfo, bytecodeProvider.byteCodes(), indexes, bytecodeProvider.constantPool(), opCreationDelegate, newNodeOperations);
                    nextOp = (EditorContext.Operation)newNodeOperations.get(t);
                    if (nextOp == null) {
                        System.err.println("Next operation not found!");
                        continue;
                    }
                }
                opCreationDelegate.addNextOperationTo(op, nextOp);
            }
        }
    }

    public static EditorContext.MethodArgument[] computeMethodArguments(CompilationController ci, EditorContext.Operation operation, ASTOperationCreationDelegate opCreationDelegate) throws IOException {
        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
            return null;
        }
        int offset = operation.getMethodEndPosition().getOffset();
        Scope scope = ci.getTreeUtilities().scopeFor(offset);
        ExecutableElement method = scope.getEnclosingMethod();
        if (method == null) {
            return null;
        }
        Tree methodTree = ci.getTrees().getTree((Element)method);
        CompilationUnitTree cu = ci.getCompilationUnit();
        MethodArgumentsScanner scanner = new MethodArgumentsScanner(offset, cu, ci.getTrees().getSourcePositions(), true, opCreationDelegate);
        EditorContext.MethodArgument[] args = (EditorContext.MethodArgument[])methodTree.accept(scanner, null);
        args = scanner.getArguments();
        return args;
    }

    public static EditorContext.MethodArgument[] computeMethodArguments(CompilationController ci, int methodLineNumber, int offset, ASTOperationCreationDelegate opCreationDelegate) throws IOException {
        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
            return null;
        }
        Scope scope = ci.getTreeUtilities().scopeFor(offset);
        TypeElement clazz = scope.getEnclosingClass();
        if (clazz == null) {
            return null;
        }
        Tree methodTree = ci.getTrees().getTree((Element)clazz);
        CompilationUnitTree cu = ci.getCompilationUnit();
        MethodArgumentsScanner scanner = new MethodArgumentsScanner(methodLineNumber, cu, ci.getTrees().getSourcePositions(), false, opCreationDelegate);
        EditorContext.MethodArgument[] args = (EditorContext.MethodArgument[])methodTree.accept(scanner, null);
        args = scanner.getArguments();
        return args;
    }

    private static Tree findStatementInScope(TreePath tp) {
        Tree tree = tp.getLeaf();
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case BLOCK: 
            case EXPRESSION_STATEMENT: 
            case LAMBDA_EXPRESSION: 
            case METHOD: {
                return tree;
            }
        }
        tp = tp.getParentPath();
        if (tp == null) {
            return null;
        }
        return EditorContextSupport.findStatementInScope(tp);
    }

    public static String getCurrentElement(FileObject fo, final int currentOffset, final String selectedIdentifier, final ElementKind kind, final String[] elementSignaturePtr) throws IllegalComponentStateException {
        String[] currentElementPtr;
        block7: {
            if (fo == null) {
                return null;
            }
            currentElementPtr = new String[]{null};
            try {
                final Future<Void> scanFinished = EditorContextSupport.runWhenScanFinishedReallyLazy(fo, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                            return;
                        }
                        Element el = null;
                        if (kind == ElementKind.CLASS) {
                            Tree tree;
                            boolean isMemberClass = false;
                            if (selectedIdentifier != null && (tree = ci.getTreeUtilities().pathFor(currentOffset).getLeaf()).getKind() == Tree.Kind.MEMBER_SELECT) {
                                TypeMirror tm;
                                MemberSelectTree mst = (MemberSelectTree)tree;
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), mst.getExpression()));
                                if (el != null && (tm = el.asType()).getKind().equals((Object)TypeKind.DECLARED)) {
                                    currentElementPtr[0] = tm.toString();
                                    isMemberClass = true;
                                }
                            }
                            if (!isMemberClass) {
                                TypeElement te;
                                TreePath currentPath = ci.getTreeUtilities().pathFor(currentOffset);
                                Tree tree2 = currentPath.getLeaf();
                                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) {
                                    te = (TypeElement)ci.getTrees().getElement(currentPath);
                                } else {
                                    Scope scope = ci.getTreeUtilities().scopeFor(currentOffset);
                                    te = scope.getEnclosingClass();
                                }
                                if (te != null) {
                                    currentElementPtr[0] = ElementUtilities.getBinaryName((TypeElement)te);
                                }
                                el = te;
                            }
                        } else if (kind == ElementKind.METHOD) {
                            Scope scope = ci.getTreeUtilities().scopeFor(currentOffset);
                            el = scope.getEnclosingMethod();
                            if (el != null) {
                                currentElementPtr[0] = el.getSimpleName().toString();
                                if (currentElementPtr[0].equals("<init>")) {
                                    currentElementPtr[0] = el.getEnclosingElement().getSimpleName().toString();
                                }
                            } else {
                                Tree tree;
                                TreePath path = ci.getTreeUtilities().pathFor(currentOffset);
                                Tree tree2 = tree = path != null ? path.getLeaf() : null;
                                while (tree != null && !(tree instanceof MethodTree) && !(tree instanceof ClassTree)) {
                                    tree = (path = path.getParentPath()) != null ? path.getLeaf() : null;
                                }
                                if (tree instanceof MethodTree) {
                                    String name = ((MethodTree)tree).getName().toString();
                                    if (name.equals("<init>") && scope.getEnclosingClass() != null) {
                                        name = scope.getEnclosingClass().getSimpleName().toString();
                                    }
                                    currentElementPtr[0] = name;
                                }
                            }
                        } else if (kind == ElementKind.FIELD) {
                            int offset;
                            if (selectedIdentifier == null) {
                                String text = ci.getText();
                                int l = text.length();
                                char c = '\u0000';
                                for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != '\n' && c != '\r' && Character.isWhitespace(c); ++offset) {
                                }
                                if (!Character.isWhitespace(c)) {
                                    ++offset;
                                }
                            }
                            TreePath tp = ci.getTreeUtilities().pathFor(offset);
                            Tree tree = tp.getLeaf();
                            if (selectedIdentifier == null) {
                                while (tree.getKind() != Tree.Kind.VARIABLE && (tp = tp.getParentPath()) != null && (tree = tp.getLeaf()).getKind() != Tree.Kind.METHOD && tree.getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
                                }
                            }
                            if (tree.getKind() == Tree.Kind.VARIABLE) {
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree));
                                if (el != null && (el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.ENUM_CONSTANT)) {
                                    currentElementPtr[0] = ((VariableTree)tree).getName().toString();
                                }
                            } else if (tree.getKind() == Tree.Kind.IDENTIFIER && selectedIdentifier != null) {
                                IdentifierTree it = (IdentifierTree)tree;
                                String fieldName = it.getName().toString();
                                Scope scope = ci.getTreeUtilities().scopeFor(offset);
                                TypeElement te = scope.getEnclosingClass();
                                if (te != null) {
                                    List<? extends Element> list = te.getEnclosedElements();
                                    for (Element element : list) {
                                        if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(fieldName)) continue;
                                        currentElementPtr[0] = fieldName;
                                        break;
                                    }
                                }
                            } else if (tree.getKind() == Tree.Kind.MEMBER_SELECT && selectedIdentifier != null) {
                                MemberSelectTree mst = (MemberSelectTree)tree;
                                String fieldName = mst.getIdentifier().toString();
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), mst.getExpression()));
                                if (el != null && el.asType().getKind().equals((Object)TypeKind.DECLARED)) {
                                    List<? extends Element> enclosedElms = ((DeclaredType)el.asType()).asElement().getEnclosedElements();
                                    for (Element element : enclosedElms) {
                                        if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(fieldName)) continue;
                                        currentElementPtr[0] = fieldName;
                                        break;
                                    }
                                }
                            }
                        }
                        if (elementSignaturePtr != null && el instanceof ExecutableElement) {
                            elementSignaturePtr[0] = EditorContextSupport.createSignature((ExecutableElement)el, ci.getTypes());
                        }
                    }
                }, true);
                if (scanFinished.isDone()) break block7;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException eex) {
                                Exceptions.printStackTrace((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentElementPtr[0];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    Exceptions.printStackTrace((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
                return null;
            }
        }
        return currentElementPtr[0];
    }

    public static EditorContext.Operation[] getOperations(String url, int lineNumber, EditorContext.BytecodeProvider bytecodeProvider, ASTOperationCreationDelegate opCreationDelegate) {
        return preferredCCParser.getOperations(url, lineNumber, bytecodeProvider, opCreationDelegate);
    }

    public static EditorContext.MethodArgument[] getArguments(String url, EditorContext.Operation operation, ASTOperationCreationDelegate opCreationDelegate) {
        return preferredCCParser.getArguments(url, operation, opCreationDelegate);
    }

    public static EditorContext.MethodArgument[] getArguments(String url, int methodLineNumber, ASTOperationCreationDelegate opCreationDelegate) {
        return preferredCCParser.getArguments(url, methodLineNumber, opCreationDelegate);
    }

    public static String[] getImports(String url) {
        return preferredCCParser.getImports(url);
    }

    public static <R, D> R interpretOrCompileCode(Evaluator.Expression<Object> expression, String url, int line, ErrorAwareTreePathScanner<Boolean, D> canInterpret, ErrorAwareTreePathScanner<R, D> interpreter, D context, boolean staticContext, Function<Pair<String, byte[]>, Boolean> compiledClassHandler, SourcePathProvider sp) throws InvalidExpressionException {
        return preferredCCParser.interpretOrCompileCode(expression, url, line, canInterpret, interpreter, context, staticContext, compiledClassHandler, sp);
    }

    private static Future<Void> runWhenScanFinishedReallyLazy(final FileObject fo, final Task<CompilationController> task, final boolean shared) throws IOException {
        return EditorContextSupport.scanReallyLazy(new ScanRunnable<IOException>(IOException.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(Future<Void>[] resultPtr, IOException[] excPtr) {
                JavaSource js = JavaSource.forFileObject((FileObject)fo);
                if (js == null) {
                    return;
                }
                try {
                    js.runUserActionTask(task, shared);
                    return;
                }
                catch (IOException ex) {
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        excPtr[0] = ex;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    private static Future<Void> parseWhenScanFinishedReallyLazy(final FileObject fo, final UserTask userTask) throws ParseException {
        return EditorContextSupport.scanReallyLazy(new ScanRunnable<ParseException>(ParseException.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(Future<Void>[] resultPtr, ParseException[] excPtr) {
                Set<Source> sources = Collections.singleton(Source.create((FileObject)fo));
                try {
                    ParserManager.parse(sources, (UserTask)userTask);
                    return;
                }
                catch (ParseException ex) {
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        excPtr[0] = ex;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends Throwable> Future<Void> scanReallyLazy(ScanRunnable<E> run) throws E {
        final Future[] resultPtr = new Future[]{null};
        final Throwable[] excPtr = (Throwable[])Array.newInstance(((ScanRunnable)run).exceptionType, 1);
        ((ScanRunnable)run).setParam(resultPtr, excPtr);
        final RequestProcessor.Task scanning = scanningProcessor.post(run);
        try {
            scanning.waitFinished(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Future[] futureArray = resultPtr;
        synchronized (resultPtr) {
            if (excPtr[0] != null) {
                throw excPtr[0];
            }
            if (resultPtr[0] != null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return resultPtr[0];
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return new Future<Void>(){
                boolean cancelled = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Future<Void> getDelegate() {
                    Future[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return resultPtr[0];
                    }
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    this.cancelled = scanning.cancel();
                    return this.cancelled;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return scanning.isFinished();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    scanning.waitFinished();
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    return null;
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    long mstimeout = unit.toMillis(timeout);
                    if (mstimeout == 0L) {
                        if (!scanning.isFinished()) {
                            throw new TimeoutException("Task timeout");
                        }
                    } else {
                        long s1 = System.nanoTime();
                        boolean finished = scanning.waitFinished(mstimeout);
                        if (!finished) {
                            throw new TimeoutException("Task timeout");
                        }
                        long s2 = System.nanoTime();
                        if ((timeout -= unit.convert(s2 - s1, TimeUnit.NANOSECONDS)) < 0L) {
                            timeout = 1L;
                        }
                    }
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    return null;
                }
            };
        }
    }

    private static final class DoneFuture<T>
    implements Future<T> {
        private final T result;

        public DoneFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }

    private static abstract class ScanRunnable<E extends Throwable>
    implements Runnable {
        private Future<Void>[] resultPtr;
        private E[] excPtr;
        private Class<E> exceptionType;

        public ScanRunnable(Class<E> exceptionType) {
            this.exceptionType = exceptionType;
        }

        private void setParam(Future<Void>[] resultPtr, E[] excPtr) {
            this.resultPtr = resultPtr;
            this.excPtr = excPtr;
        }

        @Override
        public final void run() {
            this.run(this.resultPtr, (Throwable[])this.excPtr);
        }

        public abstract void run(Future<Void>[] var1, E[] var2);
    }
}

