/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.modules.java.lsp.server.ui.IOContext;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.util.Lookup;

public abstract class AbstractLspInputOutputProvider
implements InputOutputProvider<LspIO, PrintWriter, Void, Void> {
    protected AbstractLspInputOutputProvider() {
        if (!"org.netbeans.modules.nbcode.integration.LspInputOutputProvider".equals(this.getClass().getName())) {
            throw new IllegalStateException();
        }
    }

    public final String getId() {
        return "lspio";
    }

    public final LspIO getIO(String name, boolean newIO, Lookup lookup) {
        IOContext ioCtx = IOContext.find();
        return new LspIO(name, ioCtx, lookup);
    }

    public final Reader getIn(LspIO io) {
        return io.in;
    }

    public final PrintWriter getOut(LspIO io) {
        return io.out;
    }

    public final PrintWriter getErr(LspIO io) {
        return io.err;
    }

    public final void print(LspIO io, PrintWriter writer, String text, Hyperlink link, OutputColor color, boolean printLineEnd) {
        if (printLineEnd) {
            writer.println(text);
        } else {
            writer.print(text);
        }
    }

    public final Lookup getIOLookup(LspIO io) {
        return io.lookup;
    }

    public final void resetIO(LspIO io) {
    }

    public final void showIO(LspIO io, Set<ShowOperation> operations) {
    }

    public final void closeIO(LspIO io) {
    }

    public final boolean isIOClosed(LspIO io) {
        return false;
    }

    public final Void getCurrentPosition(LspIO io, PrintWriter writer) {
        return null;
    }

    public final void scrollTo(LspIO io, PrintWriter writer, Void position) {
    }

    public final Void startFold(LspIO io, PrintWriter writer, boolean expanded) {
        return null;
    }

    public final void endFold(LspIO io, PrintWriter writer, Void fold) {
    }

    public final void setFoldExpanded(LspIO io, PrintWriter writer, Void fold, boolean expanded) {
    }

    public final String getIODescription(LspIO io) {
        return "";
    }

    public final void setIODescription(LspIO io, String description) {
    }

    public static final class LspIO {
        private final String name;
        private final IOContext ctx;
        final Lookup lookup;
        final Reader in;
        final PrintWriter out;
        final PrintWriter err;

        LspIO(String name, IOContext ioCtx, Lookup lookup) {
            this.name = name;
            this.ctx = ioCtx;
            this.lookup = lookup;
            this.out = new PrintWriter(new LspWriter(true));
            this.err = new PrintWriter(new LspWriter(false));
            this.in = new CharArrayReader(new char[0]){

                @Override
                public void close() {
                }
            };
        }

        private final class LspWriter
        extends Writer {
            private final boolean stdIO;

            LspWriter(boolean stdIO) {
                this.stdIO = stdIO;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String chunk = new String(cbuf, off, len);
                if (this.stdIO) {
                    LspIO.this.ctx.stdOut(chunk);
                } else {
                    LspIO.this.ctx.stdErr(chunk);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }
}

