/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.impl;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.netbeans.libs.graalsdk.impl.GraalContext;
import org.netbeans.libs.graalsdk.impl.GraalEngineFactory;
import org.netbeans.libs.graalsdk.impl.LangContext;

final class GraalEngine
implements ScriptEngine,
Invocable {
    private final GraalEngineFactory factory;
    private final ScriptContext langContext;

    GraalEngine(GraalEngineFactory f) {
        this.factory = f;
        this.langContext = new LangContext(this.factory.id, f.ctx);
    }

    private String id() {
        return this.factory.id;
    }

    @Override
    public ScriptContext getContext() {
        return this.langContext;
    }

    @Override
    public GraalEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object eval(String src, ScriptContext arg1) throws ScriptException {
        Value result = this.evalImpl(arg1, src);
        return this.unbox(result);
    }

    private Value handleException(ScriptAction r) throws ScriptException {
        try {
            return r.run();
        }
        catch (PolyglotException e) {
            if (e.isHostException()) {
                e.initCause(e.asHostException());
                throw e;
            }
            throw new ScriptException(e);
        }
    }

    private Value evalImpl(ScriptContext arg1, String src) throws ScriptException {
        return this.handleException(() -> ((GraalContext)arg1).ctx().eval(this.id(), src));
    }

    @Override
    public Object eval(Reader arg0, ScriptContext arg1) throws ScriptException {
        Source src = Source.newBuilder(this.id(), arg0, null).buildLiteral();
        Value result = this.handleException(() -> ((GraalContext)arg1).ctx().eval(src));
        return this.unbox(result);
    }

    @Override
    public Object eval(String arg0) throws ScriptException {
        return this.eval(arg0, (ScriptContext)this.factory.ctx);
    }

    @Override
    public Object eval(Reader arg0) throws ScriptException {
        return this.eval(arg0, (ScriptContext)this.factory.ctx);
    }

    @Override
    public Object eval(String arg0, Bindings arg1) throws ScriptException {
        throw new ScriptException("Cannot use alternative bindings!");
    }

    @Override
    public Object eval(Reader arg0, Bindings arg1) throws ScriptException {
        throw new ScriptException("Cannot use alternative bindings!");
    }

    @Override
    public void put(String arg0, Object arg1) {
        this.getBindings(100).put(arg0, arg1);
    }

    @Override
    public Object get(String arg0) {
        return this.getBindings(100).get(arg0);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.getContext().getBindings(scope);
    }

    @Override
    public void setBindings(Bindings arg0, int arg1) {
        if (arg1 == 200 && this.factory.ctx.getGlobals() == arg0) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public void setContext(ScriptContext arg0) {
        throw new IllegalStateException();
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Value thisValue = this.factory.ctx.ctx().asValue(thiz);
        if (!thisValue.canInvokeMember(name)) {
            if (!thisValue.hasMember(name)) {
                throw new NoSuchMethodException(name);
            }
            throw new NoSuchMethodException(name + " is not a function");
        }
        return this.unbox(this.handleException(() -> thisValue.invokeMember(name, args)));
    }

    private GraalContext graalContext() {
        return this.factory.ctx;
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Value fn = this.evalImpl(this.graalContext(), name);
        return this.unbox(this.handleException(() -> fn.execute(args)));
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return this.getInterface(this.graalContext().ctx().getPolyglotBindings(), clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz instanceof Value) {
            return ((Value)thiz).as(clasz);
        }
        Value v = this.factory.ctx.ctx().asValue(thiz);
        T ret = v.as(clasz);
        if (ret != null) {
            return ret;
        }
        if (clasz.isInstance(thiz)) {
            return clasz.cast(thiz);
        }
        return null;
    }

    private Object unbox(Value result) {
        if (result.isNull()) {
            return null;
        }
        return result.as(Object.class);
    }

    private static interface ScriptAction {
        public Value run();
    }
}

