/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.AbstractJSClass;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.EnumSet;
import java.util.List;

public final class JSAdapter
extends AbstractJSClass
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "JSAdapter";
    public static final JSAdapter INSTANCE = new JSAdapter();
    private static final Property ADAPTEE_PROPERTY;
    private static final Property OVERRIDES_PROPERTY;
    private static final String GET = "__get__";
    private static final String PUT = "__put__";
    private static final String HAS = "__has__";
    private static final String CALL = "__call__";
    private static final String DELETE = "__delete__";
    public static final String NEW = "__new__";
    public static final String GET_IDS = "__getIds__";
    public static final String GET_VALUES = "__getValues__";
    private static final HiddenKey ADAPTEE_ID;
    private static final HiddenKey OVERRIDES_ID;

    private JSAdapter() {
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String toString() {
        return this.getClassName();
    }

    public static DynamicObject create(JSContext context, DynamicObject adaptee, DynamicObject overrides, DynamicObject proto) {
        DynamicObject obj = JSObject.create(context, context.getJSAdapterFactory(), adaptee, overrides);
        if (proto != null) {
            JSObject.setPrototype(obj, proto);
        }
        return obj;
    }

    public static DynamicObject getAdaptee(DynamicObject obj) {
        assert (JSAdapter.isJSAdapter(obj));
        return (DynamicObject)ADAPTEE_PROPERTY.get(obj, JSAdapter.isJSAdapter(obj));
    }

    public static DynamicObject getOverrides(DynamicObject obj) {
        assert (JSAdapter.isJSAdapter(obj));
        return (DynamicObject)OVERRIDES_PROPERTY.get(obj, JSAdapter.isJSAdapter(obj));
    }

    public static boolean isJSAdapter(Object obj) {
        return JSObject.isDynamicObject(obj) && JSAdapter.isJSAdapter((DynamicObject)obj);
    }

    public static boolean isJSAdapter(DynamicObject obj) {
        return JSAdapter.isInstance(obj, (JSClass)INSTANCE);
    }

    private static JSException typeError() {
        return Errors.createTypeError("operation not supported");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject overrides = JSAdapter.getOverrides(store);
        if (overrides != null && JSObject.hasOwnProperty(overrides, key)) {
            return JSObject.get(overrides, key);
        }
        return JSAdapter.getIntl(store, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        DynamicObject overrides = JSAdapter.getOverrides(store);
        if (overrides != null && JSObject.hasOwnProperty(overrides, index)) {
            return JSObject.get(overrides, index);
        }
        assert (JSRuntime.longIsRepresentableAsInt(index));
        return JSAdapter.getIntl(store, (int)index);
    }

    private static Object getIntl(DynamicObject thisObj, Object key) {
        if (key instanceof Symbol) {
            return null;
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object get = JSObject.get(adaptee, (Object)GET);
        if (JSFunction.isJSFunction(get)) {
            return JSFunction.call((DynamicObject)get, thisObj, new Object[]{key});
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.hasOwnProperty(overrides, index)) {
            return true;
        }
        return JSAdapter.hasOwnPropertyIntl(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.hasOwnProperty(overrides, key)) {
            return true;
        }
        return JSAdapter.hasOwnPropertyIntl(thisObj, key);
    }

    private static boolean hasOwnPropertyIntl(DynamicObject thisObj, Object key) {
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object has = JSObject.get(adaptee, (Object)HAS);
        if (JSFunction.isJSFunction(has)) {
            return JSRuntime.toBoolean(JSFunction.call((DynamicObject)has, thisObj, new Object[]{key}));
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.hasOwnProperty(overrides, index)) {
            JSObject.set(overrides, index, value, isStrict);
            return true;
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object set = JSObject.get(adaptee, (Object)PUT);
        if (JSFunction.isJSFunction(set)) {
            assert (JSRuntime.longIsRepresentableAsInt(index));
            JSFunction.call((DynamicObject)set, thisObj, new Object[]{(int)index, value});
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.hasOwnProperty(overrides, key)) {
            return JSObject.set(overrides, key, value, isStrict);
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object set = JSObject.get(adaptee, (Object)PUT);
        if (JSFunction.isJSFunction(set)) {
            JSFunction.call((DynamicObject)set, thisObj, new Object[]{key, value});
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.delete(overrides, index, isStrict)) {
            return true;
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object delete = JSObject.get(adaptee, (Object)DELETE);
        if (JSFunction.isJSFunction(delete)) {
            JSFunction.call((DynamicObject)delete, thisObj, new Object[]{index});
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        DynamicObject overrides = JSAdapter.getOverrides(thisObj);
        if (overrides != null && JSObject.delete(overrides, key, isStrict)) {
            return true;
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object delete = JSObject.get(adaptee, (Object)DELETE);
        if (JSFunction.isJSFunction(delete)) {
            JSFunction.call((DynamicObject)delete, thisObj, new Object[]{key});
        }
        return true;
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        return this.set(thisObj, key, desc.getValue(), (Object)thisObj, doThrow);
    }

    @Override
    public boolean preventExtensions(DynamicObject thisObj, boolean doThrow) {
        throw JSAdapter.typeError();
    }

    @Override
    public boolean isExtensible(DynamicObject thisObj) {
        throw JSAdapter.typeError();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        Object returnValue;
        DynamicObject adaptee = JSAdapter.getAdaptee(thisObj);
        Object getIds = JSObject.get(adaptee, (Object)GET_IDS);
        if (JSFunction.isJSFunction(getIds) && JSRuntime.isObject(returnValue = JSFunction.call((DynamicObject)getIds, thisObj, JSArguments.EMPTY_ARGUMENTS_ARRAY))) {
            return JSAdapter.filterOwnPropertyKeys(JSRuntime.createListFromArrayLikeAllowSymbolString(returnValue), strings, symbols);
        }
        return super.getOwnPropertyKeys(thisObj, strings, symbols);
    }

    @Override
    public String safeToString(DynamicObject object, int depth, JSContext context) {
        return this.defaultToString(object);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(realm.getContext(), prototype, ctor);
        JSObjectUtil.putDataProperty(realm.getContext(), prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(ADAPTEE_PROPERTY);
        initialShape = initialShape.addProperty(OVERRIDES_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getMethodHelper(DynamicObject store, Object thisObj, Object key) {
        if (key instanceof Symbol) {
            return null;
        }
        DynamicObject adaptee = JSAdapter.getAdaptee(store);
        Object call = JSObject.get(adaptee, (Object)CALL);
        if (JSFunction.isJSFunction(call)) {
            return JSFunction.bind(JSFunction.getRealm((DynamicObject)call), (DynamicObject)call, store, new Object[]{key});
        }
        throw this.createTypeErrorNoSuchFunction(store, key);
    }

    @CompilerDirectives.TruffleBoundary
    private JSException createTypeErrorNoSuchFunction(DynamicObject thisObj, Object key) {
        return Errors.createTypeErrorFormat("%s has no such function \"%s\"", this.defaultToString(thisObj), key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getPrototypeOf(DynamicObject thisObj) {
        return (DynamicObject)JSShape.getPrototypeProperty(thisObj.getShape()).get(thisObj, false);
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return JSBuiltinObject.setPrototypeStatic(thisObj, newPrototype);
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        throw JSAdapter.typeError();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getJSAdapterPrototype();
    }

    static {
        ADAPTEE_ID = new HiddenKey("adaptee");
        OVERRIDES_ID = new HiddenKey("overrides");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        ADAPTEE_PROPERTY = JSObjectUtil.makeHiddenProperty(ADAPTEE_ID, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.Final)));
        OVERRIDES_PROPERTY = JSObjectUtil.makeHiddenProperty(OVERRIDES_ID, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.Final)));
    }
}

