/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.ActionProviderImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.execute.navigator.Bundle;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class TasksPanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private final transient ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView treeView;
    private NbGradleProject current;
    private Project currentP;
    private final PropertyChangeListener pchadapter = evt -> {
        if ("ProjectInfo".equals(evt.getPropertyName())) {
            this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)this);
        }
    };
    private JScrollPane taskPane;
    private static final String WAIT_GIF = "org/netbeans/modules/gradle/resources/wait.gif";
    private static final String TASK_ICON = "org/netbeans/modules/gradle/resources/gradle-task.gif";

    public TasksPanel() {
        this.initComponents();
        this.treeView = (BeanTreeView)this.taskPane;
        this.treeView.setSelectionMode(1);
    }

    private void initComponents() {
        this.taskPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.taskPane, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void navigate(DataObject d) {
        if (this.current != null) {
            this.current.removePropertyChangeListener(this.pchadapter);
        }
        NbGradleProject n = null;
        FileObject f = d.getPrimaryFile();
        if (!f.isFolder()) {
            f = f.getParent();
        }
        Project p = null;
        try {
            p = ProjectManager.getDefault().findProject(f);
            if (p != null) {
                n = NbGradleProject.get(p);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        if (n == null) {
            this.release();
            return;
        }
        this.current = n;
        this.currentP = p;
        this.current.addPropertyChangeListener(this.pchadapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        GradleBaseProject prj;
        if (this.currentP != null && (prj = GradleBaseProject.get(this.currentP)) != null) {
            Children.Array ch = new Children.Array();
            ArrayList<String> glist = new ArrayList<String>(prj.getTaskGroups());
            glist.remove("<private>");
            Collections.sort(glist, String.CASE_INSENSITIVE_ORDER);
            for (String group : glist) {
                ch.add(new Node[]{new TaskGroupNode(group, prj)});
            }
            ch.add(new Node[]{new TaskGroupNode("<private>", prj)});
            SwingUtilities.invokeLater(() -> this.lambda$run$1((Children)ch));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.treeView.setRootVisible(false);
            this.manager.setRootContext(TasksPanel.createEmptyNode());
        });
    }

    void release() {
        if (this.current != null) {
            this.current.removePropertyChangeListener(this.pchadapter);
        }
        this.current = null;
        this.currentP = null;
        SwingUtilities.invokeLater(() -> {
            this.treeView.setRootVisible(false);
            this.manager.setRootContext(TasksPanel.createEmptyNode());
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(() -> {
            this.treeView.setRootVisible(true);
            this.manager.setRootContext(TasksPanel.createWaitNode());
        });
    }

    private static Node createWaitNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension(WAIT_GIF);
        an.setDisplayName(Bundle.LBL_Wait());
        return an;
    }

    private static Node createEmptyNode() {
        return new AbstractNode(Children.LEAF);
    }

    private /* synthetic */ void lambda$run$1(Children ch) {
        this.treeView.setRootVisible(false);
        this.manager.setRootContext((Node)new AbstractNode(ch));
        this.treeView.expandAll();
    }

    private class TaskGroupChildren
    extends ChildFactory<GradleTask> {
        private final String group;
        private final GradleBaseProject project;

        public TaskGroupChildren(String group, GradleBaseProject project) {
            this.group = group;
            this.project = project;
        }

        protected boolean createKeys(List<GradleTask> list) {
            ArrayList<GradleTask> ret = new ArrayList<GradleTask>(this.project.getTasks(this.group));
            Collections.sort(ret, Comparator.comparing(GradleTask::getName, String.CASE_INSENSITIVE_ORDER));
            list.addAll(ret);
            return true;
        }

        protected Node createNodeForKey(GradleTask key) {
            return new TaskNode(key);
        }
    }

    private class TaskNode
    extends AbstractNode {
        final GradleTask task;

        public TaskNode(GradleTask task) {
            super(Children.LEAF);
            this.task = task;
            this.setIconBaseWithExtension(TasksPanel.TASK_ICON);
            this.setName(task.getPath());
            this.setDisplayName(task.getName());
            this.setShortDescription(task.getDescription());
        }

        public Action[] getActions(boolean context) {
            CustomActionMapping mapping = new CustomActionMapping("custom-");
            mapping.setArgs(this.task.getName());
            return new Action[]{ActionProviderImpl.createCustomGradleAction(TasksPanel.this.currentP, Bundle.LBL_ExecTask(), mapping, Lookups.singleton((Object)TasksPanel.this.currentP), false), ActionProviderImpl.createCustomGradleAction(TasksPanel.this.currentP, Bundle.LBL_ExecCust(), mapping, Lookups.singleton((Object)TasksPanel.this.currentP), true)};
        }

        public GradleTask getTask() {
            return this.task;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private class TaskGroupNode
    extends AbstractNode {
        public TaskGroupNode(String group, GradleBaseProject project) {
            super(Children.create((ChildFactory)new TaskGroupChildren(group, project), (boolean)true), Lookup.EMPTY);
            this.setName(group);
            String displayName = "<private>".equals(group) ? Bundle.LBL_PrivateTasks() : Utils.capitalize(group);
            this.setDisplayName(displayName);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(true);
        }

        public Image getIcon(int type) {
            return this.getIcon(false);
        }

        private Image getIcon(boolean opened) {
            return NodeUtils.getTreeFolderIcon(opened);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }
}

