/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.BreadcrumbsImpl;
import org.netbeans.modules.lsp.client.bindings.HyperlinkProviderImpl;
import org.netbeans.modules.lsp.client.bindings.MarkOccurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TextDocumentSyncServerCapabilityHandler {
    private final RequestProcessor WORKER = new RequestProcessor(TextDocumentSyncServerCapabilityHandler.class.getName(), 1, false, false);
    private final Set<JTextComponent> lastOpened = Collections.newSetFromMap(new IdentityHashMap());
    private static final TextDocumentSyncServerCapabilityHandler h = new TextDocumentSyncServerCapabilityHandler();
    private final Map<Document, Integer> openDocument2PanesCount = new HashMap<Document, Integer>();

    private void handleChange() {
        assert (SwingUtilities.isEventDispatchThread());
        Set currentOpened = Collections.newSetFromMap(new IdentityHashMap());
        currentOpened.addAll(EditorRegistry.componentList());
        Set<JTextComponent> newOpened = Collections.newSetFromMap(new IdentityHashMap());
        newOpened.addAll(currentOpened);
        newOpened.removeAll(this.lastOpened);
        Set<JTextComponent> newClosed = Collections.newSetFromMap(new IdentityHashMap());
        newClosed.addAll(this.lastOpened);
        newClosed.removeAll(currentOpened);
        this.lastOpened.clear();
        this.lastOpened.addAll(currentOpened);
        for (JTextComponent opened : newOpened) {
            this.editorOpened(opened);
        }
        for (JTextComponent closed : newClosed) {
            this.editorClosed(closed);
        }
    }

    private void ensureOpenedInServer(JTextComponent opened) {
        FileObject file = NbEditorUtilities.getFileObject((Document)opened.getDocument());
        if (file == null) {
            return;
        }
        Document doc = opened.getDocument();
        this.ensureDidOpenSent(doc);
        this.registerBackgroundTasks(opened);
    }

    public static void refreshOpenedFilesInServers() {
        SwingUtilities.invokeLater(() -> {
            assert (SwingUtilities.isEventDispatchThread());
            for (JTextComponent c : EditorRegistry.componentList()) {
                h.ensureOpenedInServer(c);
            }
        });
    }

    private void documentOpened(final Document doc) {
        final FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return;
        }
        this.openDocument2PanesCount.computeIfAbsent(doc, d -> {
            doc.putProperty(TextDocumentSyncServerCapabilityHandler.class, true);
            this.ensureDidOpenSent(doc);
            doc.addDocumentListener(new DocumentListener(){
                int version;

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        this.fireEvent(e.getOffset(), e.getDocument().getText(e.getOffset(), e.getLength()), "");
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.fireEvent(e.getOffset(), "", ((BaseDocumentEvent)e).getText());
                }

                private void fireEvent(int start, String newText, String oldText) {
                    try {
                        Position startPos = Utils.createPosition(doc, start);
                        Position endPos = Utils.computeEndPositionForRemovedText(startPos, oldText);
                        TextDocumentContentChangeEvent[] event = new TextDocumentContentChangeEvent[]{new TextDocumentContentChangeEvent(new Range(startPos, endPos), oldText.length(), newText)};
                        boolean typingModification = DocumentUtilities.isTypingModification((Document)doc);
                        long documentVersion = DocumentUtilities.getDocumentVersion((Document)doc);
                        TextDocumentSyncServerCapabilityHandler.this.WORKER.post(() -> {
                            LSPBindings server = LSPBindings.getBindings(file);
                            if (server == null) {
                                return;
                            }
                            TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
                            Either<TextDocumentSyncKind, TextDocumentSyncOptions> sync = server.getInitResult().getCapabilities().getTextDocumentSync();
                            if (sync != null) {
                                if (sync.isLeft()) {
                                    syncKind = (TextDocumentSyncKind)((Object)((Object)sync.getLeft()));
                                } else {
                                    TextDocumentSyncKind change = ((TextDocumentSyncOptions)sync.getRight()).getChange();
                                    if (change != null) {
                                        syncKind = change;
                                    }
                                }
                            }
                            switch (syncKind) {
                                case None: {
                                    return;
                                }
                                case Full: {
                                    doc.render(() -> {
                                        try {
                                            event[0] = new TextDocumentContentChangeEvent(doc.getText(0, doc.getLength()));
                                        }
                                        catch (BadLocationException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                            event[0] = new TextDocumentContentChangeEvent("");
                                        }
                                    });
                                    break;
                                }
                            }
                            VersionedTextDocumentIdentifier di = new VersionedTextDocumentIdentifier(++this.version);
                            di.setUri(Utils.toURI(file));
                            DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(di, Arrays.asList(event));
                            server.getTextDocumentService().didChange(params);
                            if (typingModification && oldText.isEmpty() && event.length == 1 && (newText.equals("}") || newText.equals("\n"))) {
                                ArrayList edits = new ArrayList();
                                doc.render(() -> {
                                    if (documentVersion != DocumentUtilities.getDocumentVersion((Document)doc)) {
                                        return;
                                    }
                                    edits.addAll(Utils.computeDefaultOnTypeIndent(doc, start, startPos, newText));
                                });
                                NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                                    if (documentVersion == DocumentUtilities.getDocumentVersion((Document)doc)) {
                                        Utils.applyEditsNoLock(doc, edits);
                                    }
                                });
                            }
                            server.scheduleBackgroundTasks(file);
                        });
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            return 0;
        });
    }

    private synchronized void editorOpened(JTextComponent c) {
        Document doc = c.getDocument();
        FileObject file = NbEditorUtilities.getFileObject((Document)c.getDocument());
        if (file == null) {
            return;
        }
        this.documentOpened(doc);
        this.registerBackgroundTasks(c);
        this.openDocument2PanesCount.compute(doc, (d, count) -> count + 1);
    }

    private synchronized void editorClosed(JTextComponent c) {
        Document doc = c.getDocument();
        Integer count = this.openDocument2PanesCount.getOrDefault(doc, -1);
        if (count > 0) {
            count = count - 1;
            this.openDocument2PanesCount.put(doc, count);
        }
        if (count == 0) {
            this.WORKER.post(() -> {
                FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                if (file == null) {
                    return;
                }
                LSPBindings server = LSPBindings.getBindings(file);
                if (server == null) {
                    return;
                }
                TextDocumentIdentifier di = new TextDocumentIdentifier();
                di.setUri(Utils.toURI(file));
                DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(di);
                server.getTextDocumentService().didClose(params);
                server.getOpenedFiles().remove(file);
            });
            this.openDocument2PanesCount.remove(doc);
        }
    }

    private void ensureDidOpenSent(Document doc) {
        this.WORKER.post(() -> {
            FileObject file = NbEditorUtilities.getFileObject((Document)doc);
            if (file == null) {
                return;
            }
            LSPBindings server = LSPBindings.getBindings(file);
            if (server == null) {
                return;
            }
            if (!server.getOpenedFiles().add(file)) {
                return;
            }
            doc.putProperty(HyperlinkProviderImpl.class, true);
            String uri = Utils.toURI(file);
            String[] text = new String[1];
            doc.render(() -> {
                try {
                    text[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    text[0] = "";
                }
            });
            TextDocumentItem textDocumentItem = new TextDocumentItem(uri, FileUtil.getMIMEType((FileObject)file), 0, text[0]);
            server.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocumentItem));
            server.scheduleBackgroundTasks(file);
        });
    }

    private void registerBackgroundTasks(JTextComponent c) {
        Document doc = c.getDocument();
        this.WORKER.post(() -> {
            FileObject file = NbEditorUtilities.getFileObject((Document)doc);
            if (file == null) {
                return;
            }
            LSPBindings server = LSPBindings.getBindings(file);
            if (server == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (c.getClientProperty(MarkOccurrences.class) == null) {
                    MarkOccurrences mo = new MarkOccurrences(c);
                    LSPBindings.addBackgroundTask(file, mo);
                    c.putClientProperty(MarkOccurrences.class, mo);
                }
                if (c.getClientProperty(BreadcrumbsImpl.class) == null) {
                    BreadcrumbsImpl bi = new BreadcrumbsImpl(c);
                    LSPBindings.addBackgroundTask(file, bi);
                    c.putClientProperty(BreadcrumbsImpl.class, bi);
                }
            });
        });
    }

    public static class Init
    implements Runnable {
        @Override
        public void run() {
            EditorRegistry.addPropertyChangeListener(evt -> h.handleChange());
            SwingUtilities.invokeLater(() -> h.handleChange());
        }
    }
}

