/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.spi.support;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.core.CancelSupportImplementation;
import org.netbeans.modules.csl.core.SpiSupportAccessor;
import org.openide.util.Parameters;

public final class CancelSupport {
    private static final CancelSupport INSTANCE = new CancelSupport();
    private final ThreadLocal<CancelSupportImplementation> selfSpi = new ThreadLocal();

    private CancelSupport() {
    }

    public boolean isCancelled() {
        CancelSupportImplementation spi = this.selfSpi.get();
        return spi == null ? false : spi.isCancelled();
    }

    @NonNull
    public static CancelSupport getDefault() {
        return INSTANCE;
    }

    static {
        SpiSupportAccessor.setInstance(new SpiSupportAccessorImpl());
    }

    private static final class SpiSupportAccessorImpl
    extends SpiSupportAccessor {
        private SpiSupportAccessorImpl() {
        }

        @Override
        public void setCancelSupport(@NonNull CancelSupportImplementation cancelSupport) {
            Parameters.notNull((CharSequence)"cancelSupport", (Object)cancelSupport);
            CancelSupport cs = CancelSupport.getDefault();
            if (cs.selfSpi.get() == null) {
                cs.selfSpi.set(cancelSupport);
            }
        }

        @Override
        public void removeCancelSupport(@NonNull CancelSupportImplementation cancelSupport) {
            Parameters.notNull((CharSequence)"cancelSupport", (Object)cancelSupport);
            CancelSupport cs = CancelSupport.getDefault();
            if (cs.selfSpi.get() == cancelSupport) {
                cs.selfSpi.remove();
            }
        }
    }
}

