/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.ui.actions.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public final class RerunFailedTestsAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RerunFailedTestsAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Lookup l = activatedNodes[0].getLookup();
        Project p = (Project)l.lookup(Project.class);
        if (p == null) {
            FileObject fileObject = (FileObject)l.lookup(FileObject.class);
            if (fileObject != null) {
                p = FileOwnerQuery.getOwner((FileObject)fileObject);
            } else {
                return false;
            }
        }
        if (TestNGSupport.isActionSupported((TestNGSupport.Action)TestNGSupport.Action.RUN_FAILED, (Project)p)) {
            return TestNGSupport.findTestNGSupport((Project)p).createExecutor(p).hasFailedTests();
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject fileObject;
        Lookup l = activatedNodes[0].getLookup();
        Project p = (Project)l.lookup(Project.class);
        if (p == null && (fileObject = (FileObject)l.lookup(FileObject.class)) != null) {
            p = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport((Project)p).createExecutor(p);
        assert (exec.hasFailedTests());
        TestConfig conf = TestNGUtils.getTestConfig((FileObject)p.getProjectDirectory(), (boolean)true, null, null, null);
        try {
            exec.execute(TestNGSupport.Action.RUN_FAILED, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return Bundle.CTL_RerunFailedTestsAction();
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

