/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.options;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.symfony2.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SymfonyOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(SymfonyOptionsPanel.class.getName());
    private static final String INSTALLER_LAST_FOLDER_SUFFIX = ".installer";
    private static final String SANDBOX_LAST_FOLDER_SUFFIX = ".sandbox";
    private static final FileFilter ZIP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.isFile() && f.getName().toLowerCase().endsWith(".zip");
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_ZipFilesFilter();
        }
    };
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel downloadLabel;
    private JLabel errorLabel;
    private JCheckBox ignoreCacheCheckBox;
    private JButton installerBrowseButton;
    private JLabel installerInfoLabel;
    private JRadioButton installerRadioButton;
    private JButton installerSearchButton;
    private JTextField installerTextField;
    private JLabel noteLabel;
    private JButton sandboxBrowseButton;
    private JLabel sandboxInfoLabel;
    private JRadioButton sandboxRadioButton;
    private JTextField sandboxTextField;
    private ButtonGroup useButtonGroup;

    public SymfonyOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.installerInfoLabel.setText(Bundle.SymfonyOptionsPanel_installer_hint("symfony"));
        this.errorLabel.setText(" ");
        this.enableComponents();
        this.initListeners();
    }

    private void initListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.installerTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.sandboxTextField.getDocument().addDocumentListener(defaultDocumentListener);
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.installerRadioButton.addItemListener(defaultItemListener);
        this.sandboxRadioButton.addItemListener(defaultItemListener);
        this.ignoreCacheCheckBox.addItemListener(defaultItemListener);
    }

    public boolean isUseInstaller() {
        return this.installerRadioButton.isSelected();
    }

    public void setUseInstaller(boolean useInstaller) {
        if (useInstaller) {
            this.installerRadioButton.setSelected(true);
        } else {
            this.sandboxRadioButton.setSelected(true);
        }
    }

    public String getInstaller() {
        return this.installerTextField.getText();
    }

    public void setInstaller(String installer) {
        this.installerTextField.setText(installer);
    }

    public String getSandbox() {
        return this.sandboxTextField.getText();
    }

    public void setSandbox(String sandbox) {
        this.sandboxTextField.setText(sandbox);
    }

    public boolean getIgnoreCache() {
        return this.ignoreCacheCheckBox.isSelected();
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCacheCheckBox.setSelected(ignoreCache);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void enableComponents() {
        boolean useInstaller = this.installerRadioButton.isSelected();
        this.installerTextField.setEnabled(useInstaller);
        this.installerBrowseButton.setEnabled(useInstaller);
        this.installerSearchButton.setEnabled(useInstaller);
        this.sandboxTextField.setEnabled(!useInstaller);
        this.sandboxBrowseButton.setEnabled(!useInstaller);
    }

    private void initComponents() {
        this.useButtonGroup = new ButtonGroup();
        this.installerRadioButton = new JRadioButton();
        this.installerTextField = new JTextField();
        this.installerBrowseButton = new JButton();
        this.installerSearchButton = new JButton();
        this.installerInfoLabel = new JLabel();
        this.sandboxRadioButton = new JRadioButton();
        this.sandboxTextField = new JTextField();
        this.sandboxBrowseButton = new JButton();
        this.sandboxInfoLabel = new JLabel();
        this.ignoreCacheCheckBox = new JCheckBox();
        this.errorLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.downloadLabel = new JLabel();
        this.useButtonGroup.add(this.installerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.installerRadioButton, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.installerRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installerBrowseButton, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.installerBrowseButton.text"));
        this.installerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymfonyOptionsPanel.this.installerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.installerSearchButton, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.installerSearchButton.text"));
        this.installerSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymfonyOptionsPanel.this.installerSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.installerInfoLabel, (String)"HINT");
        this.useButtonGroup.add(this.sandboxRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sandboxRadioButton, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.sandboxRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sandboxBrowseButton, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.sandboxBrowseButton.text"));
        this.sandboxBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SymfonyOptionsPanel.this.sandboxBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sandboxInfoLabel, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.sandboxInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreCacheCheckBox, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.ignoreCacheCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(SymfonyOptionsPanel.class, (String)"SymfonyOptionsPanel.downloadLabel.text"));
        this.downloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SymfonyOptionsPanel.this.downloadLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SymfonyOptionsPanel.this.downloadLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.downloadLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreCacheCheckBox, -2, -1, -2).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.sandboxRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sandboxInfoLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.sandboxTextField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sandboxBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.installerRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.installerInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.installerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installerBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installerSearchButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installerRadioButton).addComponent(this.installerTextField, -2, -1, -2).addComponent(this.installerSearchButton).addComponent(this.installerBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installerInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sandboxRadioButton).addComponent(this.sandboxTextField, -2, -1, -2).addComponent(this.sandboxBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sandboxInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ignoreCacheCheckBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void sandboxBrowseButtonActionPerformed(ActionEvent evt) {
        File sandbox = new FileChooserBuilder(SymfonyOptionsPanel.class.getName() + SANDBOX_LAST_FOLDER_SUFFIX).setTitle(Bundle.LBL_SelectSandbox()).setFilesOnly(true).setFileFilter(ZIP_FILE_FILTER).showOpenDialog();
        if (sandbox != null) {
            sandbox = FileUtil.normalizeFile((File)sandbox);
            this.sandboxTextField.setText(sandbox.getAbsolutePath());
        }
    }

    private void downloadLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void downloadLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://symfony.com/download");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void installerBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(SymfonyOptionsPanel.class.getName() + INSTALLER_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.SymfonyOptionsPanel_installer_browse_title()).showOpenDialog();
        if (file != null) {
            this.installerTextField.setText(file.getAbsolutePath());
        }
    }

    private void installerSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        String file = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String)"symfony");
            }

            public String getWindowTitle() {
                return Bundle.SymfonyOptionsPanel_search_installer_title();
            }

            public String getListTitle() {
                return Bundle.SymfonyOptionsPanel_search_installer();
            }

            public String getPleaseWaitPart() {
                return Bundle.SymfonyOptionsPanel_search_installer_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.SymfonyOptionsPanel_search_installer_notFound();
            }
        });
        if (file != null) {
            this.installerTextField.setText(file);
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SymfonyOptionsPanel.this.enableComponents();
            SymfonyOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SymfonyOptionsPanel.this.fireChange();
        }
    }
}

