/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JdiInitiator {
    private static final double CONNECT_TIMEOUT_FACTOR = 1.5;
    private final int connectTimeout;
    private VirtualMachine vm;
    private Process process = null;
    private final Connector connector;
    private final String remoteAgent;
    private final Map<String, Connector.Argument> connectorArgs;

    public JdiInitiator(int port, List<String> remoteVMOptions, String remoteAgent, boolean isLaunch, String host, int timeout, Map<String, String> customConnectorArgs) {
        HashMap<String, String> argumentName2Value;
        this.remoteAgent = remoteAgent;
        this.connectTimeout = (int)((double)timeout * 1.5);
        String connectorName = isLaunch ? "com.sun.jdi.CommandLineLaunch" : "com.sun.jdi.SocketListen";
        this.connector = this.findConnector(connectorName);
        if (this.connector == null) {
            throw new IllegalArgumentException("No connector named: " + connectorName);
        }
        Map<String, String> map = argumentName2Value = isLaunch ? this.launchArgs(port, String.join((CharSequence)" ", remoteVMOptions)) : new HashMap<String, String>();
        if (!isLaunch) {
            argumentName2Value.put("timeout", "" + timeout);
            if (host != null && !isLaunch) {
                argumentName2Value.put("localAddress", host);
            }
        }
        argumentName2Value.putAll(customConnectorArgs);
        this.connectorArgs = this.mergeConnectorArgs(this.connector, argumentName2Value);
        this.vm = isLaunch ? this.launchTarget() : this.listenTarget(port, remoteVMOptions);
    }

    public VirtualMachine vm() {
        return this.vm;
    }

    public Process process() {
        return this.process;
    }

    private VirtualMachine launchTarget() {
        LaunchingConnector launcher = (LaunchingConnector)this.connector;
        try {
            VirtualMachine new_vm = this.timedVirtualMachineCreation(() -> launcher.launch(this.connectorArgs), null);
            this.process = new_vm.process();
            return new_vm;
        }
        catch (Throwable ex) {
            throw this.reportLaunchFail(ex, "launch");
        }
    }

    private VirtualMachine listenTarget(int port, List<String> remoteVMOptions) {
        ListeningConnector listener = (ListeningConnector)this.connector;
        try {
            String addr = listener.startListening(this.connectorArgs);
            this.debug("Listening at address: " + addr, new Object[0]);
            String javaHome = System.getProperty("java.home");
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaHome == null ? "java" : javaHome + File.separator + "bin" + File.separator + "java");
            args.add("-agentlib:jdwp=transport=" + this.connector.transport().name() + ",address=" + addr);
            args.addAll(remoteVMOptions);
            args.add(this.remoteAgent);
            args.add("" + port);
            ProcessBuilder pb = new ProcessBuilder(args);
            this.process = pb.start();
            VirtualMachine virtualMachine = this.vm = this.timedVirtualMachineCreation(() -> listener.accept(this.connectorArgs), () -> this.process.waitFor());
            return virtualMachine;
        }
        catch (Throwable ex) {
            if (this.process != null) {
                this.process.destroyForcibly();
            }
            throw this.reportLaunchFail(ex, "listen");
        }
        finally {
            try {
                listener.stopListening(this.connectorArgs);
            }
            catch (IllegalConnectorArgumentsException | IOException exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualMachine timedVirtualMachineCreation(Callable<VirtualMachine> creator, Callable<Integer> processComplete) throws Exception {
        VirtualMachine result;
        ExecutorService executor = Executors.newCachedThreadPool(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        try {
            Future<VirtualMachine> future = executor.submit(creator);
            if (processComplete != null) {
                executor.submit(() -> {
                    Integer i = (Integer)processComplete.call();
                    future.cancel(true);
                    return i;
                });
            }
            try {
                result = future.get(this.connectTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                future.cancel(true);
                throw ex;
            }
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }

    private Connector findConnector(String name) {
        for (Connector cntor : Bootstrap.virtualMachineManager().allConnectors()) {
            if (!cntor.name().equals(name)) continue;
            return cntor;
        }
        return null;
    }

    private Map<String, Connector.Argument> mergeConnectorArgs(Connector connector, Map<String, String> argumentName2Value) {
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        for (Map.Entry<String, String> argumentEntry : argumentName2Value.entrySet()) {
            String name = argumentEntry.getKey();
            String value = argumentEntry.getValue();
            Connector.Argument argument = arguments.get(name);
            if (argument == null) {
                throw new IllegalArgumentException("Argument is not defined for connector:" + name + " -- " + connector.name());
            }
            argument.setValue(value);
        }
        return arguments;
    }

    private Map<String, String> launchArgs(int port, String remoteVMOptions) {
        HashMap<String, String> argumentName2Value = new HashMap<String, String>();
        argumentName2Value.put("main", this.remoteAgent + " " + port);
        argumentName2Value.put("options", remoteVMOptions);
        return argumentName2Value;
    }

    private InternalError reportLaunchFail(Throwable ex, String context) {
        return new InternalError("Failed remote " + context + ": " + ex.toString() + " @ " + this.connector + " -- " + this.connectorArgs, ex);
    }

    private void debug(String format, Object ... args) {
    }

    private void debug(Throwable ex, String where) {
    }
}

