/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Refactoring {

    public static class FactoryImpl
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            if (refactoring instanceof WhereUsedQuery) {
                WhereUsedQuery q = (WhereUsedQuery)refactoring;
                LSPBindings bindings = (LSPBindings)q.getRefactoringSource().lookup(LSPBindings.class);
                ReferenceParams params = (ReferenceParams)q.getRefactoringSource().lookup(ReferenceParams.class);
                if (bindings != null && params != null) {
                    return new WhereUsedRefactoringPlugin(q, bindings, params);
                }
            }
            return null;
        }
    }

    public static class LSPRefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final String annotatedLine;
        private final FileObject file;
        private final PositionBounds bounds;

        public LSPRefactoringElementImpl(String annotatedLine, FileObject file, PositionBounds bounds) {
            this.annotatedLine = annotatedLine;
            this.file = file;
            this.bounds = bounds;
        }

        public String getText() {
            return "TODO: getText";
        }

        public String getDisplayText() {
            return this.annotatedLine;
        }

        public void performChange() {
            throw new UnsupportedOperationException();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }
    }

    private static final class WhereUsedRefactoringPlugin
    implements RefactoringPlugin {
        private final WhereUsedQuery query;
        private final LSPBindings bindings;
        private final ReferenceParams params;

        public WhereUsedRefactoringPlugin(WhereUsedQuery query, LSPBindings bindings, ReferenceParams params) {
            this.query = query;
            this.bindings = bindings;
            this.params = params;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            try {
                for (Location location : this.bindings.getTextDocumentService().references(this.params).get()) {
                    FileObject file = Utils.fromURI(location.getUri());
                    PositionBounds boundsTemp = null;
                    if (file == null) continue;
                    try {
                        CloneableEditorSupport es = (CloneableEditorSupport)file.getLookup().lookup(CloneableEditorSupport.class);
                        EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                        StyledDocument doc = ec.openDocument();
                        boundsTemp = new PositionBounds(es.createPositionRef(Utils.getOffset(doc, location.getRange().getStart()), Position.Bias.Forward), es.createPositionRef(Utils.getOffset(doc, location.getRange().getEnd()), Position.Bias.Forward));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        boundsTemp = null;
                    }
                    PositionBounds bounds = boundsTemp;
                    LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
                    Line startLine = lc.getLineSet().getCurrent(location.getRange().getStart().getLine());
                    String lineText = startLine.getText();
                    int highlightEnd = Math.min(lineText.length(), location.getRange().getEnd().getCharacter());
                    String annotatedLine = lineText.substring(0, location.getRange().getStart().getCharacter()) + "<strong>" + lineText.substring(location.getRange().getStart().getCharacter(), highlightEnd) + "</strong>" + lineText.substring(highlightEnd);
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new LSPRefactoringElementImpl(annotatedLine, file, bounds));
                }
                return null;
            }
            catch (InterruptedException | ExecutionException ex) {
                return new Problem(true, ex.getLocalizedMessage());
            }
        }
    }
}

