/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

final class SuiteSubprojectProviderImpl
implements SubprojectProvider {
    private Set<NbModuleProject> projects;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean reloadNeeded;

    public SuiteSubprojectProviderImpl(AntProjectHelper helper, PropertyEvaluator eval) {
        this.helper = helper;
        this.eval = eval;
        eval.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modules".equals(evt.getPropertyName())) {
                    SuiteSubprojectProviderImpl.this.reloadNeeded = true;
                    SuiteSubprojectProviderImpl.this.changeSupport.fireChange();
                }
            }
        });
    }

    public Set<NbModuleProject> getSubprojects() {
        if (this.projects == null || this.reloadNeeded) {
            this.reloadNeeded = false;
            this.projects = this.loadProjects();
        }
        return this.projects;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private Set<NbModuleProject> loadProjects() {
        HashSet<NbModuleProject> newProjects = new HashSet<NbModuleProject>();
        String modules = this.eval.getProperty("modules");
        if (modules != null) {
            for (String piece : PropertyUtils.tokenizePath((String)modules)) {
                FileObject dir = this.helper.resolveFileObject(piece);
                if (dir == null) continue;
                try {
                    Project subp = ProjectManager.getDefault().findProject(dir);
                    if (subp == null || !(subp instanceof NbModuleProject)) continue;
                    newProjects.add((NbModuleProject)subp);
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
        }
        return Collections.unmodifiableSet(newProjects);
    }
}

