/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NbPlatformCustomizerJavadoc
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(NbPlatformCustomizerJavadoc.class);
    private JavadocRootsProvider jrp;
    private PlatformComponentFactory.JavadocRootsModel model;
    private final NbPlatformCustomizerSources.ListListener listListener;
    private JButton addFolderButton;
    private JPanel buttonPanel;
    private JLabel javadocLabel;
    private JList javadocList;
    private JScrollPane javadocSP;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;

    public NbPlatformCustomizerJavadoc() {
        this.initComponents();
        this.initAccessibility();
        this.listListener = new NbPlatformCustomizerSources.ListListener(){

            @Override
            void listChanged() {
                NbPlatformCustomizerJavadoc.this.updateEnabled();
            }
        };
        this.updateEnabled();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.javadocList.addListSelectionListener(this.listListener);
        this.javadocList.getModel().addListDataListener(this.listListener);
    }

    @Override
    public void removeNotify() {
        this.javadocList.removeListSelectionListener(this.listListener);
        this.javadocList.getModel().removeListDataListener(this.listListener);
        super.removeNotify();
    }

    private void updateEnabled() {
        this.removeButton.setEnabled(this.javadocList.getModel().getSize() > 0 && this.javadocList.getSelectedIndex() != -1);
        this.moveUpButton.setEnabled(this.javadocList.getSelectionModel().getMinSelectionIndex() > 0);
        RP.post(new Runnable(){

            @Override
            public void run() {
                final int rootCount = NbPlatformCustomizerJavadoc.this.jrp != null ? NbPlatformCustomizerJavadoc.this.jrp.getJavadocRoots().length : 0;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NbPlatformCustomizerJavadoc.this.moveDownButton.setEnabled(NbPlatformCustomizerJavadoc.this.javadocList.getSelectionModel().getMaxSelectionIndex() < rootCount - 1);
                    }
                });
            }
        });
    }

    public void setJavadocRootsProvider(JavadocRootsProvider jrp) {
        this.jrp = jrp;
        this.model = new PlatformComponentFactory.JavadocRootsModel(jrp);
        this.javadocList.setModel(this.model);
    }

    private void initComponents() {
        this.javadocLabel = new JLabel();
        this.javadocSP = new JScrollPane();
        this.javadocList = new JList();
        this.buttonPanel = new JPanel();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.javadocLabel.setLabelFor(this.javadocList);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"LBL_PlatformJavadoc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javadocLabel, gridBagConstraints);
        this.javadocList.setCellRenderer(PlatformComponentFactory.getURLListRenderer());
        this.javadocSP.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.javadocSP, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_AddZipOrFolder"));
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerJavadoc.this.addZipFolder(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addFolderButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerJavadoc.this.removeFolder(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerJavadoc.this.moveUp(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerJavadoc.this.moveDown(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void moveDown(ActionEvent evt) {
        int[] selIndices = this.javadocList.getSelectedIndices();
        this.model.moveJavadocRootsDown(selIndices);
        for (int i = 0; i < selIndices.length; ++i) {
            int n = i;
            int n2 = selIndices[n] + 1;
            selIndices[n] = n2;
            selIndices[i] = n2;
        }
        this.javadocList.setSelectedIndices(selIndices);
    }

    private void moveUp(ActionEvent evt) {
        int[] selIndices = this.javadocList.getSelectedIndices();
        this.model.moveJavadocRootsUp(selIndices);
        for (int i = 0; i < selIndices.length; ++i) {
            int n = i;
            int n2 = selIndices[n] - 1;
            selIndices[n] = n2;
            selIndices[i] = n2;
        }
        this.javadocList.setSelectedIndices(selIndices);
    }

    private void removeFolder(ActionEvent evt) {
        Object[] selVals = this.javadocList.getSelectedValues();
        int toSelect = this.javadocList.getSelectedIndex() - 1;
        URL[] selURLs = new URL[selVals.length];
        System.arraycopy(selVals, 0, selURLs, 0, selVals.length);
        this.model.removeJavadocRoots(selURLs);
        this.javadocList.setSelectedIndex(toSelect);
    }

    private void addZipFolder(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedNbPlatformLocation());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase(Locale.US).endsWith(".jar") || f.getName().toLowerCase(Locale.US).endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return NbPlatformCustomizerJavadoc.this.getMessage("CTL_JavadocTab");
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            File javadocRoot = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            URL newUrl = FileUtil.urlForArchiveOrDir((File)javadocRoot);
            if (this.model.containsRoot(newUrl)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getMessage("MSG_ExistingJavadocRoot")));
            } else {
                ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(javadocRoot.getParentFile().getAbsolutePath());
                this.model.addJavadocRoot(newUrl);
                this.javadocList.setSelectedValue(newUrl, true);
            }
        }
    }

    private void initAccessibility() {
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_addFolderButton"));
        this.javadocList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_javadocList"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveDownButton"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveUpButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_removeButton"));
    }

    private String getMessage(String key) {
        return NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)key);
    }
}

