/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.swing.dirchooser.DirectoryNode;

class DirectoryCellEditor
extends DefaultCellEditor {
    private final JPanel editorPanel = new JPanel(new BorderLayout());
    private static JTextField textField;
    private static JTree tree;
    private static JFileChooser fileChooser;

    public DirectoryCellEditor(JTree tree, JFileChooser fileChooser, JTextField textField) {
        super(textField);
        DirectoryCellEditor.tree = tree;
        DirectoryCellEditor.textField = textField;
        DirectoryCellEditor.fileChooser = fileChooser;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component c = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        DirectoryNode node = (DirectoryNode)value;
        this.editorPanel.setOpaque(false);
        this.editorPanel.add((Component)new JLabel(fileChooser.getIcon(node.getFile())), "Center");
        this.editorPanel.add(c, "East");
        textField = (JTextField)this.getComponent();
        String text = fileChooser.getName(node.getFile());
        textField.setText(text);
        textField.setColumns(text.length());
        if ("Nimbus".equals(UIManager.getLookAndFeel().getID())) {
            textField.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.editorPanel;
    }

    public static JTextField getTextField() {
        return textField;
    }
}

