/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.Document;
import org.netbeans.modules.xml.sync.SyncRepresentation;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.util.Convertors;
import org.netbeans.modules.xml.util.Util;
import org.xml.sax.InputSource;

public abstract class TextRepresentation
extends SyncRepresentation {
    protected final TextEditorSupport editor;

    public TextRepresentation(TextEditorSupport editor, Synchronizator sync) {
        super(sync);
        this.editor = editor;
    }

    @Override
    public boolean represents(Class type) {
        return Document.class.isAssignableFrom(type);
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Object getChange(Class type) {
        if (type == null || type.isAssignableFrom(Document.class)) {
            return this.editor.getDocument();
        }
        if (type.isAssignableFrom(String.class)) {
            try {
                return Convertors.documentToString(this.editor.openDocument());
            }
            catch (IOException ex) {
                Util.THIS.debug(ex);
                return null;
            }
        }
        if (type.isAssignableFrom(InputSource.class)) {
            InputSource in;
            block12: {
                in = null;
                try {
                    in = Convertors.documentToInputSource(this.editor.openDocument());
                }
                catch (IOException ex) {
                    Util.THIS.debug(ex);
                    return null;
                }
                try {
                    URL baseURL = this.editor.getDataObject().getPrimaryFile().getURL();
                    String systemId = baseURL.toExternalForm();
                    in.setSystemId(systemId);
                }
                catch (IOException ex) {
                    if (!Util.THIS.isLoggable()) break block12;
                    Util.THIS.debug("Warning: missing file object, external entities cannot be parsed.");
                }
            }
            return in;
        }
        if (type.isAssignableFrom(Reader.class)) {
            try {
                return new StringReader(Convertors.documentToString(this.editor.openDocument()));
            }
            catch (IOException ex) {
                Util.THIS.debug(ex);
                return null;
            }
        }
        throw new RuntimeException("Unsupported type: " + type);
    }

    @Override
    public String getDisplayName() {
        return Util.THIS.getString(TextRepresentation.class, "PROP_Text_representation");
    }

    @Override
    public Class getUpdateClass() {
        return String.class;
    }
}

