/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.debugger.jpda.heapwalk.JavaClassImpl;

public class HeapImpl
implements Heap {
    private JPDADebugger debugger;
    private final Object classesCacheAccessLock = new Object();
    private List<JavaClass> classesCache;
    private long[] instanceTotalCountPtr = new long[]{-1L};

    public HeapImpl(JPDADebugger debugger) {
        this.debugger = debugger;
    }

    public JPDADebugger getDebugger() {
        return this.debugger;
    }

    public HeapSummary getSummary() {
        return new DebuggerHeapSummary(this.debugger, this.instanceTotalCountPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeClasses() {
        List allClasses = this.debugger.getAllClasses();
        long[] counts = this.debugger.getInstanceCounts(allClasses);
        long sum = 0L;
        for (long c : counts) {
            sum += c;
        }
        this.instanceTotalCountPtr[0] = sum;
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>(allClasses.size());
        int i = 0;
        for (JPDAClassType clazz : allClasses) {
            javaClasses.add(new JavaClassImpl(this, clazz, counts[i++]));
        }
        Object object = this.classesCacheAccessLock;
        synchronized (object) {
            this.classesCache = javaClasses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JavaClass> getAllClasses() {
        List<JavaClass> javaClasses;
        Object object = this.classesCacheAccessLock;
        synchronized (object) {
            javaClasses = this.classesCache;
            this.classesCache = null;
        }
        if (javaClasses != null) {
            return javaClasses;
        }
        this.computeClasses();
        return this.getAllClasses();
    }

    public List getBiggestObjectsByRetainedSize(int number) {
        return null;
    }

    public Instance getInstanceByID(long id) {
        return null;
    }

    public JavaClass getJavaClassByID(long id) {
        return null;
    }

    public JavaClass getJavaClassByName(String name) {
        List classes = this.debugger.getClassesByName(name);
        if (classes.isEmpty()) {
            return null;
        }
        return new JavaClassImpl(this, (JPDAClassType)classes.get(0), ((JPDAClassType)classes.get(0)).getInstanceCount());
    }

    public Collection getJavaClassesByRegExp(String regexp) {
        List allClasses = this.debugger.getAllClasses();
        ArrayList<JavaClassImpl> result = new ArrayList<JavaClassImpl>(256);
        Pattern pattern = Pattern.compile(regexp);
        for (JPDAClassType clazz : allClasses) {
            if (!pattern.matcher(clazz.getName()).matches()) continue;
            result.add(new JavaClassImpl(this, clazz, clazz.getInstanceCount()));
        }
        return result;
    }

    public Collection getGCRoots() {
        return Collections.emptyList();
    }

    public GCRoot getGCRoot(Instance instance) {
        return null;
    }

    public Properties getSystemProperties() {
        return null;
    }

    public Iterator getAllInstancesIterator() {
        List<JavaClass> classes = this.getAllClasses();
        if (classes != null && !classes.isEmpty()) {
            return new InstancesIterator(classes);
        }
        return Collections.emptyIterator();
    }

    public boolean isRetainedSizeComputed() {
        return true;
    }

    public boolean isRetainedSizeByClassComputed() {
        return true;
    }

    private static final class DebuggerHeapSummary
    implements HeapSummary {
        private JPDADebugger debugger;
        private long[] instanceTotalCountPtr;

        public DebuggerHeapSummary(JPDADebugger debugger, long[] instanceTotalCountPtr) {
            this.debugger = debugger;
            this.instanceTotalCountPtr = instanceTotalCountPtr;
        }

        public long getTotalLiveBytes() {
            return -1L;
        }

        public long getTotalLiveInstances() {
            long sum = this.instanceTotalCountPtr[0];
            if (sum >= 0L) {
                return sum;
            }
            long[] counts = this.debugger.getInstanceCounts(this.debugger.getAllClasses());
            sum = 0L;
            for (long c : counts) {
                sum += c;
            }
            return sum;
        }

        public long getTotalAllocatedBytes() {
            return -1L;
        }

        public long getTotalAllocatedInstances() {
            return -1L;
        }

        public long getTime() {
            return System.currentTimeMillis();
        }
    }

    private static class InstancesIterator
    implements Iterator {
        private Iterator clsIt;
        private Iterator instIt;

        private InstancesIterator(List classes) {
            this.clsIt = classes.iterator();
            this.instIt = ((JavaClass)this.clsIt.next()).getInstances().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.instIt.hasNext()) {
                return true;
            }
            if (this.clsIt.hasNext()) {
                this.instIt = ((JavaClass)this.clsIt.next()).getInstances().iterator();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.instIt.next();
            }
            throw new NoSuchElementException();
        }
    }
}

