/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.arguments;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RealmNode;
import com.oracle.truffle.js.nodes.arguments.ArgumentsObjectNodeGen;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class ArgumentsObjectNode
extends JavaScriptNode {
    private final boolean strict;
    @Node.Child
    private RealmNode realmNode;
    private final int leadingArgCount;
    private final int trailingArgCount;

    protected ArgumentsObjectNode(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        this.strict = strict;
        this.realmNode = RealmNode.create(context);
        this.leadingArgCount = leadingArgCount;
        this.trailingArgCount = trailingArgCount;
    }

    public static JavaScriptNode create(JSContext context, boolean strict, int leadingArgCount, int trailingArgCount) {
        return ArgumentsObjectNodeGen.create(context, strict, leadingArgCount, trailingArgCount);
    }

    protected final boolean isStrict(VirtualFrame frame) {
        assert (this.strict == JSFunction.isStrict(ArgumentsObjectNode.getFunctionObject(frame)) || this.strict);
        return this.strict;
    }

    @Specialization(guards={"isStrict(frame)"})
    protected DynamicObject doStrict(VirtualFrame frame) {
        Object[] arguments = this.getObjectArray(frame);
        return JSArgumentsObject.createStrict(this.realmNode.getContext(), this.realmNode.execute(frame), arguments);
    }

    @Specialization(guards={"!isStrict(frame)"})
    protected DynamicObject doNonStrict(VirtualFrame frame) {
        Object[] arguments = this.getObjectArray(frame);
        return JSArgumentsObject.createNonStrict(this.realmNode.getContext(), this.realmNode.execute(frame), arguments, ArgumentsObjectNode.getFunctionObject(frame));
    }

    private static DynamicObject getFunctionObject(VirtualFrame frame) {
        return (DynamicObject)JSArguments.getFunctionObject(frame.getArguments());
    }

    public Object[] getObjectArray(VirtualFrame frame) {
        return JSArguments.extractUserArguments(frame.getArguments(), this.leadingArgCount, this.trailingArgCount);
    }

    static boolean isInitialized(Object argumentsArray) {
        return argumentsArray != Undefined.instance;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ArgumentsObjectNodeGen.create(this.realmNode.getContext(), this.strict, this.leadingArgCount, this.trailingArgCount);
    }
}

