/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.StringReference;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.InvalidObjectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.ExecutionHaltedInfo;
import org.netbeans.modules.debugger.jpda.truffle.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.truffle.ast.TruffleNode;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackInfo;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleStackVariable;
import org.netbeans.modules.debugger.jpda.util.WeakHashMapActive;
import org.openide.util.Exceptions;

public class TruffleAccess
implements JPDABreakpointListener {
    private static final Logger LOG = Logger.getLogger(TruffleAccess.class.getName());
    public static final String BASIC_CLASS_NAME = "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor";
    private static final String METHOD_EXEC_HALTED = "executionHalted";
    private static final String METHOD_EXEC_STEP_INTO = "executionStepInto";
    private static final String METHOD_DEBUGGER_ACCESS = "debuggerAccess";
    private static final String VAR_NODE = "astNode";
    private static final String VAR_FRAME = "frame";
    private static final String VAR_SRC_ID = "id";
    private static final String VAR_SRC_URI = "uri";
    private static final String VAR_SRC_NAME = "name";
    private static final String VAR_SRC_PATH = "path";
    private static final String VAR_SRC_SOURCESECTION = "sourceSection";
    private static final String VAR_SRC_CODE = "code";
    private static final String VAR_STACK_TRACE = "stackTrace";
    private static final String VAR_TOP_FRAME = "topFrame";
    private static final String VAR_TOP_VARS = "topVariables";
    private static final String VAR_THIS_OBJECT = "thisObject";
    private static final String METHOD_GET_VARIABLES = "getVariables";
    private static final String METHOD_GET_VARIABLES_SGN = "(Lcom/oracle/truffle/api/debug/DebugStackFrame;)[Ljava/lang/Object;";
    private static final String METHOD_GET_SCOPE_VARIABLES = "getScopeVariables";
    private static final String METHOD_GET_SCOPE_VARIABLES_SGN = "(Lcom/oracle/truffle/api/debug/DebugScope;)[Ljava/lang/Object;";
    private static final String METHOD_SET_UNWIND = "setUnwind";
    private static final String METHOD_SET_UNWIND_SGN = "(I)Z";
    private static final String METHOD_GET_AST = "getTruffleAST";
    private static final String METHOD_GET_AST_SGN = "(I)[Ljava/lang/Object;";
    private static final Map<JPDAThread, ThreadInfo> currentPCInfos = new WeakHashMap<JPDAThread, ThreadInfo>();
    private static final PropertyChangeListener threadResumeListener = new ThreadResumeListener();
    private static final TruffleAccess DEFAULT = new TruffleAccess();
    private final Map<JPDADebugger, JPDABreakpoint> execHaltedBP = new WeakHashMapActive();
    private final Map<JPDADebugger, JPDABreakpoint> execStepIntoBP = new WeakHashMapActive();
    private final Map<JPDADebugger, JPDABreakpoint> dbgAccessBP = new WeakHashMapActive();
    private final Object methodCallAccessLock = new Object();
    private MethodCallsAccess methodCallsRunnable;
    private static final MethodCallsAccess METHOD_CALLS_SUCCESSFUL = new MethodCallsAccess(){

        @Override
        public void callMethods(JPDAThread thread) {
        }
    };

    private TruffleAccess() {
    }

    public static void init() {
        DEFAULT.initBPs();
    }

    public static void assureBPSet(JPDADebugger debugger, ClassType accessorClass) {
        TruffleAccess.DEFAULT.execHaltedBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_EXEC_HALTED, debugger));
        TruffleAccess.DEFAULT.execStepIntoBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_EXEC_STEP_INTO, debugger));
        TruffleAccess.DEFAULT.dbgAccessBP.put(debugger, DEFAULT.createBP(accessorClass.name(), METHOD_DEBUGGER_ACCESS, debugger));
    }

    private void initBPs() {
    }

    private JPDABreakpoint createBP(String className, String methodName, JPDADebugger debugger) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)className, (String)methodName);
        mb.setBreakpointType(1);
        mb.setHidden(true);
        mb.setSession(debugger);
        mb.addJPDABreakpointListener((JPDABreakpointListener)this);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        return mb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrentPCInfo getCurrentPCInfo(JPDAThread thread) {
        ThreadInfo info;
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            info = currentPCInfos.get(thread);
        }
        if (info != null) {
            return info.cpi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CurrentPCInfo getSomePCInfo(JPDADebugger dbg) {
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            for (Map.Entry<JPDAThread, ThreadInfo> pce : currentPCInfos.entrySet()) {
                CurrentPCInfo cpi;
                if (((JPDAThreadImpl)pce.getKey()).getDebugger() != dbg || (cpi = pce.getValue().cpi) == null) continue;
                return cpi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent event) {
        Object bp = event.getSource();
        JPDADebugger debugger = event.getDebugger();
        if (this.execHaltedBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), exec halted.", event);
            StepActionProvider.killJavaStep(debugger);
            this.setCurrentPosition(debugger, event.getThread());
        } else if (this.execStepIntoBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), exec step into.", event);
            StepActionProvider.killJavaStep(debugger);
            this.setCurrentPosition(debugger, event.getThread());
        } else if (this.dbgAccessBP.get(debugger) == bp) {
            LOG.log(Level.FINE, "TruffleAccessBreakpoints.breakpointReached({0}), debugger access.", event);
            try {
                Object object = this.methodCallAccessLock;
                synchronized (object) {
                    if (this.methodCallsRunnable != null) {
                        TruffleAccess.invokeMethodCalls(event.getThread(), this.methodCallsRunnable);
                    }
                    this.methodCallsRunnable = METHOD_CALLS_SUCCESSFUL;
                    this.methodCallAccessLock.notifyAll();
                }
            }
            finally {
                event.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentPosition(JPDADebugger debugger, JPDAThread thread) {
        CurrentPCInfo cpci = this.getCurrentPosition(debugger, thread);
        Map<JPDAThread, ThreadInfo> map = currentPCInfos;
        synchronized (map) {
            ThreadInfo info = currentPCInfos.get(thread);
            if (info == null) {
                ((JPDAThreadImpl)thread).addPropertyChangeListener("suspended", threadResumeListener);
                info = new ThreadInfo();
                currentPCInfos.put(thread, info);
            }
            info.cpi = cpci;
        }
    }

    private CurrentPCInfo getCurrentPosition(JPDADebugger debugger, JPDAThread thread) {
        try {
            CallStackFrame csf = thread.getCallStack(0, 1)[0];
            LocalVariable[] localVariables = csf.getLocalVariables();
            ExecutionHaltedInfo haltedInfo = ExecutionHaltedInfo.get(localVariables);
            ObjectVariable sourcePositionVar = haltedInfo.sourcePositions;
            SourcePosition sp = TruffleAccess.getSourcePosition(debugger, sourcePositionVar);
            ObjectVariable frameInfoVar = haltedInfo.frameInfo;
            ObjectVariable frame = (ObjectVariable)frameInfoVar.getField(VAR_FRAME);
            ObjectVariable topVars = (ObjectVariable)frameInfoVar.getField(VAR_TOP_VARS);
            TruffleScope[] scopes = TruffleAccess.createScopes(debugger, topVars);
            ObjectVariable stackTrace = (ObjectVariable)frameInfoVar.getField(VAR_STACK_TRACE);
            String topFrameDescription = (String)frameInfoVar.getField(VAR_TOP_FRAME).createMirrorObject();
            ObjectVariable thisObject = null;
            TruffleStackFrame topFrame = new TruffleStackFrame(debugger, thread, 0, frame, topFrameDescription, null, scopes, thisObject, true);
            TruffleStackInfo stack = new TruffleStackInfo(debugger, thread, stackTrace);
            return new CurrentPCInfo(haltedInfo.stepCmd, thread, sp, scopes, topFrame, stack, depth -> TruffleAccess.getTruffleAST(debugger, (JPDAThreadImpl)thread, depth, sp, stack));
        }
        catch (AbsentInformationException | IllegalStateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static TruffleNode getTruffleAST(JPDADebugger debugger, JPDAThreadImpl thread, int depth, SourcePosition topPosition, TruffleStackInfo stack) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        Lock lock = thread.accessLock.writeLock();
        lock.lock();
        try {
            SourcePosition position;
            if (thread.getState() == 0) {
                TruffleNode truffleNode = null;
                return truffleNode;
            }
            boolean[] suspended = new boolean[]{false};
            PropertyChangeListener threadChange = event -> {
                boolean[] blArray = suspended;
                synchronized (suspended) {
                    suspended[0] = (Boolean)event.getNewValue();
                    suspended.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            };
            thread.addPropertyChangeListener("suspended", threadChange);
            while (!thread.isSuspended()) {
                lock.unlock();
                lock = null;
                boolean[] blArray = suspended;
                // MONITORENTER : suspended
                if (!suspended[0]) {
                    try {
                        suspended.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : blArray
                lock = thread.accessLock.writeLock();
                lock.lock();
            }
            thread.removePropertyChangeListener("suspended", threadChange);
            Variable ast = ((JPDAClassTypeImpl)debugAccessor).invokeMethod((JPDAThread)thread, METHOD_GET_AST, METHOD_GET_AST_SGN, new Variable[]{debugger.createMirrorVar((Object)depth, true)});
            Field[] astInfo = ((ObjectVariable)ast).getFields(0, Integer.MAX_VALUE);
            if (depth == 0) {
                position = topPosition;
            } else {
                TruffleStackFrame[] stackFrames = stack.getStackFrames(true);
                if (depth >= stackFrames.length) {
                    TruffleNode truffleNode = null;
                    return truffleNode;
                }
                position = stackFrames[depth].getSourcePosition();
            }
            TruffleNode truffleNode = TruffleNode.newBuilder().nodes((String)astInfo[0].createMirrorObject()).currentPosition(position).build();
            return truffleNode;
        }
        catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            TruffleNode truffleNode = null;
            return truffleNode;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static SourcePosition getSourcePosition(JPDADebugger debugger, ObjectVariable sourcePositionVar) {
        Field varSrcId = sourcePositionVar.getField(VAR_SRC_ID);
        if (varSrcId == null) {
            return null;
        }
        long id = (Long)varSrcId.createMirrorObject();
        String sourceSection = (String)sourcePositionVar.getField(VAR_SRC_SOURCESECTION).createMirrorObject();
        Source src = Source.getExistingSource(debugger, id);
        if (src == null) {
            String name = (String)sourcePositionVar.getField(VAR_SRC_NAME).createMirrorObject();
            String path = (String)sourcePositionVar.getField(VAR_SRC_PATH).createMirrorObject();
            URI uri = (URI)sourcePositionVar.getField(VAR_SRC_URI).createMirrorObject();
            StringReference codeRef = (StringReference)((JDIVariable)sourcePositionVar.getField(VAR_SRC_CODE)).getJDIValue();
            src = Source.getSource(debugger, id, name, path, uri, codeRef);
        }
        return new SourcePosition(debugger, id, src, sourceSection);
    }

    private static TruffleScope[] createScopes(JPDADebugger debugger, ObjectVariable varsArrVar) {
        boolean scopeFunction;
        String scopeName;
        Field[] varsArr = varsArrVar.getFields(0, Integer.MAX_VALUE);
        LinkedList<TruffleScope> scopes = new LinkedList<TruffleScope>();
        int i = 0;
        int n = varsArr.length;
        if (i < n) {
            scopeName = (String)varsArr[i++].createMirrorObject();
            scopeFunction = (Boolean)varsArr[i++].createMirrorObject();
            int numArgs = (Integer)varsArr[i++].createMirrorObject();
            int numVars = (Integer)varsArr[i++].createMirrorObject();
            TruffleVariable[] arguments = new TruffleVariable[numArgs];
            i = TruffleAccess.fillVars(debugger, arguments, varsArr, i);
            TruffleVariable[] variables = new TruffleVariable[numVars];
            i = TruffleAccess.fillVars(debugger, variables, varsArr, i);
            scopes.add(new TruffleScope(scopeName, scopeFunction, arguments, variables));
        }
        while (i < n) {
            scopeName = (String)varsArr[i++].createMirrorObject();
            scopeFunction = (Boolean)varsArr[i++].createMirrorObject();
            boolean hasArgs = (Boolean)varsArr[i++].createMirrorObject();
            boolean hasVars = (Boolean)varsArr[i++].createMirrorObject();
            ObjectVariable scope = (ObjectVariable)varsArr[i++];
            scopes.add(new TruffleScope(scopeName, scopeFunction, hasArgs, hasVars, debugger, scope));
        }
        return scopes.toArray(new TruffleScope[scopes.size()]);
    }

    private static int fillVars(JPDADebugger debugger, TruffleVariable[] vars, Field[] varsArr, int i) {
        for (int vi = 0; vi < vars.length; ++vi) {
            String name = (String)varsArr[i++].createMirrorObject();
            LanguageName language = LanguageName.parse((String)varsArr[i++].createMirrorObject());
            String type = (String)varsArr[i++].createMirrorObject();
            boolean readable = (Boolean)varsArr[i++].createMirrorObject();
            boolean writable = (Boolean)varsArr[i++].createMirrorObject();
            boolean internal = (Boolean)varsArr[i++].createMirrorObject();
            String valueStr = (String)varsArr[i++].createMirrorObject();
            ObjectVariable valueSourceDef = (ObjectVariable)varsArr[i++];
            Supplier<SourcePosition> valueSource = TruffleAccess.parseSourceLazy(debugger, (Variable)valueSourceDef, (JDIVariable)varsArr[i++]);
            ObjectVariable typeSourceDef = (ObjectVariable)varsArr[i++];
            Supplier<SourcePosition> typeSource = TruffleAccess.parseSourceLazy(debugger, (Variable)typeSourceDef, (JDIVariable)varsArr[i++]);
            ObjectVariable value = (ObjectVariable)varsArr[i++];
            vars[vi] = new TruffleStackVariable(debugger, name, language, type, readable, writable, internal, valueStr, valueSourceDef.getUniqueID() != 0L, valueSource, typeSourceDef.getUniqueID() != 0L, typeSource, value);
        }
        return i;
    }

    public static TruffleVariable[][] getScopeArgsAndVars(JPDADebugger debugger, ObjectVariable debugScope) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable scopeVars = debugAccessor.invokeMethod(METHOD_GET_SCOPE_VARIABLES, METHOD_GET_SCOPE_VARIABLES_SGN, new Variable[]{debugScope});
            Field[] varsArr = ((ObjectVariable)scopeVars).getFields(0, Integer.MAX_VALUE);
            int n = varsArr.length;
            int i = 0;
            if (i < n) {
                int numArgs = (Integer)varsArr[i++].createMirrorObject();
                int numVars = (Integer)varsArr[i++].createMirrorObject();
                TruffleVariable[] arguments = new TruffleVariable[numArgs];
                i = TruffleAccess.fillVars(debugger, arguments, varsArr, i);
                TruffleVariable[] variables = new TruffleVariable[numVars];
                i = TruffleAccess.fillVars(debugger, variables, varsArr, i);
                return new TruffleVariable[][]{arguments, variables};
            }
        }
        catch (NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new TruffleVariable[][]{new TruffleVariable[0], new TruffleVariable[0]};
    }

    private static Supplier<SourcePosition> parseSourceLazy(JPDADebugger debugger, Variable sourceDefVar, JDIVariable codeRefVar) {
        return () -> TruffleAccess.parseSource(debugger, (String)sourceDefVar.createMirrorObject(), (StringReference)codeRefVar.getJDIValue());
    }

    private static SourcePosition parseSource(JPDADebugger debugger, String sourceDef, StringReference codeRef) {
        String sourceSection;
        URI sourceURI;
        String sourcePath;
        String sourceName;
        int sourceId;
        if (sourceDef == null) {
            return null;
        }
        try {
            int i1 = 0;
            int i2 = sourceDef.indexOf(10, i1);
            sourceId = Integer.parseInt(sourceDef.substring(i1, i2));
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            sourceName = sourceDef.substring(i1, i2);
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            sourcePath = sourceDef.substring(i1, i2);
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            try {
                sourceURI = new URI(sourceDef.substring(i1, i2));
            }
            catch (URISyntaxException usex) {
                throw new IllegalStateException("Bad URI: " + sourceDef.substring(i1, i2), usex);
            }
            i1 = i2 + 1;
            i2 = sourceDef.indexOf(10, i1);
            if (i2 < 0) {
                i2 = sourceDef.length();
            }
            sourceSection = sourceDef.substring(i1, i2);
        }
        catch (IndexOutOfBoundsException ioob) {
            throw new IllegalStateException("var source definition='" + sourceDef + "'", ioob);
        }
        Source src = Source.getSource(debugger, sourceId, sourceName, sourcePath, sourceURI, codeRef);
        return new SourcePosition(debugger, sourceId, src, sourceSection);
    }

    public static TruffleScope[] createFrameScopes(JPDADebugger debugger, Variable frameInstance) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable frameVars = debugAccessor.invokeMethod(METHOD_GET_VARIABLES, METHOD_GET_VARIABLES_SGN, new Variable[]{frameInstance});
            TruffleScope[] scopes = TruffleAccess.createScopes(debugger, (ObjectVariable)frameVars);
            return scopes;
        }
        catch (NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new TruffleScope[0];
        }
    }

    public static boolean unwind(JPDADebugger debugger, JPDAThread thread, int depth) {
        JPDAClassType debugAccessor = TruffleDebugManager.getDebugAccessorJPDAClass(debugger);
        try {
            Variable arg = debugger.createMirrorVar((Object)depth);
            Variable res = ((JPDAClassTypeImpl)debugAccessor).invokeMethod(thread, METHOD_SET_UNWIND, METHOD_SET_UNWIND_SGN, new Variable[]{arg});
            return (Boolean)res.createMirrorObject();
        }
        catch (InvalidObjectException | NoSuchMethodException | InvalidExpressionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean methodCallingAccess(final JPDADebugger debugger, MethodCallsAccess methodCalls) {
        Object object = TruffleAccess.DEFAULT.methodCallAccessLock;
        synchronized (object) {
            boolean success;
            JPDAThread thread;
            while (TruffleAccess.DEFAULT.methodCallsRunnable != null) {
                try {
                    TruffleAccess.DEFAULT.methodCallAccessLock.wait();
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            CurrentPCInfo currentPCInfo = TruffleAccess.getSomePCInfo(debugger);
            if (currentPCInfo != null && (thread = currentPCInfo.getThread()) != null && (success = TruffleAccess.invokeMethodCalls(thread, methodCalls))) {
                return true;
            }
            boolean interrupted = RemoteServices.interruptServiceAccessThread(debugger);
            if (!interrupted) {
                return false;
            }
            PropertyChangeListener finishListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (4 == debugger.getState()) {
                        Object object = DEFAULT.methodCallAccessLock;
                        synchronized (object) {
                            DEFAULT.methodCallAccessLock.notifyAll();
                        }
                    }
                }
            };
            debugger.addPropertyChangeListener("state", finishListener);
            TruffleAccess.DEFAULT.methodCallsRunnable = methodCalls;
            try {
                TruffleAccess.DEFAULT.methodCallAccessLock.wait();
            }
            catch (InterruptedException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                debugger.removePropertyChangeListener("state", finishListener);
            }
            boolean success2 = TruffleAccess.DEFAULT.methodCallsRunnable == METHOD_CALLS_SUCCESSFUL;
            TruffleAccess.DEFAULT.methodCallsRunnable = null;
            return success2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean invokeMethodCalls(JPDAThread thread, MethodCallsAccess methodCalls) {
        assert (Thread.holdsLock(TruffleAccess.DEFAULT.methodCallAccessLock));
        boolean invoking = false;
        InvocationException iex = null;
        try {
            ((JPDAThreadImpl)thread).notifyMethodInvoking();
            invoking = true;
            methodCalls.callMethods(thread);
            boolean bl = true;
            return bl;
        }
        catch (PropertyVetoException pvex) {
            boolean bl = false;
            return bl;
        }
        catch (InvocationException ex) {
            iex = ex;
        }
        finally {
            if (invoking) {
                ((JPDAThreadImpl)thread).notifyMethodInvokeDone();
            }
        }
        if (iex != null) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, ((JPDAThreadImpl)thread).getDebugger()).preload((JPDAThreadImpl)thread);
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Invoking " + methodCalls)));
        }
        return false;
    }

    private static final class ThreadResumeListener
    implements PropertyChangeListener {
        private ThreadResumeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl t = (JPDAThreadImpl)evt.getSource();
            if (!((Boolean)evt.getNewValue()).booleanValue() && !t.isMethodInvoking()) {
                Map map = currentPCInfos;
                synchronized (map) {
                    ThreadInfo info = (ThreadInfo)currentPCInfos.get(t);
                    if (info != null) {
                        info.cpi = null;
                    }
                }
            }
        }
    }

    private static final class ThreadInfo {
        volatile CurrentPCInfo cpi;

        private ThreadInfo() {
        }
    }

    public static interface MethodCallsAccess {
        public void callMethods(JPDAThread var1) throws InvocationException;
    }
}

