/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.docker.api.Credentials;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class DockerConfig {
    private static final String DOCKER_HUB_DOMAIN = "index.docker.io";
    private static final String DOCKER_HUB_REGISTRY = "https://index.docker.io/v1/";
    private static DockerConfig instance;
    private final ConfigListener listener = new ConfigListener();
    private JSONObject auths;
    private Map<String, String> httpHeaders;

    private DockerConfig() {
    }

    public static synchronized DockerConfig getDefault() {
        if (instance == null) {
            instance = new DockerConfig();
            instance.init();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Credentials> getAllCredentials() throws IOException {
        JSONObject currentAuths;
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            currentAuths = this.auths;
        }
        ArrayList<Credentials> ret = new ArrayList<Credentials>(currentAuths.size());
        for (Map.Entry e : currentAuths.entrySet()) {
            if (!(e.getKey() instanceof String)) continue;
            String registry = (String)e.getKey();
            JSONObject value = (JSONObject)e.getValue();
            if (value == null) continue;
            ret.add(DockerConfig.createCredentials(registry, value));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials(String registry) throws IOException {
        JSONObject currentAuths;
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            currentAuths = this.auths;
        }
        Set<String> names = DockerConfig.generateRegistryNames(registry);
        JSONObject value = null;
        Iterator<String> it = names.iterator();
        while (value == null && it.hasNext()) {
            value = (JSONObject)currentAuths.get((Object)it.next());
        }
        if (value == null) {
            return null;
        }
        return DockerConfig.createCredentials(registry, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getHttpHeaders() throws IOException {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            return new HashMap<String, String>(this.httpHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(Credentials credentials) throws IOException {
        StringBuilder sb = new StringBuilder(credentials.getUsername());
        sb.append(':');
        sb.append(credentials.getPassword());
        String auth = Base64.getEncoder().encodeToString(sb.toString().getBytes("UTF-8"));
        JSONObject value = new JSONObject();
        value.put((Object)"auth", (Object)auth);
        value.put((Object)"email", (Object)credentials.getEmail());
        Pair<File, Boolean> fileDesc = DockerConfig.getConfigFile();
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            try (RandomAccessFile f = new RandomAccessFile((File)fileDesc.first(), "rw");
                 FileChannel ch = f.getChannel();){
                try (FileLock lock = ch.lock();){
                    JSONObject current = null;
                    if (f.length() > 0L) {
                        current = (JSONObject)new JSONParser().parse(Channels.newReader((ReadableByteChannel)ch, "UTF-8"));
                    }
                    if (current == null) {
                        current = new JSONObject();
                    }
                    JSONObject currentAuths = current;
                    if (!((Boolean)fileDesc.second()).booleanValue() && (currentAuths = (JSONObject)current.get((Object)"auths")) == null) {
                        currentAuths = new JSONObject();
                        current.put((Object)"auths", (Object)currentAuths);
                    }
                    currentAuths.put((Object)credentials.getRegistry(), (Object)value);
                    ch.truncate(0L);
                    Writer w = Channels.newWriter((WritableByteChannel)ch, "UTF-8");
                    current.writeJSONString(w);
                    w.flush();
                }
                catch (ParseException ex) {
                    throw new IOException(ex);
                }
            }
            finally {
                this.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCredentials(Credentials credentials) throws IOException {
        Pair<File, Boolean> fileDesc = DockerConfig.getConfigFile();
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            try (RandomAccessFile f = new RandomAccessFile((File)fileDesc.first(), "rw");){
                Throwable throwable = null;
                try (FileChannel ch = f.getChannel();){
                    JSONObject currentAuths;
                    JSONObject current;
                    Throwable throwable2;
                    FileLock lock;
                    block65: {
                        block69: {
                            block66: {
                                block63: {
                                    block68: {
                                        block64: {
                                            lock = ch.lock();
                                            throwable2 = null;
                                            current = (JSONObject)new JSONParser().parse(Channels.newReader((ReadableByteChannel)ch, "UTF-8"));
                                            if (f.length() > 0L) break block63;
                                            if (lock == null) return;
                                            if (throwable2 == null) break block64;
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            break block68;
                                        }
                                        lock.close();
                                    }
                                    return;
                                }
                                currentAuths = current;
                                if (((Boolean)fileDesc.second()).booleanValue() || (currentAuths = (JSONObject)current.get((Object)"auths")) != null) break block65;
                                if (lock == null) return;
                                if (throwable2 == null) break block66;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                break block69;
                            }
                            lock.close();
                        }
                        return;
                    }
                    try {
                        currentAuths.remove((Object)credentials.getRegistry());
                        ch.truncate(0L);
                        Writer w = Channels.newWriter((WritableByteChannel)ch, "UTF-8");
                        current.writeJSONString(w);
                        w.flush();
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (lock != null) {
                            if (throwable2 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                lock.close();
                            }
                        }
                    }
                }
                catch (ParseException ex) {
                    throw new IOException(ex);
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
            }
            finally {
                this.clearCache();
            }
            return;
        }
    }

    private void init() {
        FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)DockerConfig.getNewConfigFile());
        FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)DockerConfig.getOldConfigFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws IOException {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            if (this.auths == null || this.httpHeaders == null) {
                Pair<JSONObject, Boolean> parsed = this.parse();
                if (parsed == null) {
                    this.auths = new JSONObject();
                    this.httpHeaders = new JSONObject();
                    return;
                }
                JSONObject currentAuths = (JSONObject)parsed.first();
                if (!((Boolean)parsed.second()).booleanValue()) {
                    currentAuths = (JSONObject)currentAuths.get((Object)"auths");
                }
                if (currentAuths == null) {
                    currentAuths = new JSONObject();
                }
                this.auths = currentAuths;
                JSONObject currentHeaders = null;
                if (!((Boolean)parsed.second()).booleanValue()) {
                    currentHeaders = (JSONObject)((JSONObject)parsed.first()).get((Object)"HttpHeaders");
                }
                if (currentHeaders == null) {
                    currentHeaders = new JSONObject();
                }
                this.httpHeaders = new HashMap<String, String>();
                for (Map.Entry e : currentHeaders.entrySet()) {
                    this.httpHeaders.put((String)e.getKey(), (String)e.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.auths = null;
            this.httpHeaders = null;
        }
    }

    /*
     * Exception decompiling
     */
    private Pair<JSONObject, Boolean> parse() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 39[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Credentials createCredentials(String registry, JSONObject value) throws IOException {
        if (value == null) {
            return null;
        }
        byte[] auth = Base64.getDecoder().decode((String)value.get((Object)"auth"));
        CharBuffer chars = Charset.forName("UTF-8").newDecoder().decode(ByteBuffer.wrap(auth));
        int index = -1;
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.get(i) != ':') continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IOException("Malformed registry authentication record");
        }
        String username = new String(chars.array(), 0, index);
        char[] password = new char[chars.length() - index - 1];
        if (password.length > 0) {
            System.arraycopy(chars.array(), index + 1, password, 0, password.length);
        }
        return new Credentials(registry, username, password, (String)value.get((Object)"email"));
    }

    private static Pair<File, Boolean> getConfigFile() {
        File newFile = DockerConfig.getNewConfigFile();
        boolean oldConfig = false;
        File file = newFile;
        if (!file.isFile()) {
            file = DockerConfig.getOldConfigFile();
            oldConfig = true;
        }
        if (!file.isFile()) {
            file = newFile;
            oldConfig = false;
        }
        return Pair.of((Object)file, (Object)oldConfig);
    }

    private static File getNewConfigFile() {
        String configPath = System.getenv("DOCKER_CONFIG");
        if (configPath == null) {
            configPath = System.getProperty("user.home") + File.separatorChar + ".docker";
        }
        return new File(configPath, "config.json");
    }

    private static File getOldConfigFile() {
        return new File(System.getProperty("user.home"), ".dockercfg");
    }

    private static Set<String> generateRegistryNames(String registry) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (registry == null) {
            result.add(DOCKER_HUB_REGISTRY);
            result.addAll(DockerConfig.generateRegistryNames(DOCKER_HUB_DOMAIN));
            return result;
        }
        result.add(registry);
        DockerConfig.generatePaths(registry, result);
        if (!registry.contains("://")) {
            String https = "https://" + registry;
            result.add(https);
            DockerConfig.generatePaths(https, result);
            String http = "http://" + registry;
            result.add(http);
            DockerConfig.generatePaths(http, result);
        }
        return result;
    }

    private static void generatePaths(String registry, Set<String> result) {
        StringBuilder extended = new StringBuilder(registry);
        if (registry.endsWith("/")) {
            extended.append("v1");
        } else {
            extended.append("/v1");
        }
        result.add(extended.toString());
        extended.append("/");
        result.add(extended.toString());
    }

    private class ConfigListener
    implements FileChangeListener {
        private ConfigListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileChanged(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileDeleted(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileRenamed(FileRenameEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }
    }
}

