/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.events.Namespace;

public class MergedNsContext
implements NamespaceContext {
    final NamespaceContext _parentCtxt;
    final List<Namespace> _namespaces;

    protected MergedNsContext(NamespaceContext namespaceContext, List<Namespace> list) {
        this._parentCtxt = namespaceContext;
        this._namespaces = list == null ? Collections.emptyList() : list;
    }

    public static MergedNsContext construct(NamespaceContext namespaceContext, List<Namespace> list) {
        return new MergedNsContext(namespaceContext, list);
    }

    @Override
    public String getNamespaceURI(String string2) {
        String string3;
        if (string2 == null) {
            throw new IllegalArgumentException("Illegal to pass null prefix");
        }
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            Namespace namespace = this._namespaces.get(i);
            if (!string2.equals(namespace.getPrefix())) continue;
            return namespace.getNamespaceURI();
        }
        if (this._parentCtxt != null && (string3 = this._parentCtxt.getNamespaceURI(string2)) != null) {
            return string3;
        }
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string2.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    @Override
    public String getPrefix(String string2) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            object = this._namespaces.get(i);
            if (!string2.equals(object.getNamespaceURI())) continue;
            return object.getPrefix();
        }
        if (this._parentCtxt != null) {
            String string3;
            String string4 = this._parentCtxt.getPrefix(string2);
            if (string4 != null && (string3 = this.getNamespaceURI(string4)).equals(string2)) {
                return string4;
            }
            Iterator<String> iterator = this._parentCtxt.getPrefixes(string2);
            while (iterator.hasNext()) {
                String string5;
                object = iterator.next();
                if (((String)object).equals(string4) || !(string5 = this.getNamespaceURI((String)object)).equals(string2)) continue;
                return object;
            }
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string2.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string2) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        ArrayList<String> arrayList = null;
        int n = this._namespaces.size();
        for (int i = 0; i < n; ++i) {
            object = this._namespaces.get(i);
            if (!string2.equals(object.getNamespaceURI())) continue;
            arrayList = this.addToList(arrayList, object.getPrefix());
        }
        if (this._parentCtxt != null) {
            Iterator<String> iterator = this._parentCtxt.getPrefixes(string2);
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                object = this.getNamespaceURI(string3);
                if (!((String)object).equals(string2)) continue;
                arrayList = this.addToList(arrayList, string3);
            }
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            arrayList = this.addToList(arrayList, "xml");
        }
        if (string2.equals("http://www.w3.org/2000/xmlns/")) {
            arrayList = this.addToList(arrayList, "xmlns");
        }
        return null;
    }

    protected <T> ArrayList<T> addToList(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(t);
        return arrayList;
    }
}

