/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.Map;
import java.util.Objects;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPFrame;

public final class CPPVariable {
    private final CPPFrame frame;
    private final String uniqueName;
    private final String name;
    private final String type;
    private final String value;
    private final int numChildren;
    private volatile Map<String, CPPVariable> children;

    CPPVariable(CPPFrame frame, String uniqueName, String name, String type, MIValue value, int numChildren) {
        this.frame = frame;
        this.uniqueName = uniqueName;
        this.name = name;
        this.type = type;
        this.value = value instanceof MIConst ? ((MIConst)value).value() : Objects.toString(value);
        this.numChildren = numChildren;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CPPVariable> getChildrenVariables() {
        Map<String, CPPVariable> vars = this.children;
        if (vars == null) {
            CPPVariable cPPVariable = this;
            synchronized (cPPVariable) {
                vars = this.children;
                if (vars == null) {
                    this.children = vars = CPPFrame.retrieveVariables(this.frame, this);
                }
            }
        }
        return vars;
    }
}

