/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.progress;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.java.lsp.server.progress.LspInternalHandle;
import org.netbeans.modules.java.lsp.server.progress.LspProgressUIWorker;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationEvent;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationListener;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.modules.progress.spi.TaskModel;
import org.openide.util.Lookup;

public final class OperationContext {
    private static Reference<OperationContext> lastCtx = new WeakReference<Object>(null);
    private static Reference<OperationContext> initialCtx = new WeakReference<Object>(null);
    private final NbCodeLanguageClient client;
    private Either<String, Number> progressToken;
    private String partialResultsToken;
    private final Controller progressController;
    private final List<InternalHandle> createdHandles = new ArrayList<InternalHandle>();
    private boolean finished;
    private final OperationContext top;
    private boolean disableCancels;
    private final List<LR> operationListeners = new ArrayList<LR>();
    private Map<Either<String, Number>, InternalHandle> handles = new HashMap<Either<String, Number>, InternalHandle>();

    OperationContext(OperationContext top, NbCodeLanguageClient client, Controller controller) {
        this.client = client;
        this.progressController = controller;
        this.top = top == null ? this : top;
    }

    private TaskModel getTaskModel() {
        return this.progressController.getModel();
    }

    public synchronized Either<String, Number> acquireProgressToken() {
        Either<String, Number> t = this.progressToken;
        this.progressToken = null;
        return t;
    }

    public String getPartialResultsToken() {
        return this.partialResultsToken;
    }

    public void setProgressToken(Either<String, Number> s) {
        this.progressToken = s;
    }

    public OperationContext operationContext() {
        OperationContext ctx = new OperationContext(this, this.client, this.progressController);
        lastCtx = new WeakReference<OperationContext>(ctx);
        return ctx;
    }

    public static synchronized OperationContext create(NbCodeLanguageClient client) {
        OperationContext ctx = new OperationContext(null, client, new Controller((ProgressUIWorker)new LspProgressUIWorker()));
        lastCtx = new WeakReference<OperationContext>(ctx);
        ctx.registerInitialContext();
        return ctx;
    }

    void registerInitialContext() {
        initialCtx = new WeakReference<OperationContext>(this);
    }

    public NbCodeLanguageClient getClient() {
        return this.client;
    }

    public static synchronized OperationContext find(Lookup lkp) {
        OperationContext ctx;
        Lookup def = Lookup.getDefault();
        if (lkp == null) {
            lkp = def;
        }
        if ((ctx = (OperationContext)lkp.lookup(OperationContext.class)) != null) {
            return ctx;
        }
        ctx = lastCtx.get();
        if (ctx == null && (ctx = initialCtx.get()) == null) {
            ctx = OperationContext.create((NbCodeLanguageClient)lkp.lookup(NbCodeLanguageClient.class));
        }
        lastCtx = new WeakReference<OperationContext>(ctx);
        return ctx;
    }

    public void stop() {
        this.acquireProgressToken();
        if (!this.isActive()) {
            return;
        }
        if (this != this.top) {
            this.finished = true;
        }
    }

    public boolean isActive() {
        return Lookup.getDefault().lookup(OperationContext.class) == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalHandle findActiveHandle(Either<String, Number> token) {
        if (this.top != this) {
            return this.top.findActiveHandle(token);
        }
        OperationContext operationContext = this;
        synchronized (operationContext) {
            return this.handles.get(token);
        }
    }

    private Either<String, Number> addHandle(Either<String, Number> token, InternalHandle h) {
        this.top.registerHandle(token, h);
        return token;
    }

    void removeHandle(Either<String, Number> token, LspInternalHandle h) {
        if (this.top != this) {
            this.top.unregisterHandle(token, h);
        } else {
            this.unregisterHandle(token, h);
        }
        this.notifyHandleFinished(h);
    }

    private synchronized void unregisterHandle(Either<String, Number> token, InternalHandle h) {
        if (token == null) {
            this.handles.values().remove(h);
        } else {
            this.handles.remove(token);
        }
    }

    private synchronized void registerHandle(Either<String, Number> token, InternalHandle h) {
        this.handles.put(token, h);
    }

    CompletableFuture<Either<String, Number>> acquireOrObtainToken(InternalHandle h) {
        Either<String, Number> t = this.acquireProgressToken();
        if (t != null) {
            return CompletableFuture.completedFuture(this.addHandle(t, h));
        }
        WorkDoneProgressCreateParams params = new WorkDoneProgressCreateParams(Either.forLeft((Object)UUID.randomUUID().toString()));
        CompletionStage tokenPromise = this.client.createProgress(params).thenApply(v -> params.getToken());
        return ((CompletableFuture)tokenPromise).thenApply(p -> {
            OperationContext operationContext = this;
            synchronized (operationContext) {
                return this.addHandle((Either<String, Number>)p, h);
            }
        });
    }

    public void disableCancels() {
        if (this.top != this) {
            this.disableCancels = true;
        }
    }

    public boolean isDisableCancels() {
        return this.disableCancels;
    }

    public static OperationContext getHandleContext(InternalHandle h) {
        if (!(h instanceof LspInternalHandle)) {
            return null;
        }
        return ((LspInternalHandle)h).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InternalHandle> getAllActiveHandles() {
        if (this.top != this) {
            return this.top.getAllActiveHandles();
        }
        OperationContext operationContext = this;
        synchronized (operationContext) {
            return new ArrayList<InternalHandle>(this.handles.values());
        }
    }

    public synchronized List<InternalHandle> getOperationHandles() {
        return new ArrayList<InternalHandle>(this.createdHandles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalHandleCreated(LspInternalHandle h) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            this.createdHandles.add(h);
        }
        this.dispatchProgressEvent(h, ProgressOperationListener::progressHandleCreated);
    }

    void notifyHandleFinished(LspInternalHandle h) {
        this.dispatchProgressEvent(h, ProgressOperationListener::progressHandleFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressOperationListener(String originClassFilter, ProgressOperationListener ol) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            this.operationListeners.add(new LR(originClassFilter, ol));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressOperationListener(ProgressOperationListener ol) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            Iterator<LR> it = this.operationListeners.iterator();
            while (it.hasNext()) {
                LR r = it.next();
                if (r.listener != ol) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressOperationListener(String originClassFilter, ProgressOperationListener ol) {
        OperationContext operationContext = this;
        synchronized (operationContext) {
            for (LR r : this.operationListeners) {
                if (!Objects.equals(r.regexp, originClassFilter) || r.listener != ol) continue;
                this.operationListeners.remove(r);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent(LspInternalHandle h, BiConsumer<ProgressOperationListener, ProgressOperationEvent> m) {
        LinkedHashSet<ProgressOperationListener> ll = new LinkedHashSet<ProgressOperationListener>();
        OperationContext operationContext = this;
        synchronized (operationContext) {
            for (StackTraceElement ste : h.getCreatorTrace()) {
                String cn = ste.getClassName();
                for (LR reg : this.operationListeners) {
                    if (!reg.test(cn)) continue;
                    ll.add(reg.listener);
                }
                for (LR reg : this.operationListeners) {
                    if (reg.regexp != null) continue;
                    ll.add(reg.listener);
                }
            }
        }
        if (ll.isEmpty()) {
            return;
        }
        ProgressOperationEvent ev = new ProgressOperationEvent(h, this);
        for (ProgressOperationListener l : ll) {
            m.accept(l, ev);
        }
    }

    private static class LR
    implements Predicate<String> {
        private final String regexp;
        private final ProgressOperationListener listener;
        private final Pattern compiled;

        public LR(String regexp, ProgressOperationListener listener) {
            this.compiled = regexp == null ? null : Pattern.compile(regexp);
            this.regexp = regexp;
            this.listener = listener;
        }

        @Override
        public boolean test(String t) {
            if (this.compiled == null) {
                return false;
            }
            return this.compiled.matcher(t).matches();
        }
    }
}

