/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.spi.project.ParentProjectProvider;
import org.netbeans.spi.project.RootProjectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ParentRootProviderImpl
implements ParentProjectProvider,
RootProjectProvider {
    final Project project;

    public ParentRootProviderImpl(Project project) {
        this.project = project;
    }

    public Project getPartentProject() {
        int lastcol;
        Project ret = null;
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        if (gbp != null && !gbp.isRoot() && (lastcol = gbp.getPath().lastIndexOf(58)) > 0) {
            String parentPath = gbp.getPath().substring(0, lastcol);
            Project root = this.getRootProject();
            GradleBaseProject rbp = GradleBaseProject.get(root);
            File parentDir = rbp.getSubProjects().get(parentPath);
            if (parentDir != null) {
                FileObject fo = FileUtil.toFileObject((File)parentDir);
                try {
                    ret = ProjectManager.getDefault().findProject(fo);
                }
                catch (IOException | IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        return ret;
    }

    public Project getRootProject() {
        Project ret = this.project;
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        if (gbp != null) {
            if (gbp.isRoot()) {
                ret = this.project;
            } else {
                FileObject fo = FileUtil.toFileObject((File)gbp.getRootDir());
                try {
                    ret = ProjectManager.getDefault().findProject(fo);
                }
                catch (IOException | IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        return ret;
    }
}

