/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hyperlink;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.hyperlink.Bundle;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautConfigHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        int[] span = new int[2];
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, span, null);
        return (int[])(property != null ? span : null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> {
            ClasspathInfo cpInfo;
            ElementHandle handle;
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (!(property == null || sources.isEmpty() || (handle = MicronautConfigHyperlinkProvider.getElementHandle(cpInfo = ClasspathInfo.create((Document)doc), ((ConfigurationMetadataSource)sources.get(0)).getType(), property.getName(), cancel)) != null && ElementOpen.open((ClasspathInfo)cpInfo, (ElementHandle)handle))) {
                Toolkit.getDefaultToolkit().beep();
            }
        }, (String)Bundle.LBL_GoToDeclaration(), (AtomicBoolean)cancel, (boolean)false);
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, null);
        if (property != null) {
            StringBuilder sb = new StringBuilder("<html><body>");
            sb.append("<b>").append(property.getId().replace(".", ".&#x200B;")).append("</b>");
            String propertyType = property.getType();
            if (propertyType != null) {
                sb.append("<pre>").append(propertyType).append("</pre>");
            }
            return sb.toString();
        }
        return null;
    }

    private static ElementHandle getElementHandle(ClasspathInfo cpInfo, String typeName, String propertyName, AtomicBoolean cancel) {
        ElementHandle[] handle = new ElementHandle[1];
        if (cpInfo != null) {
            try {
                JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]).runUserActionTask(controller -> {
                    if (cancel != null && cancel.get()) {
                        return;
                    }
                    handle[0] = ElementHandle.createTypeElementHandle((ElementKind)ElementKind.CLASS, (String)typeName);
                    TypeElement te = (TypeElement)handle[0].resolve((CompilationInfo)controller);
                    if (te != null) {
                        String name = "set" + propertyName.replaceAll("-", "");
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(te.getEnclosedElements())) {
                            if (!name.equalsIgnoreCase(executableElement.getSimpleName().toString())) continue;
                            handle[0] = ElementHandle.create((Element)executableElement);
                            break;
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return handle[0];
    }

    public static class LocationProvider
    implements HyperlinkLocationProvider {
        public CompletableFuture<HyperlinkLocation> getHyperlinkLocation(Document doc, int offset) {
            String typeName;
            ClasspathInfo cpInfo;
            ElementHandle handle;
            AtomicBoolean cancel = new AtomicBoolean();
            ArrayList<ConfigurationMetadataSource> sources = new ArrayList<ConfigurationMetadataSource>();
            ConfigurationMetadataProperty property = MicronautConfigUtilities.resolveProperty(doc, offset, null, sources);
            if (property != null && !sources.isEmpty() && (handle = MicronautConfigHyperlinkProvider.getElementHandle(cpInfo = ClasspathInfo.create((Document)doc), typeName = ((ConfigurationMetadataSource)sources.get(0)).getType(), property.getName(), cancel)) != null) {
                CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)cpInfo, (ElementHandle)handle, (String)(typeName.replace('.', '/') + ".class"));
                return future.thenApply(location -> location != null ? HyperlinkLocationProvider.createHyperlinkLocation((FileObject)location.getFileObject(), (int)location.getStartOffset(), (int)location.getEndOffset()) : null);
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

