/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbProcessConsole;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationEvent;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationListener;
import org.netbeans.modules.java.lsp.server.progress.TestProgressHandler;
import org.netbeans.modules.java.nativeimage.debugger.api.NIDebugRunner;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class NbLaunchDelegate {
    private final RequestProcessor requestProcessor = new RequestProcessor(NbLaunchDelegate.class);

    public abstract void preLaunch(Map<String, Object> var1, DebugAdapterContext var2);

    public abstract void postLaunch(Map<String, Object> var1, DebugAdapterContext var2);

    protected void notifyFinished(DebugAdapterContext ctx, boolean success) {
    }

    public final CompletableFuture<Void> nbLaunch(FileObject toRun, File nativeImageFile, String method, Map<String, Object> launchArguments, final DebugAdapterContext context, boolean debug, boolean testRun, Consumer<NbProcessConsole.ConsoleMessage> consoleMessages) {
        final CompletableFuture<Void> launchFuture = new CompletableFuture<Void>();
        final NbProcessConsole ioContext = new NbProcessConsole(consoleMessages);
        SingleMethod singleMethod = method != null ? new SingleMethod(toRun, method) : null;
        ActionProgress progress = new ActionProgress(){
            private final AtomicInteger count = new AtomicInteger(0);
            private final AtomicBoolean finalSuccess = new AtomicBoolean(true);

            protected void started() {
                this.count.incrementAndGet();
            }

            public void finished(boolean success) {
                if (this.count.decrementAndGet() <= 0) {
                    ioContext.stop();
                    NbLaunchDelegate.this.notifyFinished(context, success && this.finalSuccess.get());
                } else if (!success) {
                    this.finalSuccess.set(success);
                }
            }
        };
        if (toRun != null) {
            CompletableFuture<Pair<ActionProvider, String>> commandFuture = NbLaunchDelegate.findTargetWithPossibleRebuild(toRun, singleMethod, debug, testRun, ioContext);
            ((CompletableFuture)commandFuture.thenAccept(providerAndCommand -> {
                if (debug) {
                    DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)new DebuggerManagerAdapter(){

                        public void sessionAdded(final Session session) {
                            final JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
                            if (debugger != null) {
                                DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this);
                                Map properties = (Map)session.lookupFirst(null, Map.class);
                                NbSourceProvider sourceProvider = context.getSourceProvider();
                                sourceProvider.setSourcePath(properties != null ? properties.getOrDefault("sourcepath", ClassPath.EMPTY) : ClassPath.EMPTY);
                                debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent evt) {
                                        int newState = (Integer)evt.getNewValue();
                                        if (newState == 2) {
                                            debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
                                            NbDebugSession debugSession = new NbDebugSession(session);
                                            context.setDebugSession(debugSession);
                                            launchFuture.complete(null);
                                            context.getConfigurationSemaphore().waitForConfigurationDone();
                                        }
                                    }
                                });
                            }
                        }
                    });
                } else {
                    launchFuture.complete(null);
                }
                List<String> args = this.argsToStringList(launchArguments.get("args"));
                List<String> vmArgs = this.argsToStringList(launchArguments.get("vmArgs"));
                ExplicitProcessParameters params = ExplicitProcessParameters.empty();
                if (!args.isEmpty() || !vmArgs.isEmpty()) {
                    ExplicitProcessParameters.Builder bld = ExplicitProcessParameters.builder();
                    bld.launcherArgs(vmArgs);
                    bld.args(args);
                    bld.replaceArgs(false);
                    params = bld.build();
                }
                OperationContext ctx = OperationContext.find(Lookup.getDefault());
                ctx.addProgressOperationListener(null, new ProgressOperationListener(){

                    @Override
                    public void progressHandleCreated(ProgressOperationEvent e) {
                        context.setProcessExecutorHandle(e.getProgressHandle());
                    }
                });
                TestProgressHandler testProgressHandler = ctx.getClient().getNbCodeCapabilities().hasTestResultsSupport() ? new TestProgressHandler(ctx.getClient(), context.getClient(), Utils.toUri(toRun)) : null;
                ProxyLookup launchCtx = new ProxyLookup(new Lookup[]{testProgressHandler != null ? Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress, testProgressHandler}) : Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress}), Lookup.getDefault()});
                Lookup lookup = singleMethod != null ? Lookups.fixed((Object[])new Object[]{toRun, singleMethod, params, ioContext, progress}) : Lookups.fixed((Object[])new Object[]{toRun, ioContext, params, progress});
                Lookups.executeWith((Lookup)launchCtx, () -> ((ActionProvider)providerAndCommand.first()).invokeAction((String)providerAndCommand.second(), lookup));
            })).exceptionally(t -> {
                launchFuture.completeExceptionally((Throwable)t);
                return null;
            });
        } else {
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().showProgress(true).showSuspended(true).frontWindowOnError(true).controllable(true);
            ProxyLookup launchCtx = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{ioContext, progress}), Lookup.getDefault()});
            List<String> args = this.argsToStringList(launchArguments.get("args"));
            if (debug) {
                this.requestProcessor.post(() -> NbLaunchDelegate.lambda$nbLaunch$4((Lookup)launchCtx, launchArguments, nativeImageFile, args, context, executionDescriptor, launchFuture));
            } else {
                Lookups.executeWith((Lookup)launchCtx, () -> NbLaunchDelegate.execNative(nativeImageFile, args, context, executionDescriptor, launchFuture));
            }
        }
        return launchFuture;
    }

    private static void execNative(File nativeImageFile, List<String> args, DebugAdapterContext context, ExecutionDescriptor executionDescriptor, CompletableFuture<Void> launchFuture) {
        ExecutionService.newService(() -> {
            launchFuture.complete(null);
            List<String> command = args.isEmpty() ? Collections.singletonList(nativeImageFile.getAbsolutePath()) : NbLaunchDelegate.join(nativeImageFile.getAbsolutePath(), args);
            try {
                return new ProcessBuilder(command).start();
            }
            catch (IOException ex) {
                ErrorUtilities.completeExceptionally(launchFuture, "Failed to run debuggee native image: " + ex.getLocalizedMessage(), ResponseErrorCode.serverErrorStart);
                throw ex;
            }
        }, (ExecutionDescriptor)executionDescriptor, (String)("Run - " + nativeImageFile.getName())).run();
    }

    private static List<String> join(String first, List<String> next) {
        ArrayList<String> joined = new ArrayList<String>(next.size() + 1);
        joined.add(first);
        joined.addAll(next);
        return joined;
    }

    private static void startNativeDebug(File nativeImageFile, List<String> args, String miDebugger, DebugAdapterContext context, ExecutionDescriptor executionDescriptor, CompletableFuture<Void> launchFuture) {
        AtomicReference debugSessionRef = new AtomicReference();
        Runnable start = () -> {
            NIDebugger niDebugger;
            try {
                niDebugger = NIDebugRunner.start((File)nativeImageFile, (List)args, (String)miDebugger, null, null, (ExecutionDescriptor)executionDescriptor, engine -> {
                    Session session = (Session)engine.lookupFirst(null, Session.class);
                    NbDebugSession debugSession = new NbDebugSession(session);
                    debugSessionRef.set(debugSession);
                    context.setDebugSession(debugSession);
                    launchFuture.complete(null);
                    context.getConfigurationSemaphore().waitForConfigurationDone();
                });
            }
            catch (IllegalStateException ex) {
                ErrorUtilities.completeExceptionally(launchFuture, "Failed to launch debuggee native image. " + ex.getLocalizedMessage(), ResponseErrorCode.serverErrorStart);
                return;
            }
            NbDebugSession debugSession = (NbDebugSession)debugSessionRef.get();
            debugSession.setNIDebugger(niDebugger);
        };
        Lookups.executeWith((Lookup)context.getLspSession().getLookup(), (Runnable)start);
    }

    @NonNull
    private List<String> argsToStringList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            for (Object item : (List)o) {
                if (o instanceof String) continue;
                throw new IllegalArgumentException("Only string parameters expected");
            }
            return (List)o;
        }
        if (o instanceof String) {
            ArrayList res = new ArrayList();
            return Arrays.asList(BaseUtilities.parseParameters((String)o.toString()));
        }
        throw new IllegalArgumentException("Expected String or String list");
    }

    private static CompletableFuture<Pair<ActionProvider, String>> findTargetWithPossibleRebuild(final FileObject toRun, final SingleMethod singleMethod, final boolean debug, final boolean testRun, NbProcessConsole ioContext) throws IllegalArgumentException {
        Pair<ActionProvider, String> providerAndCommand = NbLaunchDelegate.findTarget(toRun, singleMethod, debug, testRun);
        if (providerAndCommand != null) {
            return CompletableFuture.completedFuture(providerAndCommand);
        }
        final CompletableFuture<Pair<ActionProvider, String>> afterBuild = new CompletableFuture<Pair<ActionProvider, String>>();
        class CheckBuildProgress
        extends ActionProgress {
            boolean running;

            CheckBuildProgress() {
            }

            protected void started() {
                this.running = true;
            }

            public void finished(boolean success) {
                Pair<ActionProvider, String> providerAndCommand;
                if (success && (providerAndCommand = NbLaunchDelegate.findTarget(toRun, singleMethod, debug, testRun)) != null) {
                    afterBuild.complete(providerAndCommand);
                    return;
                }
                afterBuild.completeExceptionally((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.MethodNotFound, "Cannot find " + (debug ? "debug" : "run") + " action!", null)));
            }
        }
        CheckBuildProgress progress = new CheckBuildProgress();
        ProxyLookup launchCtx = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress}), Lookup.getDefault()});
        Collection<ActionProvider> providers = NbLaunchDelegate.findActionProviders(toRun);
        for (ActionProvider ap : providers) {
            if (!ap.isActionEnabled("build", (Lookup)launchCtx)) continue;
            Lookups.executeWith((Lookup)launchCtx, () -> NbLaunchDelegate.lambda$findTargetWithPossibleRebuild$9(ap, (Lookup)launchCtx));
            break;
        }
        if (!progress.running) {
            progress.finished(true);
        }
        return afterBuild;
    }

    @CheckForNull
    protected static Pair<ActionProvider, String> findTarget(FileObject toRun, SingleMethod singleMethod, boolean debug, boolean testRun) {
        String[] actions;
        FileObject fileRoot;
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/source");
        FileObject fileObject = fileRoot = sourceCP != null ? sourceCP.findOwnerRoot(toRun) : null;
        boolean mainSource = fileRoot != null ? UnitTestForSourceQuery.findUnitTests((FileObject)fileRoot).length > 0 : !testRun;
        ActionProvider provider = null;
        String command = null;
        Collection<ActionProvider> actionProviders = NbLaunchDelegate.findActionProviders(toRun);
        Lookup testLookup = Lookups.singleton((Object)toRun);
        if (!mainSource && singleMethod != null) {
            String[] stringArray;
            if (debug) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "debug.single.method";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "run.single.method";
            }
            actions = stringArray;
        } else {
            String[] stringArray;
            if (debug) {
                if (mainSource) {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = "debug.single";
                } else {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "debug.test.single";
                    stringArray = stringArray5;
                    stringArray5[1] = "debug.single";
                }
            } else if (mainSource) {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "run.single";
            } else {
                String[] stringArray7 = new String[2];
                stringArray7[0] = "test.single";
                stringArray = stringArray7;
                stringArray7[1] = "run.single";
            }
            actions = stringArray;
        }
        for (String commandCandidate : actions) {
            provider = NbLaunchDelegate.findActionProvider(commandCandidate, actionProviders, testLookup);
            if (provider == null) continue;
            command = commandCandidate;
            break;
        }
        if (provider == null) {
            Collection<ActionProvider> nestedAPs;
            command = debug ? (mainSource ? "debug" : "debug") : (mainSource ? "run" : "test");
            provider = NbLaunchDelegate.findActionProvider(command, actionProviders, testLookup);
            if (!mainSource && !(nestedAPs = NbLaunchDelegate.findNestedActionProviders(toRun, command, testLookup)).isEmpty()) {
                final String finalCommand = command;
                final ActionProvider finalProvider = provider;
                provider = new ActionProvider(){

                    public String[] getSupportedActions() {
                        return new String[]{finalCommand};
                    }

                    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
                        return finalCommand.equals(command);
                    }

                    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
                        if (finalCommand.equals(command)) {
                            if (finalProvider != null) {
                                finalProvider.invokeAction(command, context);
                            }
                            for (ActionProvider nestedAP : nestedAPs) {
                                nestedAP.invokeAction(command, context);
                            }
                        }
                    }
                };
            }
        }
        if (provider == null) {
            return null;
        }
        return Pair.of(provider, command);
    }

    private static Collection<ActionProvider> findActionProviders(FileObject toRun) {
        ArrayList<ActionProvider> actionProviders = new ArrayList<ActionProvider>();
        Project prj = FileOwnerQuery.getOwner((FileObject)toRun);
        if (prj != null) {
            ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
            actionProviders.add(ap);
        }
        actionProviders.addAll(Lookup.getDefault().lookupAll(ActionProvider.class));
        return actionProviders;
    }

    private static boolean supportsAction(ActionProvider ap, String action) {
        for (String supportedAction : ap.getSupportedActions()) {
            if (!supportedAction.equals(action)) continue;
            return true;
        }
        return false;
    }

    private static ActionProvider findActionProvider(String action, Collection<ActionProvider> actionProviders, Lookup enabledOnLookup) {
        for (ActionProvider ap : actionProviders) {
            if (!NbLaunchDelegate.supportsAction(ap, action) || !ap.isActionEnabled(action, enabledOnLookup)) continue;
            return ap;
        }
        return null;
    }

    private static Collection<ActionProvider> findNestedActionProviders(FileObject toRun, String action, Lookup enabledOnLookup) {
        ArrayList<ActionProvider> actionProviders = new ArrayList<ActionProvider>();
        Project prj = FileOwnerQuery.getOwner((FileObject)toRun);
        if (prj != null) {
            for (Project containedPrj : ProjectUtils.getContainedProjects((Project)prj, (boolean)true)) {
                ActionProvider ap = (ActionProvider)containedPrj.getLookup().lookup(ActionProvider.class);
                if (!NbLaunchDelegate.supportsAction(ap, action) || !ap.isActionEnabled(action, enabledOnLookup)) continue;
                actionProviders.add(ap);
            }
        }
        return actionProviders;
    }

    private static /* synthetic */ void lambda$findTargetWithPossibleRebuild$9(ActionProvider ap, Lookup launchCtx) {
        ap.invokeAction("build", launchCtx);
    }

    private static /* synthetic */ void lambda$nbLaunch$4(Lookup launchCtx, Map launchArguments, File nativeImageFile, List args, DebugAdapterContext context, ExecutionDescriptor executionDescriptor, CompletableFuture launchFuture) {
        Lookups.executeWith((Lookup)launchCtx, () -> {
            String miDebugger = (String)launchArguments.get("miDebugger");
            NbLaunchDelegate.startNativeDebug(nativeImageFile, args, miDebugger, context, executionDescriptor, launchFuture);
        });
    }
}

