/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.lsp.HyperlinkLocationAccessor;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;

public final class HyperlinkLocation {
    private final FileObject fileObject;
    private final int startOffset;
    private final int endOffset;

    private HyperlinkLocation(@NonNull FileObject fileObject, int startOffset, int endOffset) {
        this.fileObject = fileObject;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @NonNull
    public FileObject getFileObject() {
        return this.fileObject;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.fileObject);
        hash = 29 * hash + this.startOffset;
        hash = 29 * hash + this.endOffset;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HyperlinkLocation other = (HyperlinkLocation)obj;
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        return Objects.equals(this.fileObject, other.fileObject);
    }

    public String toString() {
        return "HyperlinkLocation{fileObject=" + this.fileObject + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
    }

    @NonNull
    public static CompletableFuture<List<HyperlinkLocation>> resolve(@NonNull Document doc, int offset) {
        MimePath mimePath = MimePath.parse((String)DocumentUtilities.getMimeType((Document)doc));
        CompletableFuture[] futures = (CompletableFuture[])MimeLookup.getLookup((MimePath)mimePath).lookupAll(HyperlinkLocationProvider.class).stream().map(provider -> provider.getHyperlinkLocation(doc, offset)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(value -> {
            ArrayList<HyperlinkLocation> locations = new ArrayList<HyperlinkLocation>(futures.length);
            for (CompletableFuture future : futures) {
                HyperlinkLocation location = future.getNow(null);
                if (location == null) continue;
                locations.add(location);
            }
            return locations;
        });
    }

    static {
        HyperlinkLocationAccessor.setDefault(new HyperlinkLocationAccessor(){

            @Override
            public HyperlinkLocation createHyperlinkLocation(FileObject fileObject, int startOffset, int endOffset) {
                return new HyperlinkLocation(fileObject, startOffset, endOffset);
            }
        });
    }
}

