/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDecorator;
import org.netbeans.modules.xml.wizard.impl.FolderNode;
import org.netbeans.modules.xml.wizard.impl.WaitNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.xml.sax.InputSource;

public class NamespaceChildren
extends Children.Keys {
    private Map nsFilesMap;
    private FileObject[] rootFolders;
    private ExternalReferenceDecorator decorator;

    public NamespaceChildren(FileObject[] roots, ExternalReferenceDecorator decorator) {
        this.rootFolders = roots;
        this.decorator = decorator;
        this.nsFilesMap = new TreeMap();
    }

    protected Node[] createNodes(Object key) {
        List fobjs;
        if (key == WaitNode.WAIT_KEY) {
            return WaitNode.createNode();
        }
        if (key instanceof String && (fobjs = (List)this.nsFilesMap.get(key)) != null && !fobjs.isEmpty()) {
            ArrayList<Node> filterNodes = new ArrayList<Node>(fobjs.size());
            boolean i = false;
            for (int j = 0; j < fobjs.size(); ++j) {
                try {
                    filterNodes.add(this.createSchemaNode(fobjs.get(j)));
                    continue;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            Children.Array children = new Children.Array();
            children.add(filterNodes.toArray(new Node[filterNodes.size()]));
            NamespaceNode node = new NamespaceNode((Children)children, (String)key);
            return new Node[]{node};
        }
        return new Node[0];
    }

    private Node createSchemaNode(Object o) throws DataObjectNotFoundException {
        FileObject fobj;
        boolean catalog = false;
        if (o instanceof FileObject) {
            fobj = (FileObject)o;
        } else if (o instanceof InputSource) {
            InputSource src = (InputSource)o;
            fobj = Util.toFileObject(src);
            catalog = true;
        } else {
            return null;
        }
        Node node = DataObject.find((FileObject)fobj).getNodeDelegate();
        return this.decorator.createExternalReferenceNode(node, catalog);
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(WaitNode.getKeys());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < NamespaceChildren.this.rootFolders.length; ++i) {
                    FileObject root = NamespaceChildren.this.rootFolders[i];
                    Map map = Util.getFiles2NSMappingInProj(FileUtil.toFile((FileObject)root), Util.getDocumentType());
                    Map<InputSource, String> nsMap = Util.getCatalogSchemaNSMappings();
                    map.putAll(nsMap);
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        String ns = (String)entry.getValue();
                        ArrayList fobjs = (ArrayList)NamespaceChildren.this.nsFilesMap.get(ns);
                        if (fobjs == null) {
                            fobjs = new ArrayList();
                        }
                        fobjs.add(entry.getKey());
                        NamespaceChildren.this.nsFilesMap.put(ns, fobjs);
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NamespaceChildren.this.setKeys(NamespaceChildren.this.nsFilesMap.keySet());
                    }
                });
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private static class NamespaceNode
    extends FolderNode {
        public static final String NO_NAME_SPACE = "NO_NAME_SPACE";

        NamespaceNode(Children children, String myNamespace) {
            super(children);
            this.setName(myNamespace);
            if (NO_NAME_SPACE.equals(myNamespace)) {
                this.setDisplayName("NoTargetNameSpace");
            }
        }

        public String getHtmlDisplayName() {
            String name = this.getDisplayName();
            return name;
        }

        public String getNamespace() {
            return this.getName();
        }
    }
}

