/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.file;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class BuildXml {
    private static final Logger LOGGER = Logger.getLogger(BuildXml.class.getName());
    public static final String FILE_NAME = "build.xml";
    private final FileObject directory;
    private final FileChangeListener directoryListener = new DirectoryListener();
    private final FileChangeListener buildXmlListener = new BuildXmlListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private File buildXml;

    public BuildXml(FileObject directory) {
        assert (directory != null);
        assert (directory.isFolder()) : "Must be folder: " + directory;
        this.directory = directory;
        FileUtil.addFileChangeListener((FileChangeListener)this.directoryListener, (File)FileUtil.toFile((FileObject)directory));
    }

    public boolean exists() {
        return this.getBuildXml().isFile();
    }

    public File getFile() {
        return this.getBuildXml();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private synchronized File getBuildXml() {
        if (this.buildXml == null) {
            this.buildXml = new File(FileUtil.toFile((FileObject)this.directory), FILE_NAME);
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this.buildXmlListener, (File)this.buildXml);
                LOGGER.log(Level.FINE, "Started listening to {0}", this.buildXml);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.FINE, "Already listening to {0}", this.buildXml);
            }
        }
        return this.buildXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(boolean newFile) {
        if (newFile) {
            BuildXml buildXml = this;
            synchronized (buildXml) {
                if (this.buildXml != null) {
                    try {
                        FileUtil.removeFileChangeListener((FileChangeListener)this.buildXmlListener, (File)this.buildXml);
                        LOGGER.log(Level.FINE, "Stopped listening to {0}", this.buildXml);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.FINE, "Not listening yet to {0}", this.buildXml);
                    }
                    this.buildXml = null;
                }
            }
        }
        this.changeSupport.fireChange();
    }

    private final class BuildXmlListener
    extends FileChangeAdapter {
        private BuildXmlListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            BuildXml.this.reset(true);
        }

        public void fileChanged(FileEvent fe) {
            BuildXml.this.reset(false);
        }

        public void fileDeleted(FileEvent fe) {
            BuildXml.this.reset(true);
        }

        public void fileRenamed(FileRenameEvent fe) {
            BuildXml.this.reset(true);
        }
    }

    private final class DirectoryListener
    extends FileChangeAdapter {
        private DirectoryListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            BuildXml.this.reset(true);
        }
    }
}

