/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.actions.ActionMappingPropertyReader;
import org.netbeans.modules.gradle.actions.DefaultActionMapping;
import org.netbeans.modules.gradle.actions.MappingContainer;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class ProjectActionMappingProviderImpl
implements ProjectActionMappingProvider {
    private static final Logger LOG = Logger.getLogger(ProjectActionMappingProviderImpl.class.getName());
    private static final ActionMapping DEFAULT_RUN = new DefaultActionMapping("run", "run");
    private static final ActionMapping DEFAULT_TEST = new DefaultActionMapping("test", "--rerun-tasks test");
    private static final ActionMapping DEFAULT_DEBUG = new DefaultActionMapping("debug", "debug");
    private static final ActionMapping DEFAULT_DEBUG2 = new DefaultActionMapping("debug", "run --debug-jvm");
    final Project project;
    final PropertyChangeListener pcl;
    final File projectMappingFile;
    Set<String> plugins;
    final Map<String, ActionMapping> projectMappings = new HashMap<String, ActionMapping>();
    final Set<String> noMappingCache = new HashSet<String>();
    final Map<String, ActionMapping> mappingCache = new HashMap<String, ActionMapping>();

    public ProjectActionMappingProviderImpl(Project project) {
        this.project = project;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    ProjectActionMappingProviderImpl.this.cleanCache();
                    ProjectActionMappingProviderImpl.this.loadProjectCustomMappings();
                }
            }
        };
        NbGradleProject.addPropertyChangeListener(project, WeakListeners.propertyChange((PropertyChangeListener)this.pcl, null));
        File projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        this.projectMappingFile = new File(projectDir, "gradle.properties");
        this.loadProjectCustomMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMapping findMapping(String action) {
        ActionMapping result = this.projectMappings.get(action);
        if (result != null) {
            return result;
        }
        result = this.mappingCache.get(action);
        if (result != null || this.noMappingCache.contains(action)) {
            return result;
        }
        result = MappingContainer.getDefault().findMapping(action, this.getPlugins());
        if (result == null) {
            result = this.heuristicMappings(action);
        }
        ProjectActionMappingProviderImpl projectActionMappingProviderImpl = this;
        synchronized (projectActionMappingProviderImpl) {
            if (result != null) {
                this.mappingCache.put(action, result);
            } else {
                this.noMappingCache.add(action);
            }
        }
        return result;
    }

    private ActionMapping heuristicMappings(String action) {
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        ActionMapping ret = null;
        if (gbp != null) {
            switch (action) {
                case "run": {
                    if (gbp.getTaskByName("run") == null) break;
                    ret = DEFAULT_RUN;
                    break;
                }
                case "test": {
                    if (gbp.getTaskByName("test") == null) break;
                    ret = DEFAULT_TEST;
                    break;
                }
                case "debug": {
                    if (gbp.getTaskByName("debug") != null) {
                        ret = DEFAULT_DEBUG;
                        break;
                    }
                    if (gbp.getTaskByName("run") == null) break;
                    ret = DEFAULT_DEBUG2;
                }
            }
        }
        return ret;
    }

    private synchronized Set<String> getPlugins() {
        if (this.plugins == null) {
            GradleBaseProject gbp = GradleBaseProject.get(this.project);
            this.plugins = gbp.getPlugins();
        }
        return this.plugins;
    }

    private synchronized void cleanCache() {
        this.plugins = null;
        this.noMappingCache.clear();
        this.mappingCache.clear();
    }

    private synchronized void loadProjectCustomMappings() {
        this.projectMappings.clear();
        if (this.projectMappingFile.canRead()) {
            try (FileInputStream is = new FileInputStream(this.projectMappingFile);){
                Properties props = new Properties();
                props.load(is);
                Set<ActionMapping> customMappings = ActionMappingPropertyReader.loadMappings(props);
                for (ActionMapping mapping : customMappings) {
                    this.projectMappings.put(mapping.getName(), mapping);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<String> customizedActions() {
        return this.projectMappings.keySet();
    }
}

