/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.gradle.tooling.model.Model;
import org.netbeans.modules.gradle.loaders.ModelCache;
import org.openide.util.Pair;

public class ModelCacheManager {
    static Map<File, List<Pair<Class, ModelCache>>> CACHES = new ConcurrentHashMap<File, List<Pair<Class, ModelCache>>>();

    public static <T extends Model> ModelCache<T> getModelCache(File rootDir, Class<T> clazz, Supplier<ModelCache<T>> supplier) {
        List<Pair<Class, ModelCache>> caches = CACHES.get(rootDir);
        if (caches == null) {
            caches = new LinkedList<Pair<Class, ModelCache>>();
            CACHES.put(rootDir, caches);
        }
        ModelCache c = null;
        for (Pair<Class, ModelCache> cache : caches) {
            if (!((Class)cache.first()).isAssignableFrom(clazz)) continue;
            c = (ModelCache)cache.second();
        }
        if (c == null) {
            c = supplier.get();
            caches.add((Pair<Class, ModelCache>)Pair.of(clazz, c));
        }
        return c;
    }
}

