/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.Arrays;
import junit.framework.TestCase;
import org.jruby.util.ByteList;
import org.jvyamlb.YAML;

public abstract class YAMLTestCase
extends TestCase {
    public YAMLTestCase(String name) {
        super(name);
    }

    protected ByteList s(String st) throws Exception {
        return new ByteList(st.getBytes("UTF-8"));
    }

    public void assertLoad(Object expected, String str) throws Exception {
        YAMLTestCase.assertEquals((Object)expected, (Object)YAML.load(this.s(str)));
    }

    public Object load(String str) throws Exception {
        return YAML.load(this.s(str));
    }

    public void assertLoad(Object expected, ByteList str) throws Exception {
        YAMLTestCase.assertEquals((Object)expected, (Object)YAML.load(str));
    }

    public void assertLoad10(Object expected, String str) throws Exception {
        YAMLTestCase.assertEquals((Object)expected, (Object)YAML.load(this.s(str), YAML.config().version("1.0")));
    }

    public void assertLoad10(byte[] expected, String str) throws Exception {
        this.assertArrayEquals(expected, (byte[])YAML.load(this.s(str), YAML.config().version("1.0")));
    }

    private void assertArrayEquals(byte[] expected, byte[] given) {
        YAMLTestCase.assertTrue((boolean)Arrays.equals(expected, given));
    }

    public void assertRoundtrip(String value) throws Exception {
        YAMLTestCase.assertEquals((Object)this.s(value), (Object)YAML.load(YAML.dump(this.s(value))));
    }

    public void assertRoundtrip(ByteList value) throws Exception {
        try {
            YAMLTestCase.assertEquals((Object)value, (Object)YAML.load(YAML.dump(value)));
        }
        catch (Exception e) {
            System.err.println("bytelist[" + value.begin + ", realSize: " + value.realSize + "]");
            for (int i = 0; i < value.realSize; ++i) {
                System.err.println("[" + i + "]= " + value.bytes[value.begin + i]);
            }
            System.err.println("for: \"" + value + "\" -- of len: " + value.realSize);
            System.err.println("out: \"" + YAML.dump(value) + "\"");
            throw e;
        }
    }
}

