/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.cpu.CPUJavaNameRenderer;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class CPUTreeTableView
extends CPUView {
    private CPUTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<Integer, ClientUtils.SourceCodeSelection> idMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean reverse;
    private boolean sampled = true;
    private boolean twoTimeStamps;
    private boolean hitsVisible = false;
    private boolean invocationsVisible = true;
    private boolean filterTopMethods = true;
    private boolean filterCallerMethods = false;
    private boolean searchTopMethods = true;
    private boolean searchCallerMethods = false;
    private HideableBarRenderer[] renderers;

    public CPUTreeTableView(Set<ClientUtils.SourceCodeSelection> selection, boolean reverse) {
        this.selection = selection;
        this.reverse = reverse;
        this.initUI();
    }

    void setData(CPUResultsSnapshot newData, Map<Integer, ClientUtils.SourceCodeSelection> newIdMap, int aggregation, Collection<Integer> selectedThreads, boolean mergeThreads, boolean _sampled, boolean _diff) {
        boolean structureChange = this.sampled != _sampled;
        this.sampled = _sampled;
        boolean _twoTimeStamps = this.twoTimeStamps;
        this.twoTimeStamps = newData == null ? !_twoTimeStamps : newData.isCollectingTwoTimeStamps();
        this.idMap = newIdMap;
        this.renderers[0].setDiffMode(_diff);
        this.renderers[1].setDiffMode(_diff);
        this.renderers[2].setDiffMode(_diff);
        if (this.treeTableModel != null) {
            this.treeTableModel.setRoot((TreeNode)(newData == null ? PrestimeCPUCCTNode.EMPTY : (!this.reverse ? newData.getRootNode(aggregation, selectedThreads, mergeThreads) : newData.getReverseRootNode(aggregation, selectedThreads, mergeThreads))));
        }
        if (structureChange) {
            int col = this.treeTable.convertColumnIndexToView(this.selection == null ? 3 : 4);
            String colN = this.treeTableModel.getColumnName(this.selection == null ? 3 : 4);
            if (this.sampled) {
                this.invocationsVisible = this.treeTable.isColumnVisible(col);
            } else {
                this.hitsVisible = this.treeTable.isColumnVisible(col);
            }
            this.treeTable.getColumnModel().getColumn(col).setHeaderValue(colN);
            this.treeTable.setColumnVisibility(col, this.sampled ? this.hitsVisible : this.invocationsVisible);
            this.setToolTips();
            this.repaint();
        }
        if (newData != null && this.twoTimeStamps != _twoTimeStamps) {
            int column = this.selection == null ? 2 : 3;
            boolean cpuColumnVisible = this.treeTable.isColumnVisible(column);
            if (this.twoTimeStamps && !cpuColumnVisible) {
                this.treeTable.setColumnVisibility(column, true);
            } else if (!this.twoTimeStamps && cpuColumnVisible) {
                this.treeTable.setColumnVisibility(column, false);
            }
        }
    }

    public void resetData() {
        this.setData(null, null, -1, null, false, this.sampled, false);
    }

    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        String name;
        String string = name = this.reverse ? EXPORT_REVERSE_CALLS : EXPORT_FORWARD_CALLS;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, name);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, name);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        int w;
        this.treeTableModel = new CPUTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        int offset = this.selection == null ? -1 : 0;
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + offset}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return CPUTreeTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                CPUTreeTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                CPUTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                CPUTreeTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.treeTable.providePopupMenu(true);
        this.installDefaultAction();
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + offset);
        this.treeTable.setFitWidthColumn(1 + offset);
        this.treeTable.setSortColumn(2 + offset);
        this.treeTable.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.treeTable.setColumnVisibility(4 + offset, false);
        this.renderers = new HideableBarRenderer[3];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer())){

            @Override
            public void setValue(Object value, int row) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(row, 0));
                super.setValue(value, row);
            }
        };
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer())){

            @Override
            public void setValue(Object value, int row) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(row, 1));
                super.setValue(value, row);
            }
        };
        this.renderers[2] = new HideableBarRenderer(new NumberRenderer()){

            @Override
            public void setValue(Object value, int row) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(row, 2));
                super.setValue(value, row);
            }
        };
        long refTime = 123456L;
        this.renderers[0].setMaxValue(refTime);
        this.renderers[1].setMaxValue(refTime);
        this.renderers[2].setMaxValue(refTime);
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object value, int row) {
                    TreePath path = CPUTreeTableView.this.treeTable.getPathForRow(row);
                    this.visible = CPUTreeTableView.isSelectable((PrestimeCPUCCTNode)path.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(value, row);
                    }
                }

                @Override
                public void paint(Graphics g) {
                    if (this.visible) {
                        super.paint(g);
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new CPUJavaNameRenderer(this.reverse ? "ProfilerIcons.NodeReverse" : "ProfilerIcons.NodeForward"));
        this.treeTable.setColumnRenderer(2 + offset, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + offset, this.renderers[1]);
        this.treeTable.setColumnRenderer(4 + offset, this.renderers[2]);
        if (this.selection != null) {
            w = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, w + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        this.sampled = !this.sampled;
        w = new JLabel((String)this.treeTable.getColumnName((int)(4 + offset))).getPreferredSize().width;
        this.sampled = !this.sampled;
        w = Math.max(w, new JLabel((String)this.treeTable.getColumnName((int)(4 + offset))).getPreferredSize().width);
        this.treeTable.setDefaultColumnWidth(4 + offset, Math.max(this.renderers[2].getNoBarWidth(), w + 15));
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    private void setToolTips() {
        String[] stringArray;
        if (this.selection == null) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray2[2] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[3] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray3[3] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[4] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
    }

    @Override
    protected RowFilter getExcludesFilter() {
        if (!this.reverse) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)entry.getIdentifier();
                    return node.isThreadNode() || node.isSelfTimeNode();
                }
            };
        }
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)entry.getIdentifier();
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return true;
                }
                if (node.isThreadNode() || node.isSelfTimeNode()) {
                    return true;
                }
                if (((PrestimeCPUCCTNode)parent).isThreadNode() || parent.getParent() == null) {
                    return !CPUTreeTableView.this.filterTopMethods;
                }
                return !CPUTreeTableView.this.filterCallerMethods;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        if (!this.reverse) {
            return super.getFilterOptions();
        }
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(CPUView.FILTER_CALLEES_SCOPE, CPUTreeTableView.this.filterTopMethods){
                    {
                        if (!CPUTreeTableView.this.filterCallerMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CPUTreeTableView.this.filterTopMethods = !CPUTreeTableView.this.filterTopMethods;
                        CPUTreeTableView.this.enableFilter();
                    }
                });
                popup.add(new JCheckBoxMenuItem(CPUView.FILTER_CALLERS_SCOPE, CPUTreeTableView.this.filterCallerMethods){
                    {
                        if (!CPUTreeTableView.this.filterTopMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CPUTreeTableView.this.filterCallerMethods = !CPUTreeTableView.this.filterCallerMethods;
                        CPUTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        pb.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        if (!this.reverse) {
            return super.getSearchHelper();
        }
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)tnode;
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (node.isThreadNode()) {
                    return 100;
                }
                if (node.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)parent).isThreadNode() || parent.getParent() == null) {
                    if (CPUTreeTableView.this.searchTopMethods) {
                        return CPUTreeTableView.this.searchCallerMethods ? 10 : 11;
                    }
                    return CPUTreeTableView.this.searchCallerMethods ? 100 : 101;
                }
                return CPUTreeTableView.this.searchCallerMethods ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        if (!this.reverse) {
            return super.getSearchOptions();
        }
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(CPUView.SEARCH_CALLEES_SCOPE, CPUTreeTableView.this.searchTopMethods){
                    {
                        if (!CPUTreeTableView.this.searchCallerMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CPUTreeTableView.this.searchTopMethods = !CPUTreeTableView.this.searchTopMethods;
                    }
                });
                popup.add(new JCheckBoxMenuItem(CPUView.SEARCH_CALLERS_SCOPE, CPUTreeTableView.this.searchCallerMethods){
                    {
                        if (!CPUTreeTableView.this.searchTopMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        CPUTreeTableView.this.searchCallerMethods = !CPUTreeTableView.this.searchCallerMethods;
                    }
                });
            }
        };
        pb.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    private long getMaxValue(int row, int val) {
        TreePath path = this.treeTable.getPathForRow(row);
        if (path == null) {
            return Long.MIN_VALUE;
        }
        if (path.getPathCount() < 2) {
            return 1L;
        }
        PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)path.getPathComponent(1);
        if (val == 0) {
            return Math.abs(node.getTotalTime0());
        }
        if (val == 1) {
            return Math.abs(node.getTotalTime1());
        }
        return Math.abs(node.getNCalls());
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)this.treeTable.getValueForRow(row);
        if (node == null) {
            return null;
        }
        if (node.isThreadNode() || node.isFiltered() || node.isSelfTimeNode()) {
            return null;
        }
        return this.idMap.get(node.getMethodId());
    }

    private static boolean isSelectable(PrestimeCPUCCTNode node) {
        if (node.isThreadNode() || node.isFiltered() || node.isSelfTimeNode()) {
            return false;
        }
        return !node.getMethodClassNameAndSig()[1].endsWith("[native]");
    }

    private class CPUTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        CPUTreeTableModel(TreeNode root) {
            super(root);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (CPUTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return CPUView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return CPUView.COLUMN_TOTALTIME;
            }
            if (columnIndex == 3) {
                return CPUView.COLUMN_TOTALTIME_CPU;
            }
            if (columnIndex == 4) {
                return CPUTreeTableView.this.sampled ? CPUView.COLUMN_HITS : CPUView.COLUMN_INVOCATIONS;
            }
            if (columnIndex == 0) {
                return CPUView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (CPUTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return JTree.class;
            }
            if (columnIndex == 4) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getColumnCount() {
            return CPUTreeTableView.this.selection == null ? 4 : 5;
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            PrestimeCPUCCTNode cpuNode = (PrestimeCPUCCTNode)node;
            if (CPUTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return cpuNode.getNodeName();
            }
            if (columnIndex == 2) {
                return cpuNode.getTotalTime0();
            }
            if (columnIndex == 3) {
                return CPUTreeTableView.this.twoTimeStamps ? cpuNode.getTotalTime1() : 0L;
            }
            if (columnIndex == 4) {
                return cpuNode.getNCalls();
            }
            if (columnIndex == 0) {
                if (CPUTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return CPUTreeTableView.this.selection.contains(CPUTreeTableView.this.idMap.get(cpuNode.getMethodId()));
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int columnIndex) {
            if (CPUTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                PrestimeCPUCCTNode cpuNode = (PrestimeCPUCCTNode)node;
                int methodId = cpuNode.getMethodId();
                if (Boolean.TRUE.equals(aValue)) {
                    CPUTreeTableView.this.selection.add(CPUTreeTableView.this.idMap.get(methodId));
                } else {
                    CPUTreeTableView.this.selection.remove(CPUTreeTableView.this.idMap.get(methodId));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            if (CPUTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex != 0) {
                return false;
            }
            return CPUTreeTableView.isSelectable((PrestimeCPUCCTNode)node);
        }
    }
}

