/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;

public class VMCache {
    private static final int MAX_ENCLOSING_TYPES = 100;
    private final JPDADebuggerImpl debugger;
    private final Map<String, ReferenceType> cachedClasses = new HashMap<String, ReferenceType>();
    private final Map<CEncl, ReferenceType> enclosingTypes = new LinkedHashMap<CEncl, ReferenceType>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CEncl, ReferenceType> eldest) {
            return this.size() > 100;
        }
    };

    public VMCache(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
        debugger.addPropertyChangeListener("classesFixed", event -> this.reset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Map<Object, ReferenceType> map = this.cachedClasses;
        synchronized (map) {
            this.cachedClasses.clear();
        }
        map = this.enclosingTypes;
        synchronized (map) {
            this.enclosingTypes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceType getClass(String name) {
        ReferenceType rt;
        Map<String, ReferenceType> map = this.cachedClasses;
        synchronized (map) {
            rt = this.cachedClasses.get(name);
            if (rt == null && (rt = this.loadClass(name)) != null) {
                this.cachedClasses.put(name, rt);
            }
        }
        return rt;
    }

    private ReferenceType loadClass(String name) {
        VirtualMachine vm = this.debugger.getVirtualMachine();
        if (vm == null) {
            return null;
        }
        List<ReferenceType> stringClasses = vm.classesByName(name);
        if (stringClasses.isEmpty()) {
            return null;
        }
        return stringClasses.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceType getEnclosingType(ReferenceType type, String name) {
        ReferenceType enclosingType;
        CEncl classEnclosing = new CEncl(type, name);
        Map<CEncl, ReferenceType> map = this.enclosingTypes;
        synchronized (map) {
            enclosingType = this.enclosingTypes.get(classEnclosing);
        }
        return enclosingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnclosingType(ReferenceType type, String name, ReferenceType enclosingType) {
        CEncl classEnclosing = new CEncl(type, name);
        Map<CEncl, ReferenceType> map = this.enclosingTypes;
        synchronized (map) {
            this.enclosingTypes.put(classEnclosing, enclosingType);
        }
    }

    private static class CEncl {
        final ReferenceType type;
        final String enclName;

        CEncl(ReferenceType type, String enclName) {
            this.type = type;
            this.enclName = enclName;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.enclName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CEncl other = (CEncl)obj;
            if (!Objects.equals(this.enclName, other.enclName)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }
}

