/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.calendar.CalendarUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class CalendarRenderer
extends org.primefaces.component.calendar.CalendarRenderer {
    protected void encodeMarkup(FacesContext context, Calendar calendar, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        String inputId = clientId + "_input";
        String containerClass = calendar.isPopup() ? "ui-calendar ui-calendar-popup" : "ui-calendar ui-calendar-inline";
        String style = calendar.getStyle();
        String styleClass = calendar.getStyleClass();
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        writer.startElement("div", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeInput(context, calendar, inputId, value);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, Calendar calendar, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (calendar.isReadonly() || calendar.isReadonlyInput()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (calendar.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderPassThruAttributes(context, (UIComponent)calendar, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)calendar, HTML.INPUT_TEXT_EVENTS);
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, Calendar calendar, String value) throws IOException {
        String showOn;
        String beforeShowDay;
        String clientId = calendar.getClientId(context);
        Locale locale = calendar.calculateLocale(context);
        String pattern = calendar.calculatePattern();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Calendar", calendar.resolveWidgetVar(), clientId);
        wb.attr("popup", calendar.isPopup()).attr("locale", locale.toString()).attr("dateFormat", CalendarUtils.convertPattern(pattern));
        Object pagedate = calendar.getPagedate();
        String defaultDate = null;
        if (calendar.isConversionFailed()) {
            defaultDate = CalendarUtils.getValueAsString(context, calendar, new Date());
        } else if (!this.isValueBlank(value)) {
            defaultDate = value;
        } else if (pagedate != null) {
            defaultDate = CalendarUtils.getValueAsString(context, calendar, pagedate);
        }
        wb.attr("defaultDate", defaultDate, null).attr("numberOfMonths", calendar.getPages(), 1).attr("minDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMindate()), null).attr("maxDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMaxdate()), null).attr("showButtonPanel", calendar.isShowButtonPanel(), false).attr("showWeek", calendar.isShowWeek(), false).attr("disabledWeekends", calendar.isDisabledWeekends(), false).attr("disabled", calendar.isDisabled(), false).attr("yearRange", calendar.getYearRange(), null);
        if (calendar.isNavigator()) {
            wb.attr("changeMonth", true).attr("changeYear", true);
        }
        if (calendar.getEffect() != null) {
            wb.attr("showAnim", calendar.getEffect()).attr("duration", calendar.getEffectDuration());
        }
        if ((beforeShowDay = calendar.getBeforeShowDay()) != null) {
            wb.nativeAttr("preShowDay", beforeShowDay);
        }
        if (!(showOn = calendar.getShowOn()).equalsIgnoreCase("focus")) {
            wb.attr("showOn", showOn);
        }
        if (calendar.isShowOtherMonths()) {
            wb.attr("showOtherMonths", true).attr("selectOtherMonths", true);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)calendar);
        wb.finish();
    }
}

