/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project.ui;

import java.awt.Component;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class BaseWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator {
    protected WizardDescriptor descriptor;
    private int index;
    private WizardDescriptor.Panel[] panels;

    protected abstract WizardDescriptor.Panel[] createPanels(ValidationGroup var1);

    public void initialize(WizardDescriptor descriptor) {
        this.descriptor = descriptor;
        this.index = 0;
        this.panels = this.createPanels(ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(descriptor)}));
        this.updateSteps();
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.descriptor.putProperty("projdir", null);
        this.descriptor.putProperty("name", null);
        this.descriptor = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(BaseWizardIterator.class, (String)"LBL_NameFormat", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private void updateSteps() {
        String[] steps = new String[this.panels.length];
        String[] basicOnes = new String[]{NbBundle.getMessage(BaseWizardIterator.class, (String)"LBL_MavenProjectSettings"), NbBundle.getMessage(BaseWizardIterator.class, (String)"LBL_PayaraMicroSettings")};
        System.arraycopy(basicOnes, 0, steps, 0, basicOnes.length);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (i >= basicOnes.length || steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }
}

